/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.ParseException;
import io.smallrye.jwt.auth.principal.PrincipalMessages;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.UnresolvableKeyException;

public class PrincipalMessages_$bundle
implements PrincipalMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final PrincipalMessages_$bundle INSTANCE = new PrincipalMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected PrincipalMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String failedToVerifyToken$str() {
        return "SRJWT07000: Failed to verify a token";
    }

    @Override
    public final ParseException failedToVerifyToken(Throwable throwable) {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.failedToVerifyToken$str(), new Object[0]), throwable);
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String claimNotFound$str() {
        return "SRJWT07001: No claim exists in sub, upn or preferred_username";
    }

    @Override
    public final InvalidJwtException claimNotFound(Function<String, InvalidJwtException> fn) {
        InvalidJwtException result = fn.apply(String.format(this.getLoggingLocale(), this.claimNotFound$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadKey$str() {
        return "SRJWT07002: Failed to load a key from the key content";
    }

    @Override
    public final UnresolvableKeyException failedToLoadKey(Throwable throwable) {
        UnresolvableKeyException result = new UnresolvableKeyException(String.format(this.getLoggingLocale(), this.failedToLoadKey$str(), new Object[0]), throwable);
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadKeyFromLocation$str() {
        return "SRJWT07003: Failed to load a key from %s";
    }

    @Override
    public final UnresolvableKeyException failedToLoadKeyFromLocation(String location, Throwable throwable) {
        UnresolvableKeyException result = new UnresolvableKeyException(String.format(this.getLoggingLocale(), this.failedToLoadKeyFromLocation$str(), location), throwable);
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadKeyWhileResolving$str() {
        return "SRJWT07004: Failed to load a key from the key content while resolving";
    }

    @Override
    public final UnresolvableKeyException failedToLoadKeyWhileResolving() {
        UnresolvableKeyException result = new UnresolvableKeyException(String.format(this.getLoggingLocale(), this.failedToLoadKeyWhileResolving$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadKeyFromLocationWhileResolving$str() {
        return "SRJWT07005: Failed to load a key from %s property while resolving";
    }

    @Override
    public final UnresolvableKeyException failedToLoadKeyFromLocationWhileResolving(String location) {
        UnresolvableKeyException result = new UnresolvableKeyException(String.format(this.getLoggingLocale(), this.failedToLoadKeyFromLocationWhileResolving$str(), location));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTokenKid$str() {
        return "SRJWT07006: Invalid token 'kid' header";
    }

    @Override
    public final UnresolvableKeyException invalidTokenKid() {
        UnresolvableKeyException result = new UnresolvableKeyException(String.format(this.getLoggingLocale(), this.invalidTokenKid$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String resourceNotFound$str() {
        return "SRJWT07007: No resource with the named %s location exists";
    }

    @Override
    public final IOException resourceNotFound(String resourceName) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.resourceNotFound$str(), resourceName));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIatExp$str() {
        return "SRJWT07008: Invalid 'iat' or 'exp' claim value";
    }

    @Override
    public final ParseException invalidIatExp() {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.invalidIatExp$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expExceeded$str() {
        return "SRJWT07009: The Expiration Time (exp=%s) claim value cannot be more than %d seconds in the future relative to Issued At (iat=%s) claim value";
    }

    @Override
    public final ParseException expExceeded(NumericDate exp, long maxTimeToLiveSecs, NumericDate iat) {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.expExceeded$str(), exp, maxTimeToLiveSecs, iat));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingClaims$str() {
        return "SRJWT07010: Required claims are not present in the JWT";
    }

    @Override
    public final InvalidJwtException missingClaims(Function<String, InvalidJwtException> fn) {
        InvalidJwtException result = fn.apply(String.format(this.getLoggingLocale(), this.missingClaims$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String verificationKeyUnresolvable$str() {
        return "SRJWT07011: Verification key is unresolvable";
    }

    @Override
    public final ParseException verificationKeyUnresolvable() {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.verificationKeyUnresolvable$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String decryptionKeyUnresolvable$str() {
        return "SRJWT07012: Decryption key is unresolvable";
    }

    @Override
    public final ParseException decryptionKeyUnresolvable(Throwable throwable) {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.decryptionKeyUnresolvable$str(), new Object[0]), throwable);
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptedTokenSequenceInvalid$str() {
        return "SRJWT07013: Encrypted token sequence is invalid";
    }

    @Override
    public final ParseException encryptedTokenSequenceInvalid(Throwable throwable) {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.encryptedTokenSequenceInvalid$str(), new Object[0]), throwable);
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadCertificates$str() {
        return "SRJWT07014: Failed to load X509 certificates";
    }

    @Override
    public final ParseException failedToLoadCertificates() {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.failedToLoadCertificates$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToVerifyIatExp$str() {
        return "SRJWT07015: The Expiration Time (exp=%s) claim value cannot be less than Issued At (iat=%s) claim value";
    }

    @Override
    public final ParseException failedToVerifyIatExp(NumericDate exp, NumericDate iat) {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.failedToVerifyIatExp$str(), exp, iat));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptedTokenMissingContentType$str() {
        return "SRJWT07016: Encrypted token headers must contain a content type header";
    }

    @Override
    public final ParseException encryptedTokenMissingContentType() {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.encryptedTokenMissingContentType$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String newJWTCallerPrincipalFactoryFailure$str() {
        return "SRJWT07017: New JWTCallerPrincipalFactory instance can not be created";
    }

    @Override
    public final ParseException newJWTCallerPrincipalFactoryFailure(Throwable throwable) {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.newJWTCallerPrincipalFactoryFailure$str(), new Object[0]), throwable);
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenAgeExceeded$str() {
        return "SRJWT07018: The token age has exceeded %d seconds";
    }

    @Override
    public final ParseException tokenAgeExceeded(long tokenAge) {
        ParseException result = new ParseException(String.format(this.getLoggingLocale(), this.tokenAgeExceeded$str(), tokenAge));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullKeyLocation$str() {
        return "SRJWT07019: Required key location is null";
    }

    @Override
    public final UnresolvableKeyException nullKeyLocation() {
        UnresolvableKeyException result = new UnresolvableKeyException(String.format(this.getLoggingLocale(), this.nullKeyLocation$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullKeyIdentifier$str() {
        return "SRJWT07020: Required key identifier is null";
    }

    @Override
    public final UnresolvableKeyException nullKeyIdentifier() {
        UnresolvableKeyException result = new UnresolvableKeyException(String.format(this.getLoggingLocale(), this.nullKeyIdentifier$str(), new Object[0]));
        PrincipalMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

