/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.principal.AwsAlbKeyResolverLogging;
import io.smallrye.jwt.auth.principal.AwsAlbKeyResolverMessages;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.PrincipalMessages;
import java.net.URI;
import org.jose4j.lang.UnresolvableKeyException;

interface AwsAlbKeyConfigurationValidator {
    public static void validateKeyConfiguration(JWTAuthContextInfo authContextInfo) throws UnresolvableKeyException {
        String publicKeyLocation = authContextInfo.getPublicKeyLocation();
        if (publicKeyLocation == null) {
            throw PrincipalMessages.msg.nullKeyLocation();
        }
        if (AwsAlbKeyConfigurationValidator.containsSubPath(publicKeyLocation)) {
            throw AwsAlbKeyResolverMessages.msg.subPathNotAllowed();
        }
    }

    public static void validatePublicKeyAlgorithmConfiguration(JWTAuthContextInfo authContextInfo) {
        SignatureAlgorithm publicKeyAlgorithm = authContextInfo.getSignatureAlgorithm();
        if (publicKeyAlgorithm == null) {
            AwsAlbKeyResolverLogging.log.publicKeyAlgorithmNotSet();
        }
        if (!publicKeyAlgorithm.getAlgorithm().equals(SignatureAlgorithm.ES256.getAlgorithm())) {
            AwsAlbKeyResolverLogging.log.publicKeyAlgorithmNotSetToES256();
        }
    }

    public static void validateTokenHeaderConfiguration(JWTAuthContextInfo authContextInfo) {
        String tokenHeader = authContextInfo.getTokenHeader();
        if (tokenHeader == null || !"X-Amzn-Oidc-Data".equals(tokenHeader)) {
            AwsAlbKeyResolverLogging.log.invalidAWSTokenHeader();
        }
    }

    public static String removeEndingSlash(String uri) {
        if (!uri.endsWith("/") || uri.length() == 1) {
            return uri;
        }
        int length = uri.length();
        return uri.substring(0, length - 1);
    }

    public static boolean containsSubPath(String publicKeyLocation) {
        String locationWithoutSlash = AwsAlbKeyConfigurationValidator.removeEndingSlash(publicKeyLocation);
        URI uri = URI.create(locationWithoutSlash);
        return uri.getPath().contains("/");
    }
}

