/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.runtime.util.ModelUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Properties;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public final class VersionUtil {
    static final String MP_VERSION = ModelUtil.supply(() -> {
        String string;
        block8: {
            InputStream pomProperties = OpenAPI.class.getResourceAsStream("/META-INF/maven/org.eclipse.microprofile.openapi/microprofile-openapi-api/pom.properties");
            try {
                Properties p = new Properties();
                p.load(pomProperties);
                string = p.getProperty("version");
                if (pomProperties == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pomProperties != null) {
                        try {
                            pomProperties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            pomProperties.close();
        }
        return string;
    });
    static final String[] MP_VERSION_COMPONENTS = ModelUtil.supply(() -> {
        int suffix = MP_VERSION.indexOf(45);
        return (suffix > -1 ? MP_VERSION.substring(0, suffix) : MP_VERSION).split("\\.");
    });

    private VersionUtil() {
    }

    public static int compareMicroProfileVersion(String checkVersion) {
        int cv;
        int mp;
        String[] checkComponents = checkVersion.split("\\.");
        int max = Math.max(MP_VERSION_COMPONENTS.length, checkComponents.length);
        int result = 0;
        for (int i = 0; i < max && (result = Integer.compare(mp = VersionUtil.component(MP_VERSION_COMPONENTS, i), cv = VersionUtil.component(checkComponents, i))) == 0; ++i) {
        }
        return result;
    }

    static int component(String[] components, int offset) {
        return offset < components.length ? Integer.parseInt(components[offset]) : 0;
    }
}

