/*
 * Decompiled with CFR 0.152.
 */
package strikt.internal.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import strikt.internal.ComparedValues;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\u001a\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\u001a\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u0005*\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"FORMATTED_VALUE_MAX_LENGTH", "", "hexArray", "", "formatValue", "", "value", "formatValues", "Lstrikt/internal/ComparedValues;", "preferToString", "", "Ljava/lang/Class;", "toHex", "", "", "truncate", "", "maxLength", "withTypeSuffix", "typeOf", "strikt-core"})
public final class FormattingKt {
    @NotNull
    private static final char[] hexArray;
    public static final int FORMATTED_VALUE_MAX_LENGTH = 40;

    @NotNull
    public static final ComparedValues formatValues(@NotNull ComparedValues $this$formatValues) {
        Intrinsics.checkNotNullParameter((Object)$this$formatValues, (String)"<this>");
        Object e = FormattingKt.formatValue($this$formatValues.getExpected());
        Object a = FormattingKt.formatValue($this$formatValues.getActual());
        return Intrinsics.areEqual((Object)e.toString(), (Object)a.toString()) ? new ComparedValues(FormattingKt.withTypeSuffix(e, $this$formatValues.getExpected()), FormattingKt.withTypeSuffix(a, $this$formatValues.getActual())) : new ComparedValues(e, a);
    }

    private static final Object withTypeSuffix(Object $this$withTypeSuffix, Object typeOf) {
        return typeOf == null ? $this$withTypeSuffix : $this$withTypeSuffix + " (" + JvmClassMappingKt.getKotlinClass(typeOf.getClass()).getSimpleName() + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Object formatValue(@Nullable Object value) {
        Object object;
        Object object2 = value;
        if (object2 == null) {
            object = "null";
        } else if (object2 instanceof CharSequence) {
            object = "" + '\"' + value + '\"';
        } else if (object2 instanceof Character) {
            object = "" + '\'' + value + '\'';
        } else if (object2 instanceof Iterable) {
            if (FormattingKt.preferToString(value.getClass())) {
                object = value.toString();
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void p0;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(FormattingKt.formatValue(p0));
                }
                object = (List)destination$iv$iv;
            }
        } else if (object2 instanceof Byte) {
            String $this$mapTo$iv$iv = Integer.toString(((Number)value).byteValue(), CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv, (String)"toString(this, checkRadix(radix))");
            object = Intrinsics.stringPlus((String)"0x", (Object)$this$mapTo$iv$iv);
        } else if (object2 instanceof byte[]) {
            object = FormattingKt.truncate$default(Intrinsics.stringPlus((String)"0x", (Object)FormattingKt.toHex((byte[])value)), 0, 1, null);
        } else if (object2 instanceof char[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((char[])((char[])value)));
        } else if (object2 instanceof short[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((short[])((short[])value)));
        } else if (object2 instanceof int[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((int[])((int[])value)));
        } else if (object2 instanceof long[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((long[])((long[])value)));
        } else if (object2 instanceof float[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((float[])((float[])value)));
        } else if (object2 instanceof double[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((double[])((double[])value)));
        } else if (object2 instanceof Object[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((Object[])((Object[])value)));
        } else if (object2 instanceof Class) {
            String $this$map$iv = ((Class)value).getName();
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"value.name");
            object = $this$map$iv;
        } else if (object2 instanceof Regex) {
            object = '/' + ((Regex)value).getPattern() + '/';
        } else if (object2 instanceof Throwable) {
            String $this$map$iv = value.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"value.javaClass.name");
            object = $this$map$iv;
        } else if (object2 instanceof CallableReference) {
            object = FormattingKt.formatValue(((CallableReference)value).getBoundReceiver()) + "::" + ((CallableReference)value).getName();
        } else if (object2 instanceof Pair) {
            object = "" + '{' + FormattingKt.formatValue(((Pair)value).getFirst()) + ": " + FormattingKt.formatValue(((Pair)value).getSecond()) + '}';
        } else if (object2 instanceof Map) {
            Map $this$map$iv = (Map)value;
            boolean $i$f$map = false;
            Map $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $dstr$k$v;
                Map.Entry item$iv$iv;
                Map.Entry p0 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object k = $dstr$k$v.getKey();
                Object v = $dstr$k$v.getValue();
                collection.add(TuplesKt.to((Object)FormattingKt.formatValue(k), (Object)FormattingKt.formatValue(v)));
            }
            object = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            object = object2 instanceof Number ? value : value.toString();
        }
        return object;
    }

    private static final boolean preferToString(Class<?> $this$preferToString) {
        return Intrinsics.areEqual($this$preferToString.getMethod("toString", new Class[0]).getDeclaringClass(), $this$preferToString);
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        char[] hexChars = new char[$this$toHex.length * 2];
        int n = 0;
        int n2 = $this$toHex.length;
        while (n < n2) {
            int j = n++;
            int v = $this$toHex[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static final CharSequence truncate(CharSequence $this$truncate, int maxLength) {
        CharSequence charSequence;
        int n = $this$truncate.length();
        boolean bl = 0 <= n ? n <= maxLength : false;
        if (bl) {
            charSequence = $this$truncate;
        } else {
            CharSequence charSequence2 = $this$truncate;
            int n2 = 0;
            charSequence = Intrinsics.stringPlus((String)((Object)charSequence2.subSequence(n2, maxLength)).toString(), (Object)"\u2026");
        }
        return charSequence;
    }

    static /* synthetic */ CharSequence truncate$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 40;
        }
        return FormattingKt.truncate(charSequence, n);
    }

    static {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        hexArray = cArray;
    }
}

