/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.crdgenerator;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;

class PropertyType {
    private final Class<?> type;
    private final Type gType;

    PropertyType(Class<?> type, Type gType) {
        this.type = type;
        this.gType = gType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.gType;
    }

    public boolean isArray() {
        boolean b = this.gType instanceof Class && ((Class)this.gType).equals(List.class) || this.gType instanceof ParameterizedType && ((ParameterizedType)this.gType).getRawType().equals(List.class);
        return this.gType instanceof GenericArrayType || this.gType instanceof Class && ((Class)this.gType).isArray() || b;
    }

    public int arrayDimension() {
        int result = 0;
        Type t = this.gType;
        while (true) {
            if (t instanceof Class) {
                Class c = t;
                if (c.isArray()) {
                    t = c.getComponentType();
                    ++result;
                    continue;
                }
                if (!List.class.equals((Object)c)) break;
                ++result;
                break;
            }
            if (t instanceof GenericArrayType) {
                GenericArrayType g = (GenericArrayType)t;
                t = g.getGenericComponentType();
                ++result;
                continue;
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                if (!List.class.equals((Object)pt.getRawType())) break;
                t = pt.getActualTypeArguments()[0];
                ++result;
                continue;
            }
            if (!(t instanceof WildcardType)) break;
            WildcardType wt = (WildcardType)t;
            t = wt.getUpperBounds()[0];
        }
        return result;
    }

    public Class<?> arrayBase() {
        Class result;
        block13: {
            if (!this.isArray()) {
                return null;
            }
            Type t = this.gType;
            while (true) {
                if (t instanceof Class) {
                    Class c = t;
                    if (c.isArray()) {
                        t = c.getComponentType();
                        continue;
                    }
                    result = List.class.equals((Object)c) ? Object.class : c;
                    break block13;
                }
                if (t instanceof GenericArrayType) {
                    GenericArrayType g = (GenericArrayType)t;
                    t = g.getGenericComponentType();
                    continue;
                }
                if (t instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)t;
                    if (List.class.equals((Object)pt.getRawType())) {
                        t = pt.getActualTypeArguments()[0];
                        continue;
                    }
                    Type rt = pt.getRawType();
                    if (rt instanceof Class) {
                        result = (Class)rt;
                    } else {
                        if (rt instanceof TypeVariable) {
                            t = ((TypeVariable)rt).getBounds()[0];
                            continue;
                        }
                        if (rt instanceof WildcardType) {
                            t = ((WildcardType)rt).getUpperBounds()[0];
                            continue;
                        }
                        result = null;
                    }
                    break block13;
                }
                if (t instanceof TypeVariable) {
                    Type type = ((TypeVariable)t).getBounds()[0];
                    if (type instanceof Class) {
                        result = (Class)type;
                        break block13;
                    }
                    if (!(type instanceof TypeVariable)) continue;
                    t = type;
                    continue;
                }
                if (!(t instanceof WildcardType)) break;
                t = ((WildcardType)t).getUpperBounds()[0];
            }
            result = null;
        }
        return result;
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public Enum[] getEnumElements() {
        if (this.isEnum()) {
            try {
                Method valuesMethod = this.getType().getMethod("values", new Class[0]);
                return (Enum[])valuesMethod.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return new Enum[0];
    }
}

