/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.kafka.KubernetesResourceIdentifier;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractKubernetesConfigProvider<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
implements ConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKubernetesConfigProvider.class);
    protected final String kind;
    protected KubernetesClient client;

    AbstractKubernetesConfigProvider(String kind) {
        this.kind = kind;
    }

    protected abstract MixedOperation<T, L, R> operator();

    protected abstract Map<String, String> valuesFromResource(T var1);

    public void close() throws IOException {
        LOG.info("Closing Kubernetes {} config provider", (Object)this.kind);
        this.client.close();
    }

    public void configure(Map<String, ?> map) {
        LOG.info("Configuring Kubernetes {} config provider", (Object)this.kind);
        this.client = new KubernetesClientBuilder().build();
    }

    public ConfigData get(String path) {
        return this.getValues(path, null);
    }

    public ConfigData get(String path, Set<String> keys) {
        return this.getValues(path, keys);
    }

    private ConfigData getValues(String path, Set<String> keys) {
        Map<String, String> values = this.valuesFromResource(this.getResource(path));
        HashMap<String, String> configs = new HashMap<String, String>(0);
        if (keys == null) {
            configs.putAll(values);
        } else {
            for (Map.Entry<String, String> entry : values.entrySet()) {
                if (!keys.contains(entry.getKey())) continue;
                configs.put(entry.getKey(), entry.getValue());
            }
        }
        return new ConfigData(configs);
    }

    protected T getResource(String path) {
        KubernetesResourceIdentifier resourceIdentifier = KubernetesResourceIdentifier.fromConfigString((Client)this.client, path);
        LOG.info("Retrieving configuration from {} {} in namespace {}", new Object[]{this.kind, resourceIdentifier.getName(), resourceIdentifier.getNamespace()});
        try {
            HasMetadata resource = (HasMetadata)((Resource)((NonNamespaceOperation)this.operator().inNamespace(resourceIdentifier.getNamespace())).withName(resourceIdentifier.getName())).get();
            if (resource == null) {
                throw new ConfigException(this.kind + " " + resourceIdentifier.getName() + " in namespace " + resourceIdentifier.getNamespace() + " not found");
            }
            return (T)resource;
        }
        catch (KubernetesClientException e) {
            LOG.error("Failed to retrieve " + this.kind + " " + resourceIdentifier.getName() + " from Kubernetes namespace " + resourceIdentifier.getNamespace(), (Throwable)e);
            throw new ConfigException("Failed to retrieve " + this.kind + " " + resourceIdentifier.getName() + " from Kubernetes namespace " + resourceIdentifier.getNamespace());
        }
    }
}

