/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.strimzi.kafka.oauth.common.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JSONUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static ObjectNode newObjectNode() {
        return new ObjectNode(MAPPER.getNodeFactory());
    }

    public static <T> T readJSON(InputStream is, Class<T> clazz) throws IOException {
        if (clazz == String.class) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtil.copy(is, baos);
            return clazz.cast(new String(baos.toByteArray(), StandardCharsets.UTF_8));
        }
        return (T)MAPPER.readValue(is, clazz);
    }

    public static <T> T readJSON(String jsonString, Class<T> clazz) throws IOException {
        return (T)MAPPER.readValue(jsonString, clazz);
    }

    public static JsonNode asJson(Object value) {
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        try {
            return (JsonNode)MAPPER.convertValue(value, JsonNode.class);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Failed to convert value to JSON (" + value + ")", e);
        }
    }

    public static String getClaimFromJWT(String claim, Object token) {
        JsonNode node = JSONUtil.asJson(token);
        return JSONUtil.getClaimFromJWT(node, claim.split("\\."));
    }

    public static String getClaimFromJWT(JsonNode node, String ... path) {
        if (path.length == 0) {
            return null;
        }
        for (String p : path) {
            if ((node = node.get(p)) != null) continue;
            return null;
        }
        return node.asText();
    }

    public static List<String> asListOfString(JsonNode arrayOrString) {
        return JSONUtil.asListOfString(arrayOrString, " ");
    }

    public static List<String> asListOfString(JsonNode arrayOrString, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        if (arrayOrString.isTextual()) {
            result.addAll(Arrays.stream(arrayOrString.asText().split(Pattern.quote(delimiter))).map(String::trim).collect(Collectors.toList()));
        } else {
            if (!arrayOrString.isArray()) {
                throw new IllegalArgumentException("JsonNode not a text node, nor an array node: " + arrayOrString);
            }
            for (JsonNode n : arrayOrString) {
                if (n.isTextual()) {
                    result.add(n.asText());
                    continue;
                }
                result.add(n.toString());
            }
        }
        return result;
    }

    public static ArrayNode setArrayOfStringsIfNotNull(JsonNode target, String attrName, Collection<String> elements) {
        if (elements == null) {
            return null;
        }
        if (!(target instanceof ObjectNode)) {
            throw new IllegalArgumentException("Unexpected JSON Node type (not ObjectNode): " + target.getClass());
        }
        ArrayNode list = ((ObjectNode)target).putArray(attrName);
        for (String g : elements) {
            list.add(g);
        }
        return list;
    }

    public static Set<JsonNode> asSetOfNodes(ArrayNode list) {
        HashSet<JsonNode> result = new HashSet<JsonNode>();
        for (JsonNode node : list) {
            result.add(node);
        }
        return result;
    }
}

