/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.services;

import io.strimzi.kafka.oauth.common.BearerTokenWithPayload;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.services.SessionFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sessions {
    private static final Logger log = LoggerFactory.getLogger(Sessions.class);
    private static final Object NONE = new Object();
    private final Map<BearerTokenWithPayload, Object> activeSessions = Collections.synchronizedMap(new WeakHashMap());

    public void put(BearerTokenWithPayload token) {
        this.activeSessions.put(token, NONE);
    }

    public void remove(BearerTokenWithPayload token) {
        this.activeSessions.remove(token);
    }

    public void removeAllWithMatchingAccessToken(String accessToken) {
        ArrayList<BearerTokenWithPayload> values = new ArrayList<BearerTokenWithPayload>(this.activeSessions.keySet());
        for (BearerTokenWithPayload token : values) {
            if (!accessToken.equals(token.value())) continue;
            this.activeSessions.remove(token);
            if (!log.isDebugEnabled()) continue;
            log.debug("Removed invalid session from sessions map (userId: {}, session: {}, token: {})", new Object[]{token.principalName(), token.getSessionId(), LogUtil.mask(token.value())});
        }
    }

    public List<SessionFuture<?>> executeTask(ExecutorService executor, Predicate<BearerTokenWithPayload> filter, Consumer<BearerTokenWithPayload> task) {
        this.cleanupExpired();
        ArrayList<BearerTokenWithPayload> values = new ArrayList<BearerTokenWithPayload>(this.activeSessions.keySet());
        ArrayList results = new ArrayList(values.size());
        for (BearerTokenWithPayload token : values) {
            if (!filter.test(token)) continue;
            SessionFuture current = new SessionFuture(token, executor.submit(() -> task.accept(token)));
            results.add(current);
        }
        return results;
    }

    public void cleanupExpired() {
        ArrayList<BearerTokenWithPayload> values = new ArrayList<BearerTokenWithPayload>(this.activeSessions.keySet());
        long now = System.currentTimeMillis();
        for (BearerTokenWithPayload token : values) {
            if (token.lifetimeMs() > now) continue;
            this.activeSessions.remove(token);
        }
    }

    public <T> List<T> map(Function<BearerTokenWithPayload, T> mapper) {
        this.cleanupExpired();
        ArrayList<BearerTokenWithPayload> values = new ArrayList<BearerTokenWithPayload>(this.activeSessions.keySet());
        return values.stream().map(mapper).collect(Collectors.toList());
    }
}

