/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import io.strimzi.kafka.oauth.common.HttpUtil;
import io.strimzi.kafka.oauth.common.JSONUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.MetricsHandler;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TimeUtil;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.common.TokenProvider;
import io.strimzi.kafka.oauth.jsonpath.JsonPathFilterQuery;
import io.strimzi.kafka.oauth.jsonpath.JsonPathQuery;
import io.strimzi.kafka.oauth.metrics.IntrospectHttpSensorKeyProducer;
import io.strimzi.kafka.oauth.metrics.SensorKeyProducer;
import io.strimzi.kafka.oauth.metrics.UserInfoHttpSensorKeyProducer;
import io.strimzi.kafka.oauth.services.OAuthMetrics;
import io.strimzi.kafka.oauth.services.Services;
import io.strimzi.kafka.oauth.validator.TokenExpiredException;
import io.strimzi.kafka.oauth.validator.TokenValidationException;
import io.strimzi.kafka.oauth.validator.TokenValidator;
import io.strimzi.kafka.oauth.validator.ValidationException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthIntrospectionValidator
implements TokenValidator {
    private static final Logger log = LoggerFactory.getLogger(OAuthIntrospectionValidator.class);
    private final String validatorId;
    private final URI introspectionURI;
    private final String validIssuerURI;
    private final URI userInfoURI;
    private final String validTokenType;
    private final String clientId;
    private final String clientSecret;
    private final TokenProvider bearerTokenProvider;
    private final String audience;
    private final JsonPathFilterQuery customClaimMatcher;
    private final SSLSocketFactory socketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final PrincipalExtractor principalExtractor;
    private final JsonPathQuery groupsMatcher;
    private final String groupsDelimiter;
    private final int connectTimeoutSeconds;
    private final int readTimeoutSeconds;
    private final int retries;
    private final long retryPauseMillis;
    private final boolean enableMetrics;
    private final OAuthMetrics metrics;
    private final MetricsHandler introspectMetricsHandler;
    private final MetricsHandler userInfoMetricsHandler;
    private final SensorKeyProducer introspectHttpSensorKeyProducer;
    private final SensorKeyProducer userInfoHttpSensorKeyProducer;
    private final boolean includeAcceptHeader;

    public OAuthIntrospectionValidator(String id, String clientId, String clientSecret, TokenProvider bearerTokenProvider, String introspectionEndpointUri, SSLSocketFactory socketFactory, HostnameVerifier verifier, PrincipalExtractor principalExtractor, String groupsClaimQuery, String groupsClaimDelimiter, String issuerUri, String userInfoUri, String validTokenType, String audience, String customClaimCheck, int connectTimeoutSeconds, int readTimeoutSeconds, boolean enableMetrics, int retries, long retryPauseMillis, boolean includeAcceptHeader) {
        this.validatorId = this.checkValidatorId(id);
        this.introspectionURI = this.checkIntrospectionUri(introspectionEndpointUri);
        this.socketFactory = this.checkSocketFactory(socketFactory);
        this.hostnameVerifier = this.checkHostnameVerifier(verifier);
        this.principalExtractor = principalExtractor != null ? principalExtractor : new PrincipalExtractor();
        this.groupsMatcher = this.parseGroupsQuery(groupsClaimQuery);
        this.groupsDelimiter = this.parseGroupsDelimiter(groupsClaimDelimiter);
        this.validIssuerURI = OAuthIntrospectionValidator.checkIssuerUri(issuerUri);
        this.userInfoURI = this.checkUserInfoUri(userInfoUri);
        this.validTokenType = validTokenType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.bearerTokenProvider = bearerTokenProvider;
        OAuthIntrospectionValidator.checkAuthorizationOptions(clientId, bearerTokenProvider);
        this.audience = audience;
        this.customClaimMatcher = this.parseCustomClaimCheck(customClaimCheck);
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        this.readTimeoutSeconds = readTimeoutSeconds;
        this.retries = retries;
        this.retryPauseMillis = retryPauseMillis;
        this.enableMetrics = enableMetrics;
        this.metrics = enableMetrics ? Services.getInstance().getMetrics() : null;
        this.introspectMetricsHandler = new IntrospectMetricsHandler();
        this.userInfoMetricsHandler = new UserInfoMetricsHandler();
        this.introspectHttpSensorKeyProducer = new IntrospectHttpSensorKeyProducer(this.validatorId, this.introspectionURI);
        this.userInfoHttpSensorKeyProducer = this.userInfoURI != null ? new UserInfoHttpSensorKeyProducer(this.validatorId, this.userInfoURI) : null;
        this.includeAcceptHeader = includeAcceptHeader;
        if (log.isDebugEnabled()) {
            log.debug("Configured OAuthIntrospectionValidator:\n\t  id: " + id + "\n\t  introspectionEndpointUri: " + this.introspectionURI + "\n\t  sslSocketFactory: " + socketFactory + "\n\t  hostnameVerifier: " + this.hostnameVerifier + "\n\t  principalExtractor: " + principalExtractor + "\n\t  groupsClaimQuery: " + groupsClaimQuery + "\n\t  groupsClaimDelimiter: " + groupsClaimDelimiter + "\n\t  validIssuerUri: " + this.validIssuerURI + "\n\t  userInfoUri: " + this.userInfoURI + "\n\t  validTokenType: " + validTokenType + "\n\t  clientId: " + clientId + "\n\t  clientSecret: " + LogUtil.mask(clientSecret) + "\n\t  bearerTokenProvider: " + bearerTokenProvider + "\n\t  audience: " + audience + "\n\t  customClaimCheck: " + customClaimCheck + "\n\t  connectTimeoutSeconds: " + connectTimeoutSeconds + "\n\t  readTimeoutSeconds: " + readTimeoutSeconds + "\n\t  enableMetrics: " + enableMetrics + "\n\t  retries: " + retries + "\n\t  retryPauseMillis: " + retryPauseMillis + "\n\t  includeAcceptHeader: " + includeAcceptHeader);
        }
    }

    private static void checkAuthorizationOptions(String clientId, TokenProvider bearerTokenProvider) {
        if (clientId != null && bearerTokenProvider != null) {
            throw new IllegalArgumentException("Can't use both clientId and bearerToken");
        }
    }

    private HostnameVerifier checkHostnameVerifier(HostnameVerifier verifier) {
        if (verifier != null && !"https".equals(this.introspectionURI.getScheme())) {
            throw new IllegalArgumentException("Certificate hostname verifier set but introspectionEndpointUri not 'https'");
        }
        return verifier;
    }

    private URI checkUserInfoUri(String userInfoUri) {
        if (userInfoUri != null) {
            try {
                return new URI(userInfoUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid userInfo uri: " + userInfoUri, e);
            }
        }
        return null;
    }

    private static String checkIssuerUri(String issuerUri) {
        if (issuerUri != null) {
            try {
                new URI(issuerUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid issuer uri: " + issuerUri, e);
            }
        }
        return issuerUri;
    }

    private SSLSocketFactory checkSocketFactory(SSLSocketFactory socketFactory) {
        if (socketFactory != null && !"https".equals(this.introspectionURI.getScheme())) {
            throw new IllegalArgumentException("SSL socket factory set but introspectionEndpointUri not 'https'");
        }
        return socketFactory;
    }

    private URI checkIntrospectionUri(String introspectionEndpointUri) {
        if (introspectionEndpointUri == null) {
            throw new IllegalArgumentException("introspectionEndpointUri == null");
        }
        try {
            return new URI(introspectionEndpointUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid introspection endpoint uri: " + introspectionEndpointUri, e);
        }
    }

    private String checkValidatorId(String validatorId) {
        if (validatorId == null) {
            throw new IllegalArgumentException("validatorId == null");
        }
        return validatorId;
    }

    private JsonPathFilterQuery parseCustomClaimCheck(String customClaimCheck) {
        if (customClaimCheck != null) {
            String query = customClaimCheck.trim();
            if (query.isEmpty()) {
                throw new IllegalArgumentException("Value of customClaimCheck is empty");
            }
            return JsonPathFilterQuery.parse(query);
        }
        return null;
    }

    private JsonPathQuery parseGroupsQuery(String groupsQuery) {
        if (groupsQuery != null) {
            String query = groupsQuery.trim();
            if (query.isEmpty()) {
                throw new IllegalArgumentException("Value of groupsClaimQuery is empty");
            }
            return JsonPathQuery.parse(query);
        }
        return null;
    }

    private String parseGroupsDelimiter(String groupsDelimiter) {
        if (groupsDelimiter != null && groupsDelimiter.isEmpty()) {
            throw new IllegalArgumentException("Value of groupsClaimDelimiter is empty");
        }
        return ",";
    }

    @Override
    public TokenInfo validate(String token) {
        JsonNode response;
        String authorization = this.generateAuthorizationHeader();
        StringBuilder body = new StringBuilder("token=").append(token);
        try {
            response = HttpUtil.doWithRetries(this.retries, this.retryPauseMillis, this.introspectMetricsHandler, () -> HttpUtil.post(this.introspectionURI, this.socketFactory, this.hostnameVerifier, authorization, "application/x-www-form-urlencoded", body.toString(), JsonNode.class, this.connectTimeoutSeconds, this.readTimeoutSeconds, this.includeAcceptHeader));
        }
        catch (Throwable e) {
            Throwable cause = e;
            if (e instanceof ExecutionException) {
                cause = e.getCause();
            }
            if (cause instanceof IOException) {
                throw new ValidationException("Failed to introspect token - send, fetch or parse failed: ", cause);
            }
            throw new ValidationException("Unexpected exception while calling the Introspection endpoint: ", cause);
        }
        JsonNode activeAttr = response.get("active");
        if (!(activeAttr instanceof BooleanNode)) {
            throw new ValidationException("Failed to introspect token - invalid response: \"active\" attribute is missing or not a boolean (" + activeAttr + ")");
        }
        boolean active = activeAttr.asBoolean();
        if (!active) {
            throw new TokenValidationException("Token validation failed: Token not active");
        }
        JsonNode value = response.get("exp");
        if (value == null) {
            throw new IllegalStateException("Introspection response contains no expires information (\"exp\"): " + response);
        }
        long expiresMillis = 1000L * value.asLong();
        if (Time.SYSTEM.milliseconds() > expiresMillis) {
            throw new TokenExpiredException("The token expired at: " + expiresMillis + " (" + TimeUtil.formatIsoDateTimeUTC(expiresMillis) + ")");
        }
        value = response.get("iat");
        long iat = value == null ? 0L : 1000L * value.asLong();
        String principal = this.principalExtractor.getPrincipal(response);
        JsonNode fallbackResponse = null;
        if (principal == null) {
            if (this.userInfoURI != null) {
                fallbackResponse = this.getUserInfoEndpointResponse(token);
                principal = this.getPrincipalFromUserInfoEndpoint(fallbackResponse);
            }
            if (principal == null && !this.principalExtractor.isConfigured()) {
                principal = this.principalExtractor.getSub(response);
            }
            if (principal == null) {
                throw new ValidationException("Failed to extract principal - check usernameClaim, fallbackUsernameClaim configuration");
            }
        }
        this.performOptionalChecks(response);
        Set<String> groups = null;
        if (this.groupsMatcher != null && (groups = this.extractGroupsFromResponse(response)) == null && fallbackResponse != null) {
            groups = this.extractGroupsFromResponse(fallbackResponse);
        }
        String scopes = (value = response.get("scope")) != null ? String.join((CharSequence)" ", JSONUtil.asListOfString(value)) : null;
        return new TokenInfo(token, scopes, principal, groups, iat, expiresMillis);
    }

    private String generateAuthorizationHeader() {
        String authorization = null;
        if (this.bearerTokenProvider != null) {
            authorization = "Bearer " + this.bearerTokenProvider.token();
        } else if (this.clientId != null) {
            authorization = "Basic " + OAuthAuthenticator.base64encode(this.clientId + ':' + this.clientSecret);
        }
        return authorization;
    }

    private Set<String> extractGroupsFromResponse(JsonNode userInfoJson) {
        JsonNode result = this.groupsMatcher.apply(userInfoJson);
        if (result == null) {
            return null;
        }
        List<String> groups = JSONUtil.asListOfString(result, this.groupsDelimiter != null ? this.groupsDelimiter : ",");
        return groups.stream().map(String::trim).filter(v -> !v.isEmpty()).collect(Collectors.toSet());
    }

    private JsonNode getUserInfoEndpointResponse(String token) {
        JsonNode response;
        String authorization = "Bearer " + token;
        try {
            response = HttpUtil.doWithRetries(this.retries, this.retryPauseMillis, this.userInfoMetricsHandler, () -> HttpUtil.get(this.userInfoURI, this.socketFactory, this.hostnameVerifier, authorization, JsonNode.class, this.connectTimeoutSeconds, this.readTimeoutSeconds, this.includeAcceptHeader));
        }
        catch (Throwable e) {
            Throwable cause = e;
            if (cause instanceof ExecutionException) {
                cause = cause.getCause();
            }
            if (cause instanceof IOException) {
                throw new ValidationException("Request to User Info Endpoint failed: ", cause);
            }
            throw new ValidationException("Unexpected exception while calling the User Info endpoint: ", cause);
        }
        return response;
    }

    private String getPrincipalFromUserInfoEndpoint(JsonNode userInfoJson) {
        String principal = this.principalExtractor.getPrincipal(userInfoJson);
        if (principal == null && !this.principalExtractor.isConfigured()) {
            principal = this.principalExtractor.getSub(userInfoJson);
        }
        return principal;
    }

    private void performOptionalChecks(JsonNode response) {
        JsonNode value;
        if (!(this.validIssuerURI == null || (value = response.get("iss")) != null && this.validIssuerURI.equals(value.asText()))) {
            throw new TokenValidationException("Token check failed - Invalid issuer: " + value).status(TokenValidationException.Status.INVALID_TOKEN);
        }
        if (!(this.validTokenType == null || (value = response.get("token_type")) != null && this.validTokenType.equals(value.asText()))) {
            throw new TokenValidationException("Token check failed - Invalid token type: " + value + " (should be '" + this.validTokenType + "')" + (value == null ? ". Consider not setting 'oauth.valid.token.type'" : "")).status(TokenValidationException.Status.UNSUPPORTED_TOKEN_TYPE);
        }
        if (this.audience != null) {
            List<Object> audienceList;
            value = response.get("aud");
            List<Object> list = audienceList = value != null ? JSONUtil.asListOfString(value) : Collections.emptyList();
            if (!audienceList.contains(this.audience)) {
                throw new TokenValidationException("Token check failed - Invalid audience: " + value).status(TokenValidationException.Status.INVALID_TOKEN);
            }
        }
        if (this.customClaimMatcher != null && !this.customClaimMatcher.matches(response)) {
            throw new TokenValidationException("Token check failed - Custom claim check failed.").status(TokenValidationException.Status.INVALID_TOKEN);
        }
    }

    @Override
    public String getValidatorId() {
        return this.validatorId;
    }

    @Override
    public void close() {
    }

    class UserInfoMetricsHandler
    implements MetricsHandler {
        UserInfoMetricsHandler() {
        }

        @Override
        public void addSuccessRequestTime(long millis) {
            if (OAuthIntrospectionValidator.this.enableMetrics) {
                OAuthIntrospectionValidator.this.metrics.addTime(OAuthIntrospectionValidator.this.userInfoHttpSensorKeyProducer.successKey(), millis);
            }
        }

        @Override
        public void addErrorRequestTime(Throwable e, long millis) {
            if (OAuthIntrospectionValidator.this.enableMetrics) {
                OAuthIntrospectionValidator.this.metrics.addTime(OAuthIntrospectionValidator.this.userInfoHttpSensorKeyProducer.errorKey(e), millis);
            }
        }
    }

    class IntrospectMetricsHandler
    implements MetricsHandler {
        IntrospectMetricsHandler() {
        }

        @Override
        public void addSuccessRequestTime(long millis) {
            if (OAuthIntrospectionValidator.this.enableMetrics) {
                OAuthIntrospectionValidator.this.metrics.addTime(OAuthIntrospectionValidator.this.introspectHttpSensorKeyProducer.successKey(), millis);
            }
        }

        @Override
        public void addErrorRequestTime(Throwable e, long millis) {
            if (OAuthIntrospectionValidator.this.enableMetrics) {
                OAuthIntrospectionValidator.this.metrics.addTime(OAuthIntrospectionValidator.this.introspectHttpSensorKeyProducer.errorKey(e), millis);
            }
        }
    }
}

