/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import io.strimzi.kafka.oauth.common.HttpUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.MetricsHandler;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.common.TokenIntrospection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(OAuthAuthenticator.class);

    public static TokenInfo loginWithAccessToken(String token, boolean isJwt, PrincipalExtractor principalExtractor) {
        if (log.isDebugEnabled()) {
            log.debug("loginWithAccessToken() - pass-through access_token: {}", (Object)LogUtil.mask(token));
        }
        if (token == null) {
            throw new IllegalArgumentException("No access token specified");
        }
        if (isJwt) {
            try {
                return TokenIntrospection.introspectAccessToken(token, principalExtractor);
            }
            catch (Exception e) {
                log.debug("[IGNORED] Could not parse token as JWT access token. Could not extract scope, subject, and expiry.", (Throwable)e);
            }
        }
        return new TokenInfo(token, "undefined", "undefined", null, System.currentTimeMillis(), System.currentTimeMillis() + 31536000000L);
    }

    public static TokenInfo loginWithClientSecret(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, boolean includeAcceptHeader) throws IOException {
        return OAuthAuthenticator.loginWithClientSecret(tokenEndpointUrl, socketFactory, hostnameVerifier, clientId, clientSecret, isJwt, principalExtractor, scope, null, HttpUtil.DEFAULT_CONNECT_TIMEOUT, HttpUtil.DEFAULT_READ_TIMEOUT, null, 0, 0L, includeAcceptHeader, "client_credentials");
    }

    public static TokenInfo loginWithClientSecret(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, boolean includeAcceptHeader) throws IOException {
        return OAuthAuthenticator.loginWithClientSecret(tokenEndpointUrl, socketFactory, hostnameVerifier, clientId, clientSecret, isJwt, principalExtractor, scope, audience, HttpUtil.DEFAULT_CONNECT_TIMEOUT, HttpUtil.DEFAULT_READ_TIMEOUT, null, 0, 0L, includeAcceptHeader, "client_credentials");
    }

    public static TokenInfo loginWithClientSecret(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, int connectTimeout, int readTimeout, MetricsHandler metrics, int retries, long retryPauseMillis, boolean includeAcceptHeader, String grantType) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("loginWithClientSecret() - tokenEndpointUrl: {}, clientId: {}, clientSecret: {}, grantType:{}. scope: {}, audience: {}, connectTimeout: {}, readTimeout: {}, retries: {}, retryPauseMillis: {}", new Object[]{tokenEndpointUrl, clientId, LogUtil.mask(clientSecret), grantType, scope, audience, connectTimeout, readTimeout, retries, retryPauseMillis});
        }
        if (clientId == null) {
            throw new IllegalArgumentException("No clientId specified");
        }
        if (clientSecret == null) {
            clientSecret = "";
        }
        String authorization = "Basic " + OAuthAuthenticator.base64encode(clientId + ":" + clientSecret);
        if (grantType == null) {
            grantType = "client_credentials";
        }
        StringBuilder body = new StringBuilder("grant_type=" + OAuthAuthenticator.urlencode(grantType));
        if (scope != null) {
            body.append("&scope=").append(OAuthAuthenticator.urlencode(scope));
        }
        if (audience != null) {
            body.append("&audience=").append(OAuthAuthenticator.urlencode(audience));
        }
        return OAuthAuthenticator.post(tokenEndpointUrl, socketFactory, hostnameVerifier, authorization, body.toString(), isJwt, principalExtractor, connectTimeout, readTimeout, metrics, retries, retryPauseMillis, includeAcceptHeader);
    }

    public static TokenInfo loginWithClientAssertion(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientAssertion, String clientAssertionType, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience) throws IOException {
        return OAuthAuthenticator.loginWithClientAssertion(tokenEndpointUrl, socketFactory, hostnameVerifier, clientId, clientAssertion, clientAssertionType, isJwt, principalExtractor, scope, audience, HttpUtil.DEFAULT_CONNECT_TIMEOUT, HttpUtil.DEFAULT_READ_TIMEOUT, null, 0, 0L, true, "client_credentials");
    }

    public static TokenInfo loginWithClientAssertion(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientAssertion, String clientAssertionType, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, int connectTimeout, int readTimeout, MetricsHandler metrics, int retries, long retryPauseMillis, boolean includeAcceptHeader, String grantType) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("loginWithClientAssertion() - tokenEndpointUrl: {}, clientId: {}, grantType: {}. clientAssertion: {}, clientAssertionType: {}, scope: {}, audience: {}, connectTimeout: {}, readTimeout: {}, retries: {}, retryPauseMillis: {}", new Object[]{tokenEndpointUrl, clientId, grantType, LogUtil.mask(clientAssertion), clientAssertionType, scope, audience, connectTimeout, readTimeout, retries, retryPauseMillis});
        }
        if (clientId == null) {
            throw new IllegalArgumentException("No clientId specified");
        }
        if (grantType == null) {
            grantType = "client_credentials";
        }
        StringBuilder body = new StringBuilder("grant_type=" + OAuthAuthenticator.urlencode(grantType)).append("&client_id=").append(OAuthAuthenticator.urlencode(clientId)).append("&client_assertion=").append(OAuthAuthenticator.urlencode(clientAssertion)).append("&client_assertion_type=").append(OAuthAuthenticator.urlencode(clientAssertionType));
        if (scope != null) {
            body.append("&scope=").append(OAuthAuthenticator.urlencode(scope));
        }
        if (audience != null) {
            body.append("&audience=").append(OAuthAuthenticator.urlencode(audience));
        }
        return OAuthAuthenticator.post(tokenEndpointUrl, socketFactory, hostnameVerifier, null, body.toString(), isJwt, principalExtractor, connectTimeout, readTimeout, metrics, retries, retryPauseMillis, includeAcceptHeader);
    }

    public static TokenInfo loginWithPassword(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String username, String password, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, boolean includeAcceptHeader) throws IOException {
        return OAuthAuthenticator.loginWithPassword(tokenEndpointUrl, socketFactory, hostnameVerifier, username, password, clientId, clientSecret, isJwt, principalExtractor, scope, audience, HttpUtil.DEFAULT_CONNECT_TIMEOUT, HttpUtil.DEFAULT_READ_TIMEOUT, null, 0, 0L, includeAcceptHeader);
    }

    public static TokenInfo loginWithPassword(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String username, String password, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, int connectTimeout, int readTimeout, int retries, long retryPauseMillis, boolean includeAcceptHeader) throws IOException {
        return OAuthAuthenticator.loginWithPassword(tokenEndpointUrl, socketFactory, hostnameVerifier, username, password, clientId, clientSecret, isJwt, principalExtractor, scope, audience, connectTimeout, readTimeout, null, retries, retryPauseMillis, includeAcceptHeader);
    }

    public static TokenInfo loginWithPassword(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String username, String password, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, int connectTimeout, int readTimeout, MetricsHandler metrics, int retries, long retryPauseMillis, boolean includeAcceptHeader) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("loginWithPassword() - tokenEndpointUrl: {}, username: {}, password: {}, clientId: {}, clientSecret: {}, scope: {}, audience: {}, connectTimeout: {}, readTimeout: {}, retries: {}, retryPauseMillis: {}", new Object[]{tokenEndpointUrl, username, LogUtil.mask(password), clientId, LogUtil.mask(clientSecret), scope, audience, connectTimeout, readTimeout, retries, retryPauseMillis});
        }
        if (username == null) {
            throw new IllegalArgumentException("No username specified");
        }
        if (clientId == null) {
            throw new IllegalArgumentException("No clientId specified");
        }
        if (clientSecret == null) {
            clientSecret = "";
        }
        String authorization = "Basic " + OAuthAuthenticator.base64encode(clientId + ":" + clientSecret);
        StringBuilder body = new StringBuilder("grant_type=password");
        body.append("&username=").append(OAuthAuthenticator.urlencode(username));
        body.append("&password=").append(OAuthAuthenticator.urlencode(password));
        if (scope != null) {
            body.append("&scope=").append(OAuthAuthenticator.urlencode(scope));
        }
        if (audience != null) {
            body.append("&audience=").append(OAuthAuthenticator.urlencode(audience));
        }
        return OAuthAuthenticator.post(tokenEndpointUrl, socketFactory, hostnameVerifier, authorization, body.toString(), isJwt, principalExtractor, connectTimeout, readTimeout, metrics, retries, retryPauseMillis, includeAcceptHeader);
    }

    public static TokenInfo loginWithRefreshToken(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String refreshToken, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, boolean includeAcceptHeader) throws IOException {
        return OAuthAuthenticator.loginWithRefreshToken(tokenEndpointUrl, socketFactory, hostnameVerifier, refreshToken, clientId, clientSecret, isJwt, principalExtractor, scope, null, includeAcceptHeader);
    }

    public static TokenInfo loginWithRefreshToken(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String refreshToken, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, boolean includeAcceptHeader) throws IOException {
        return OAuthAuthenticator.loginWithRefreshToken(tokenEndpointUrl, socketFactory, hostnameVerifier, refreshToken, clientId, clientSecret, isJwt, principalExtractor, scope, audience, HttpUtil.DEFAULT_CONNECT_TIMEOUT, HttpUtil.DEFAULT_READ_TIMEOUT, 0, 0L, includeAcceptHeader);
    }

    public static TokenInfo loginWithRefreshToken(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String refreshToken, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, int connectTimeout, int readTimeout, int retries, long retryPauseMillis, boolean includeAcceptHeader) throws IOException {
        return OAuthAuthenticator.loginWithRefreshToken(tokenEndpointUrl, socketFactory, hostnameVerifier, refreshToken, clientId, clientSecret, isJwt, principalExtractor, scope, audience, connectTimeout, readTimeout, null, retries, retryPauseMillis, includeAcceptHeader);
    }

    public static TokenInfo loginWithRefreshToken(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String refreshToken, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope, String audience, int connectTimeout, int readTimeout, MetricsHandler metrics, int retries, long retryPauseMillis, boolean includeAcceptHeader) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("loginWithRefreshToken() - tokenEndpointUrl: {}, refreshToken: {}, clientId: {}, clientSecret: {}, scope: {}, audience: {}, connectTimeout: {}, readTimeout: {}, retries: {}, retryPauseMillis: {}, includeAcceptHeader: {}", new Object[]{tokenEndpointUrl, refreshToken, clientId, LogUtil.mask(clientSecret), scope, audience, connectTimeout, readTimeout, retries, retryPauseMillis, includeAcceptHeader});
        }
        if (refreshToken == null) {
            throw new IllegalArgumentException("No refresh token specified");
        }
        String authorization = clientSecret != null ? "Basic " + OAuthAuthenticator.base64encode(clientId + ":" + clientSecret) : null;
        StringBuilder body = new StringBuilder("grant_type=refresh_token").append("&refresh_token=").append(OAuthAuthenticator.urlencode(refreshToken)).append("&client_id=").append(OAuthAuthenticator.urlencode(clientId));
        if (scope != null) {
            body.append("&scope=").append(OAuthAuthenticator.urlencode(scope));
        }
        if (audience != null) {
            body.append("&audience=").append(OAuthAuthenticator.urlencode(audience));
        }
        return OAuthAuthenticator.post(tokenEndpointUrl, socketFactory, hostnameVerifier, authorization, body.toString(), isJwt, principalExtractor, connectTimeout, readTimeout, metrics, retries, retryPauseMillis, includeAcceptHeader);
    }

    private static TokenInfo post(URI tokenEndpointUri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, String body, boolean isJwt, PrincipalExtractor principalExtractor, int connectTimeout, int readTimeout, MetricsHandler metrics, int retries, long retryPauseMillis, boolean includeAcceptHeader) throws IOException {
        JsonNode result;
        try {
            result = HttpUtil.doWithRetries(retries, retryPauseMillis, metrics, () -> HttpUtil.post(tokenEndpointUri, socketFactory, hostnameVerifier, authorization, "application/x-www-form-urlencoded", body, JsonNode.class, connectTimeout, readTimeout, includeAcceptHeader));
        }
        catch (Throwable e) {
            Throwable cause = e;
            if (e instanceof ExecutionException) {
                cause = e.getCause();
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IllegalStateException("Unexpected exception while sending HTTP POST request", cause);
        }
        JsonNode token = result.get("access_token");
        if (token == null) {
            throw new IllegalStateException("Invalid response from authorization server: no access_token");
        }
        JsonNode expiresIn = result.get("expires_in");
        if (expiresIn == null) {
            throw new IllegalStateException("Invalid response from authorization server: no expires_in");
        }
        JsonNode scope = result.get("scope");
        if (isJwt) {
            try {
                return TokenIntrospection.introspectAccessToken(token.asText(), principalExtractor);
            }
            catch (Exception e) {
                log.debug("[IGNORED] Could not parse token as JWT access token. Could not extract subject.", (Throwable)e);
            }
        }
        long now = System.currentTimeMillis();
        return new TokenInfo(token.asText(), scope != null ? scope.asText() : null, "undefined", null, now, now + expiresIn.asLong() * 1000L);
    }

    public static String base64encode(String value) {
        return Base64.getUrlEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String base64decode(String value) {
        return new String(Base64.getUrlDecoder().decode(value), StandardCharsets.UTF_8);
    }

    public static String urlencode(String value) {
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected: Encoding utf-8 not supported");
        }
    }
}

