/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import io.strimzi.kafka.oauth.common.Config;
import org.slf4j.Logger;

public class DeprecationUtil {
    public static boolean isAccessTokenJwt(Config config, Logger log, String errorPrefix) {
        String legacy = config.getValue("oauth.tokens.not.jwt");
        if (legacy != null) {
            log.warn("OAUTH_TOKENS_NOT_JWT is deprecated. Use OAUTH_ACCESS_TOKEN_IS_JWT (with reverse meaning) instead.");
            if (config.getValue("oauth.access.token.is.jwt") != null) {
                throw new RuntimeException((errorPrefix != null ? errorPrefix : "") + "Can't use both OAUTH_ACCESS_TOKEN_IS_JWT and OAUTH_TOKENS_NOT_JWT");
            }
        }
        return legacy != null ? !Config.isTrue(legacy) : config.getValueAsBoolean("oauth.access.token.is.jwt", true);
    }
}

