/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLUtil {
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Avoid enumerating all checked exceptions in try-with-resources")
    public static SSLSocketFactory createSSLFactory(String truststore, String truststoreData, String password, String type, String rnd) {
        SSLContext sslContext;
        X509TrustManager tm;
        KeyStore store;
        block53: {
            Throwable throwable;
            InputStream is;
            if (type != null && "pem".equals(type.toLowerCase(Locale.ENGLISH))) {
                if (truststoreData != null) {
                    try {
                        is = new ByteArrayInputStream(truststoreData.getBytes(StandardCharsets.UTF_8));
                        throwable = null;
                        try {
                            store = SSLUtil.loadPEMCertificates(is);
                            break block53;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        ((ByteArrayInputStream)is).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((ByteArrayInputStream)is).close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load PEM truststore: " + truststore, e);
                    }
                }
                if (truststore != null) {
                    try {
                        is = new BufferedInputStream(new FileInputStream(truststore));
                        throwable = null;
                        try {
                            store = SSLUtil.loadPEMCertificates(is);
                            break block53;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        ((BufferedInputStream)is).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((BufferedInputStream)is).close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load PEM truststore: " + truststore, e);
                    }
                }
                return null;
            }
            if (truststore != null) {
                try {
                    is = new FileInputStream(truststore);
                    throwable = null;
                    try {
                        store = KeyStore.getInstance(type != null ? type : KeyStore.getDefaultType());
                        store.load(is, password.toCharArray());
                        break block53;
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    ((FileInputStream)is).close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                ((FileInputStream)is).close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load truststore: " + truststore, e);
                }
            }
            return null;
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(store);
            tm = SSLUtil.getTrustManager(tmf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialise truststore: " + truststore, e);
        }
        SecureRandom random = null;
        if (rnd != null) {
            try {
                random = SecureRandom.getInstance(rnd);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialise secure random: " + rnd, e);
            }
        }
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{tm}, random);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialise ssl context", e);
        }
        return sslContext.getSocketFactory();
    }

    private static X509TrustManager getTrustManager(TrustManagerFactory tmf) {
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new IllegalStateException("No X509TrustManager on default factory");
    }

    public static HostnameVerifier createAnyHostHostnameVerifier() {
        return (hostname, session) -> true;
    }

    private static KeyStore loadPEMCertificates(InputStream is) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(null, null);
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        while (is.available() > 0) {
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
            String alias = cert.getSubjectX500Principal().getName() + "_" + cert.getSerialNumber().toString(16);
            store.setCertificateEntry(alias, cert);
        }
        return store;
    }
}

