/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import io.strimzi.kafka.oauth.common.JSONUtil;

class Matcher {
    private final ParseContext ctx;
    private final JsonPath parsed;
    private final String query;

    Matcher(ParseContext ctx, String query) {
        this.ctx = ctx;
        this.query = query;
        this.parsed = JsonPath.compile((String)("$[*][?(" + query + ")]"), (Predicate[])new Predicate[0]);
    }

    public boolean matches(JsonNode json) {
        DocumentContext doc = this.ctx.parse((Object)(json = this.wrapToken(json)));
        ArrayNode result = (ArrayNode)doc.read(this.parsed);
        return result.size() == 1;
    }

    private JsonNode wrapToken(JsonNode json) {
        JsonNodeFactory nodeFactory = JSONUtil.MAPPER.getNodeFactory();
        return nodeFactory.objectNode().set("token", json);
    }

    public String toString() {
        return this.query;
    }
}

