/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.adapter.apt.AptContext;
import io.sundr.adapter.apt.visitors.TypeRefTypeVisitor;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRef;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;

public class TypeMirrorToTypeRef
implements Function<TypeMirror, TypeRef> {
    private final AptContext context;

    public TypeMirrorToTypeRef(AptContext context) {
        this.context = context;
    }

    @Override
    public TypeRef apply(TypeMirror item) {
        if (item instanceof NoType) {
            return new VoidRef();
        }
        if (item == null) {
            throw new IllegalArgumentException("TypeMirror cannot be null.");
        }
        Element element = AptContext.getContext().getTypes().asElement(item);
        TypeRef typeRef = item.accept(new TypeRefTypeVisitor(this.context), 0);
        if (typeRef instanceof ClassRef && element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            String fqcn = typeElement.toString();
            this.context.getReferences().add((TypeElement)element);
            return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)typeRef).withNewFullyQualifiedName(fqcn)).build();
        }
        return typeRef;
    }
}

