/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.directives;

import io.sundr.Function;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.utils.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.lang.model.element.Modifier;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.Node;

public class MethodDirective
extends Directive {
    public String getName() {
        return "method";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        String block = "";
        JavaMethod method = null;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) == null) continue;
            if (!(node.jjtGetChild(i) instanceof ASTBlock)) {
                if (i != 0) break;
                method = (JavaMethod)node.jjtGetChild(i).value(context);
                continue;
            }
            StringWriter blockContent = new StringWriter();
            node.jjtGetChild(i).render(context, (Writer)blockContent);
            block = blockContent.toString();
            break;
        }
        this.writeMethod(writer, method, block);
        return true;
    }

    private void writeMethod(Writer writer, JavaMethod method, String block) throws IOException {
        if (method != null) {
            writer.append(StringUtils.join(method.getModifiers(), ModifierToString.INSTANCE, " ")).append(" ");
            if (method.getTypeParameters() != null && !method.getTypeParameters().isEmpty()) {
                writer.append("<").append(StringUtils.join(method.getTypeParameters(), JavaTypeToString.INSTANCE, ", ")).append("> ");
            }
            writer.append(method.getReturnType().getSimpleName()).append(" ").append(method.getName()).append("(").append(StringUtils.join(method.getArguments(), JavaPropertyToString.INSTANCE, ", ")).append(")");
            this.writeExceptions(writer, method);
            if (!StringUtils.isNullOrEmpty(block)) {
                writer.append("{\n");
                writer.append(block).append("}\n");
            } else {
                writer.append(";");
            }
        }
    }

    private void writeExceptions(Writer writer, JavaMethod method) throws IOException {
        if (method.getExceptions().size() > 0) {
            writer.append(" throws ").append(StringUtils.join(method.getExceptions(), ""));
        }
    }

    private static enum JavaPropertyToString implements Function<JavaProperty, String>
    {
        INSTANCE;


        public String apply(JavaProperty item) {
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtils.join(item.getModifiers(), ModifierToString.INSTANCE, " ")).append(" ");
            sb.append(item.getType().getSimpleName()).append(" ").append(item.getName());
            return sb.toString();
        }
    }

    private static enum JavaTypeToString implements Function<JavaType, String>
    {
        INSTANCE;


        public String apply(JavaType item) {
            return item.getSimpleName();
        }
    }

    private static enum ModifierToString implements Function<Modifier, String>
    {
        INSTANCE;


        public String apply(Modifier modifier) {
            return modifier.name().toLowerCase();
        }
    }
}

