/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Node;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface Nameable
extends Node {
    public static final String PACKAGE_SEPARATOR_REGEX = "\\.";
    public static final Predicate<String> IS_UPPER_CASE = w -> Character.isUpperCase(w.charAt(0));
    public static final Predicate<String> IN_PACKAGE = Nameable.until(IS_UPPER_CASE);
    public static final Predicate<String> OUT_OF_PACKAGE = Nameable.after(IS_UPPER_CASE);

    public String getFullyQualifiedName();

    default public String getName() {
        return Nameable.getClassName(this.getFullyQualifiedName());
    }

    default public String getPackageName() {
        return Nameable.getPackageName(this.getFullyQualifiedName());
    }

    public static String getOuterTypeName(String fullyQualifiedName) {
        String packageName = Nameable.getPackageName(fullyQualifiedName);
        String className = Nameable.getClassName(fullyQualifiedName);
        if (!className.contains(".")) {
            return null;
        }
        return Arrays.stream(className.split(Pattern.quote("."))).map(n -> packageName != null && !packageName.isEmpty() ? packageName + "." + n : n).findFirst().orElse(null);
    }

    public static String getClassName(String fullyQualifiedName) {
        return Arrays.stream(fullyQualifiedName.split(PACKAGE_SEPARATOR_REGEX)).filter(Nameable.after(IS_UPPER_CASE)).collect(Collectors.joining("."));
    }

    public static String getPackageName(String fullyQualifiedName) {
        return Arrays.stream(fullyQualifiedName.split(PACKAGE_SEPARATOR_REGEX)).filter(Nameable.until(IS_UPPER_CASE)).collect(Collectors.joining("."));
    }

    public static <T> Predicate<T> until(final Predicate<T> predicate) {
        return new Predicate<T>(){
            private boolean hasMatched;

            @Override
            public boolean test(T s) {
                this.hasMatched = this.hasMatched || predicate.test(s);
                return !this.hasMatched;
            }
        };
    }

    public static <T> Predicate<T> after(final Predicate<T> predicate) {
        return new Predicate<T>(){
            private boolean hasMatched;

            @Override
            public boolean test(T s) {
                this.hasMatched = this.hasMatched || predicate.test(s);
                return this.hasMatched;
            }
        };
    }
}

