/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.html;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenResponse;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.utils.Markdown;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHtml2Codegen
extends DefaultCodegenConfig
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticHtml2Codegen.class);
    protected String invokerPackage = "io.swagger.client";
    protected String phpInvokerPackage = "Swagger\\Client";
    protected String packageName = "IO.Swagger";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-client";
    protected String artifactVersion = "1.0.0";
    protected String jsProjectName;
    protected String jsModuleName;
    protected String perlModuleName = "WWW::SwaggerClient";
    protected String pythonPackageName = "swagger_client";

    public StaticHtml2Codegen() {
        this.outputFolder = "docs";
        this.defaultIncludes = new HashSet();
        this.cliOptions.add(new CliOption("appName", "short name of the application"));
        this.cliOptions.add(new CliOption("appDescription", "description of the application"));
        this.cliOptions.add(new CliOption("infoUrl", "a URL where users can get more information about the application"));
        this.cliOptions.add(new CliOption("infoEmail", "an email address to contact for inquiries about the application"));
        this.cliOptions.add(new CliOption("licenseInfo", "a short description of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "a URL pointing to the full license"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("phpInvokerPackage", "root package for generated php code"));
        this.cliOptions.add(new CliOption("perlModuleName", "root module name for generated perl code"));
        this.cliOptions.add(new CliOption("pythonPackageName", "package name for generated python code"));
        this.cliOptions.add(new CliOption("packageName", "C# package name"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml"));
        this.additionalProperties.put("appName", "Swagger Sample");
        this.additionalProperties.put("appDescription", "A sample swagger server");
        this.additionalProperties.put("infoUrl", "https://helloreverb.com");
        this.additionalProperties.put("infoEmail", "hello@helloreverb.com");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("phpInvokerPackage", this.phpInvokerPackage);
        this.additionalProperties.put("perlModuleName", this.perlModuleName);
        this.additionalProperties.put("pythonPackageName", this.pythonPackageName);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.html"));
        this.reservedWords = new HashSet();
        this.languageSpecificPrimitives = new HashSet();
        this.importMapping = new HashMap();
    }

    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getArgumentsLocation() {
        return "";
    }

    public String getName() {
        return "html2";
    }

    @Override
    public String escapeText(String input) {
        return input;
    }

    public String getHelp() {
        return "Generates a static HTML file.";
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s[%s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && propertySchema.getAdditionalProperties() instanceof Schema) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s[String, %s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase();
            for (CodegenResponse response : op.responses) {
                if (!"0".equals(response.code)) continue;
                response.code = "default";
            }
            op.formParams = this.postProcessParameterEnum(op.formParams);
        }
        return objs;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        String templateVersion = this.getTemplateVersion();
        this.embeddedTemplateDir = StringUtils.isNotBlank((CharSequence)templateVersion) ? (this.templateDir = String.format("%s/htmlDocs2", templateVersion)) : (this.templateDir = String.format("%s/htmlDocs2", "v2"));
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (StringUtils.isBlank((CharSequence)this.jsProjectName) && info.getTitle() != null) {
                this.jsProjectName = this.sanitizeName(this.dashize(info.getTitle()));
            }
        }
        if (StringUtils.isBlank((CharSequence)this.jsProjectName)) {
            this.jsProjectName = "swagger-js-client";
        }
        if (StringUtils.isBlank((CharSequence)this.jsModuleName)) {
            this.jsModuleName = StaticHtml2Codegen.camelize(StaticHtml2Codegen.underscore(this.jsProjectName));
        }
        this.additionalProperties.put("jsProjectName", this.jsProjectName);
        this.additionalProperties.put("jsModuleName", this.jsModuleName);
        this.preparHtmlForGlobalDescription(openAPI);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> definitions, OpenAPI ope) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, ope);
        if (op.returnType != null) {
            op.returnType = this.normalizeType(op.returnType);
        }
        op.path = this.sanitizePath(op.path);
        CodegenParameter lastRequired = null;
        CodegenParameter lastOptional = null;
        for (CodegenParameter p : op.allParams) {
            if (p.required) {
                lastRequired = p;
                continue;
            }
            lastOptional = p;
        }
        for (CodegenParameter p : op.allParams) {
            if (p == lastRequired) {
                p.vendorExtensions.put("x-codegen-hasMoreRequired", false);
                continue;
            }
            if (p == lastOptional) {
                p.vendorExtensions.put("x-codegen-hasMoreOptional", false);
                continue;
            }
            p.vendorExtensions.put("x-codegen-hasMoreRequired", true);
            p.vendorExtensions.put("x-codegen-hasMoreOptional", true);
        }
        op.vendorExtensions.put("x-codegen-hasRequiredParams", lastRequired != null);
        op.vendorExtensions.put("x-codegen-httpMethodUpperCase", httpMethod.toUpperCase());
        return op;
    }

    private void preparHtmlForGlobalDescription(OpenAPI openAPI) {
        String currentDescription = openAPI.getInfo().getDescription();
        if (currentDescription != null && !currentDescription.isEmpty()) {
            Markdown markInstance = new Markdown();
            openAPI.getInfo().setDescription(markInstance.toHtml(currentDescription));
        } else {
            LOGGER.error("Swagger object description is empty [" + openAPI.getInfo().getTitle() + "]");
        }
    }

    public List<CodegenParameter> postProcessParameterEnum(List<CodegenParameter> parameterList) {
        String enumFormatted = "";
        for (CodegenParameter parameter : parameterList) {
            if (!ExtensionHelper.getBooleanValue((VendorExtendable)parameter, "x-is-enum")) continue;
            for (int i = 0; i < parameter._enum.size(); ++i) {
                String spacer;
                String string = spacer = i == parameter._enum.size() - 1 ? " " : ", ";
                if (parameter._enum.get(i) == null) continue;
                enumFormatted = enumFormatted + "`" + (String)parameter._enum.get(i) + "`" + spacer;
            }
            Markdown markInstance = new Markdown();
            if (enumFormatted.isEmpty()) continue;
            parameter.vendorExtensions.put("x-eumFormatted", markInstance.toHtml(enumFormatted));
        }
        return parameterList;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("'", "%27");
    }

    public String normalizeType(String type) {
        return type.replaceAll("\\b(Boolean|Integer|Number|String|Date)\\b", "'$1'");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }
}

