/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.features.BeanValidationFeatures;
import io.swagger.codegen.v3.generators.java.JavaJAXRSSpecServerCodegen;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class JavaJAXRSCXFCDIServerCodegen
extends JavaJAXRSSpecServerCodegen
implements BeanValidationFeatures {
    public JavaJAXRSCXFCDIServerCodegen() {
        this.useBeanValidation = true;
        this.outputFolder = "generated-code/JavaJaxRS-CXF-CDI";
        this.artifactId = "swagger-jaxrs-cxf-cdi-server";
        this.sourceFolder = "src" + File.separator + "gen" + File.separator + "java";
        this.typeMapping.put("DateTime", "java.util.Date");
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations"));
    }

    @Override
    public String getName() {
        return "jaxrs-cxf-cdi";
    }

    @Override
    public void processOpts() {
        if (StringUtils.isBlank((CharSequence)this.templateDir)) {
            this.embeddedTemplateDir = StringUtils.isNotBlank((CharSequence)this.templateVersion) ? (this.templateDir = String.format("%s/JavaJaxRS/cxf-cdi", this.templateVersion)) : (this.templateDir = String.format("%s/JavaJaxRS/cxf-cdi", "v2"));
        }
        super.processOpts();
        this.apiTemplateFiles.put("apiService.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        if (this.useBeanValidation) {
            this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        }
        this.supportingFiles.clear();
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.implFolder + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("beans.mustache", "src/main/webapp/WEB-INF", "beans.xml"));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.add("JsonProperty");
    }

    @Override
    public String getHelp() {
        return "[WORK IN PROGRESS: generated code depends from Swagger v2 libraries] Generates a Java JAXRS Server according to JAXRS 2.0 specification, assuming an Apache CXF runtime and a Java EE runtime with CDI enabled.";
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }
}

