/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.v3.core.util.DeserializationModule;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIYamlGenerator
extends DefaultCodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIYamlGenerator.class);
    public static final String OUTPUT_NAME = "outputFile";
    public static final String SWAGGER_FILENAME_DEFAULT_YAML = "openapi.yaml";
    protected String outputFile = "openapi.yaml";

    public OpenAPIYamlGenerator() {
        this.templateDir = "openapi";
        this.embeddedTemplateDir = "openapi";
        this.outputFolder = "generated-code/openapi";
        this.cliOptions.add(new CliOption(OUTPUT_NAME, "output filename").defaultValue(SWAGGER_FILENAME_DEFAULT_YAML));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
    }

    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    public String getName() {
        return "openapi-yaml";
    }

    public String getHelp() {
        return "Creates a static openapi.yaml file.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OUTPUT_NAME) && !StringUtils.isBlank((CharSequence)((String)this.additionalProperties.get(OUTPUT_NAME)))) {
            this.setOutputFile((String)this.additionalProperties.get(OUTPUT_NAME));
        }
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true));
            this.configureMapper(mapper);
            String valueAsString = mapper.writeValueAsString((Object)openAPI);
            String outputFile = this.outputFolder + File.separator + this.outputFile;
            FileUtils.writeStringToFile((File)new File(outputFile), (String)valueAsString);
            LOGGER.debug("wrote file to " + outputFile);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    private void configureMapper(ObjectMapper mapper) {
        DeserializationModule deserializerModule = new DeserializationModule();
        mapper.registerModule((Module)deserializerModule);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

