/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.kotlin;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.helper.StringHelpers;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.kotlin.AbstractKotlinCodegen;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinServerCodegen
extends AbstractKotlinCodegen {
    public static final String DEFAULT_LIBRARY = "ktor";
    public static final String GENERATE_APIS = "generateApis";
    private static Logger LOGGER = LoggerFactory.getLogger(KotlinServerCodegen.class);
    private Boolean autoHeadFeatureEnabled = true;
    private Boolean conditionalHeadersFeatureEnabled = false;
    private Boolean hstsFeatureEnabled = true;
    private Boolean corsFeatureEnabled = false;
    private Boolean compressionFeatureEnabled = true;
    private Map<String, List<String>> optionsSupportedPerFramework = Collections.singletonMap("ktor", Arrays.asList("featureAutoHead", "featureConditionalHeaders", "featureHSTS", "featureCORS", "featureCompression"));

    public KotlinServerCodegen() {
        this.artifactId = "kotlin-server";
        this.packageName = "io.swagger.server";
        this.outputFolder = "generated-code" + File.separator + "kotlin-server";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.supportedLibraries.put(DEFAULT_LIBRARY, "ktor framework");
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault(DEFAULT_LIBRARY);
        library.setEnum(this.supportedLibraries);
        this.cliOptions.add(library);
        this.addSwitch("featureAutoHead", "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.", this.getAutoHeadFeatureEnabled());
        this.addSwitch("featureConditionalHeaders", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getConditionalHeadersFeatureEnabled());
        this.addSwitch("featureHSTS", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getHstsFeatureEnabled());
        this.addSwitch("featureCORS", "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.", this.getCorsFeatureEnabled());
        this.addSwitch("featureCompression", "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.", this.getCompressionFeatureEnabled());
    }

    public Boolean getAutoHeadFeatureEnabled() {
        return this.autoHeadFeatureEnabled;
    }

    public void setAutoHeadFeatureEnabled(Boolean autoHeadFeatureEnabled) {
        this.autoHeadFeatureEnabled = autoHeadFeatureEnabled;
    }

    public Boolean getCompressionFeatureEnabled() {
        return this.compressionFeatureEnabled;
    }

    public void setCompressionFeatureEnabled(Boolean compressionFeatureEnabled) {
        this.compressionFeatureEnabled = compressionFeatureEnabled;
    }

    public Boolean getConditionalHeadersFeatureEnabled() {
        return this.conditionalHeadersFeatureEnabled;
    }

    public void setConditionalHeadersFeatureEnabled(Boolean conditionalHeadersFeatureEnabled) {
        this.conditionalHeadersFeatureEnabled = conditionalHeadersFeatureEnabled;
    }

    public Boolean getCorsFeatureEnabled() {
        return this.corsFeatureEnabled;
    }

    public void setCorsFeatureEnabled(Boolean corsFeatureEnabled) {
        this.corsFeatureEnabled = corsFeatureEnabled;
    }

    public String getHelp() {
        return "Generates a kotlin server.";
    }

    public Boolean getHstsFeatureEnabled() {
        return this.hstsFeatureEnabled;
    }

    public void setHstsFeatureEnabled(Boolean hstsFeatureEnabled) {
        this.hstsFeatureEnabled = hstsFeatureEnabled;
    }

    public String getName() {
        return "kotlin-server";
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, schema, allDefinitions);
        if (schema instanceof ArraySchema) {
            codegenModel.dataType = this.getTypeDeclaration(schema);
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        String modifiedPath = path;
        if (operation.getParameters() != null) {
            for (Parameter param : operation.getParameters()) {
                String pathParamName = param.getName();
                String kotlinName = this.toVarName(pathParamName);
                modifiedPath = modifiedPath.replace("{" + pathParamName + "}", "{" + kotlinName + "}");
            }
        }
        return super.fromOperation(modifiedPath, httpMethod, operation, schemas, openAPI);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (!this.additionalProperties.containsKey(GENERATE_APIS)) {
            this.additionalProperties.put(GENERATE_APIS, true);
        }
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        } else {
            this.setLibrary(DEFAULT_LIBRARY);
        }
        if (this.additionalProperties.containsKey("featureAutoHead")) {
            this.setAutoHeadFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureAutoHead"));
        } else {
            this.additionalProperties.put("featureAutoHead", this.getAutoHeadFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureConditionalHeaders")) {
            this.setConditionalHeadersFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureConditionalHeaders"));
        } else {
            this.additionalProperties.put("featureConditionalHeaders", this.getConditionalHeadersFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureHSTS")) {
            this.setHstsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureHSTS"));
        } else {
            this.additionalProperties.put("featureHSTS", this.getHstsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCORS")) {
            this.setCorsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCORS"));
        } else {
            this.additionalProperties.put("featureCORS", this.getCorsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCompression")) {
            this.setCompressionFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCompression"));
        } else {
            this.additionalProperties.put("featureCompression", this.getCompressionFeatureEnabled());
        }
        String packageFolder = (this.sourceFolder + File.separator + this.packageName).replace(".", File.separator);
        String resourcesFolder = "src/main/resources";
        Boolean generateApis = this.additionalProperties.containsKey(GENERATE_APIS) && (Boolean)this.additionalProperties.get(GENERATE_APIS) != false;
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("gradle.properties", "", "gradle.properties"));
        this.supportingFiles.add(new SupportingFile("AppMain.kt.mustache", packageFolder, "AppMain.kt"));
        this.supportingFiles.add(new SupportingFile("Configuration.kt.mustache", packageFolder, "Configuration.kt"));
        if (generateApis.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("Paths.kt.mustache", packageFolder, "Paths.kt"));
        }
        this.supportingFiles.add(new SupportingFile("application.conf.mustache", resourcesFolder, "application.conf"));
        this.supportingFiles.add(new SupportingFile("logback.xml", resourcesFolder, "logback.xml"));
        String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("ApiKeyAuth.kt.mustache", infrastructureFolder, "ApiKeyAuth.kt"));
    }

    @Override
    public void addHandlebarHelpers(Handlebars handlebars) {
        super.addHandlebarHelpers(handlebars);
        handlebars.registerHelpers(StringHelpers.class);
    }

    @Override
    public String getDefaultTemplateDir() {
        return "kotlin-server";
    }

    public static class Constants {
        public static final String KTOR = "ktor";
        public static final String AUTOMATIC_HEAD_REQUESTS = "featureAutoHead";
        public static final String AUTOMATIC_HEAD_REQUESTS_DESC = "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.";
        public static final String CONDITIONAL_HEADERS = "featureConditionalHeaders";
        public static final String CONDITIONAL_HEADERS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String HSTS = "featureHSTS";
        public static final String HSTS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String CORS = "featureCORS";
        public static final String CORS_DESC = "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.";
        public static final String COMPRESSION = "featureCompression";
        public static final String COMPRESSION_DESC = "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.";
    }
}

