/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.kotlin;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.StringHelpers;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKotlinCodegen
extends DefaultCodegenConfig {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractKotlinCodegen.class);
    private Set<String> instantiationLibraryFunction;
    protected String artifactId;
    protected String artifactVersion = "1.0.0";
    protected String groupId = "io.swagger";
    protected String packageName;
    protected String sourceFolder = "src/main/kotlin";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public AbstractKotlinCodegen() {
        this.supportsInheritance = true;
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("kotlin.Any", "kotlin.Byte", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.String", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Map", "kotlin.collections.Set", "kotlin.ByteArray", "kotlin.CharArray", "kotlin.ShortArray", "kotlin.IntArray", "kotlin.LongArray", "kotlin.FloatArray", "kotlin.DoubleArray", "kotlin.BooleanArray"));
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "actual", "annotation", "as", "break", "case", "catch", "class", "companion", "const", "constructor", "continue", "crossinline", "data", "delegate", "do", "else", "enum", "expect", "external", "false", "final", "finally", "for", "fun", "if", "in", "infix", "init", "inline", "inner", "interface", "internal", "is", "it", "lateinit", "lazy", "noinline", "null", "object", "open", "operator", "out", "override", "package", "private", "protected", "public", "reified", "return", "sealed", "super", "suspend", "tailrec", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "vararg", "when", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Set", "kotlin.collections.Map", "kotlin.ByteArray", "kotlin.CharArray", "kotlin.ShortArray", "kotlin.IntArray", "kotlin.LongArray", "kotlin.FloatArray", "kotlin.DoubleArray", "kotlin.BooleanArray"));
        this.instantiationLibraryFunction = new HashSet<String>(Arrays.asList("arrayOf", "mapOf"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "kotlin.String");
        this.typeMapping.put("boolean", "kotlin.Boolean");
        this.typeMapping.put("integer", "kotlin.Int");
        this.typeMapping.put("float", "kotlin.Float");
        this.typeMapping.put("long", "kotlin.Long");
        this.typeMapping.put("double", "kotlin.Double");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("date-time", "java.time.LocalDateTime");
        this.typeMapping.put("date", "java.time.LocalDate");
        this.typeMapping.put("file", "java.io.File");
        this.typeMapping.put("array", "kotlin.Array");
        this.typeMapping.put("list", "kotlin.Array");
        this.typeMapping.put("map", "kotlin.collections.Map");
        this.typeMapping.put("object", "kotlin.Any");
        this.typeMapping.put("binary", "kotlin.Array<kotlin.Byte>");
        this.typeMapping.put("Date", "java.time.LocalDate");
        this.typeMapping.put("DateTime", "java.time.LocalDateTime");
        this.typeMapping.put("ByteArray", "kotlin.ByteArray");
        this.instantiationTypes.put("array", "arrayOf");
        this.instantiationTypes.put("list", "arrayOf");
        this.instantiationTypes.put("map", "mapOf");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.specialCharReplacements.put(";", "Semicolon");
        this.specialCharReplacements.put(":", "Colon");
        this.cliOptions.clear();
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageName", "Generated artifact package name (e.g. io.swagger).", this.packageName);
        this.addOption("groupId", "Generated artifact package's organization (i.e. maven groupId).", this.groupId);
        this.addOption("artifactId", "Generated artifact id (name of jar).", this.artifactId);
        this.addOption("artifactVersion", "Generated artifact's package version.", this.artifactVersion);
    }

    @Override
    protected void addOption(String key, String description) {
        this.addOption(key, description, null);
    }

    @Override
    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    @Override
    protected void addSwitch(String key, String description, Boolean defaultValue) {
        CliOption option = CliOption.newBoolean((String)key, (String)description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue.toString());
        }
        this.cliOptions.add(option);
    }

    @Override
    public String getArgumentsLocation() {
        return "";
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeReservedWord(String name) {
        return String.format("`%s`", name);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    protected void updateCodegenModelEnumVars(CodegenModel codegenModel) {
        super.updateCodegenModelEnumVars(codegenModel);
        for (CodegenProperty var : codegenModel.allVars) {
            this.updateCodegenPropertyEnum(var);
        }
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            return this.getArrayTypeDeclaration((ArraySchema)propertySchema);
        }
        if (propertySchema instanceof MapSchema && AbstractKotlinCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            if (inner == null) {
                LOGGER.warn(propertySchema.getName() + "(map property) does not have a proper inner type defined");
                return null;
            }
            return String.format("%s<kotlin.String, %s>", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && AbstractKotlinCodegen.hasTrueAdditionalProperties(propertySchema)) {
            ObjectSchema inner = new ObjectSchema();
            return String.format("%s<kotlin.String, %s>", this.getSchemaType(propertySchema), this.getTypeDeclaration((Schema)inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return (String)this.typeAliases.get(name);
        }
        return name;
    }

    @Override
    public String getSchemaType(Schema schema) {
        String schemaType = super.getSchemaType(schema);
        if (this.typeMapping.containsKey(schemaType)) {
            return this.toModelName((String)this.typeMapping.get(schemaType));
        }
        if (null == schemaType) {
            if (schema.getName() != null) {
                LOGGER.warn("No Type defined for Property " + schema.getName());
                return this.toModelName(schema.getName());
            }
            return this.toModelName("kotlin.Any");
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(super.postProcessModels(objs));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
            if (!this.additionalProperties.containsKey("modelPackage")) {
                this.setModelPackage(this.packageName + ".models");
            }
            if (!this.additionalProperties.containsKey("apiPackage")) {
                this.setApiPackage(this.packageName + ".apis");
            }
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            LOGGER.warn("invokerPackage with " + this.getName() + " generator is ignored. Use " + "packageName" + ".");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String modified;
        if (value.length() == 0) {
            modified = "EMPTY";
        } else {
            modified = value;
            modified = this.sanitizeKotlinSpecificNames(modified);
        }
        modified = modified.toUpperCase();
        if (this.isReservedWord(modified)) {
            return this.escapeReservedWord(modified);
        }
        return modified;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (this.isPrimivite(datatype)) {
            return value;
        }
        return super.toEnumValue(value, datatype);
    }

    @Override
    public boolean isPrimivite(String datatype) {
        return "kotlin.Byte".equalsIgnoreCase(datatype) || "kotlin.Short".equalsIgnoreCase(datatype) || "kotlin.Int".equalsIgnoreCase(datatype) || "kotlin.Long".equalsIgnoreCase(datatype) || "kotlin.Float".equalsIgnoreCase(datatype) || "kotlin.Double".equalsIgnoreCase(datatype) || "kotlin.Boolean".equalsIgnoreCase(datatype);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (p instanceof ArraySchema) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        return super.toInstantiationType(p);
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(name)) {
            return super.toModelImport(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        if (name.startsWith("kotlin.") || name.startsWith("java.")) {
            return name;
        }
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        String modifiedName = name.replaceAll("\\.", "");
        modifiedName = this.sanitizeKotlinSpecificNames(modifiedName);
        if ((modifiedName = this.titleCase(modifiedName)).equalsIgnoreCase("Companion")) {
            modifiedName = "_" + modifiedName;
        }
        return modifiedName;
    }

    @Override
    public String toVarName(String name) {
        return super.toVarName(this.sanitizeKotlinSpecificNames(name));
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return StringUtils.capitalize((String)property.name);
    }

    @Override
    public void addHandlebarHelpers(Handlebars handlebars) {
        super.addHandlebarHelpers(handlebars);
        handlebars.registerHelpers(StringHelpers.class);
        handlebars.registerHelpers(ConditionalHelpers.class);
    }

    private String getArrayTypeDeclaration(ArraySchema arraySchema) {
        String arrayType = (String)this.typeMapping.get("array");
        StringBuilder instantiationType = new StringBuilder(arrayType);
        Schema items = arraySchema.getItems();
        String nestedType = this.getTypeDeclaration(items);
        instantiationType.append("<").append(nestedType).append(">");
        return instantiationType.toString();
    }

    private String sanitizeKotlinSpecificNames(String name) {
        String word = this.removeNonNameElementToCamelCase(name);
        for (Map.Entry specialCharacters : this.specialCharReplacements.entrySet()) {
            if (((String)specialCharacters.getKey()).equals("_")) continue;
            word = word.replaceAll("\\Q" + (String)specialCharacters.getKey() + "\\E", (String)specialCharacters.getValue());
        }
        if ((word = word.replaceAll("\\W+", "_")).matches("\\d.*")) {
            word = "_" + word;
        }
        if (word.matches("^_*$")) {
            word = word.replaceAll("\\Q_\\E", "Underscore");
        }
        return word;
    }

    private String titleCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    protected boolean needToImport(String type) {
        boolean imports = !type.startsWith("kotlin.") && !type.startsWith("java.") && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type) && !this.instantiationLibraryFunction.contains(type);
        return imports;
    }
}

