/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.config;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.ClientOpts;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.CodegenConfigLoader;
import io.swagger.codegen.v3.auth.AuthParser;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenConfigurator
implements Serializable {
    public static final Logger LOGGER = LoggerFactory.getLogger(CodegenConfigurator.class);
    private String lang;
    private String inputSpec;
    private String inputSpecURL;
    private String outputDir;
    private boolean verbose;
    private boolean skipOverwrite;
    private boolean removeOperationIdPrefix;
    private String templateDir;
    private String templateVersion;
    private String auth;
    private AuthorizationValue authorizationValue;
    private String apiPackage;
    private String modelPackage;
    private String invokerPackage;
    private String modelNamePrefix;
    private String modelNameSuffix;
    private String groupId;
    private String artifactId;
    private String artifactVersion;
    private String library;
    private String ignoreFileOverride;
    private List<CodegenArgument> codegenArguments = new ArrayList<CodegenArgument>();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> instantiationTypes = new HashMap<String, String>();
    private Map<String, String> typeMappings = new HashMap<String, String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private Map<String, String> importMappings = new HashMap<String, String>();
    private Set<String> languageSpecificPrimitives = new HashSet<String>();
    private Map<String, String> reservedWordMappings = new HashMap<String, String>();
    private String gitUserId = "GIT_USER_ID";
    private String gitRepoId = "GIT_REPO_ID";
    private String releaseNote = "Minor update";
    private String httpUserAgent;
    private final Map<String, Object> dynamicProperties = new HashMap<String, Object>();

    public CodegenConfigurator() {
        this.setOutputDir(".");
    }

    public CodegenConfigurator setLang(String lang) {
        this.lang = lang;
        return this;
    }

    public CodegenConfigurator setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
        return this;
    }

    public String getInputSpec() {
        return this.inputSpec;
    }

    public String getInputSpecURL() {
        return this.inputSpecURL;
    }

    public CodegenConfigurator setInputSpecURL(String inputSpecURL) {
        this.inputSpecURL = inputSpecURL;
        return this;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public CodegenConfigurator setOutputDir(String outputDir) {
        this.outputDir = CodegenConfigurator.toAbsolutePathStr(outputDir);
        return this;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public CodegenConfigurator setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
        return this;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public CodegenConfigurator setModelNamePrefix(String prefix) {
        this.modelNamePrefix = prefix;
        return this;
    }

    public boolean getRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    public CodegenConfigurator setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.removeOperationIdPrefix = removeOperationIdPrefix;
        return this;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public CodegenConfigurator setModelNameSuffix(String suffix) {
        this.modelNameSuffix = suffix;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public CodegenConfigurator setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    public CodegenConfigurator setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
        return this;
    }

    public String getLang() {
        return this.lang;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public CodegenConfigurator setTemplateDir(String templateDir) {
        File f = new File(templateDir);
        if (!f.exists() || !f.isDirectory()) {
            throw new IllegalArgumentException("Template directory " + templateDir + " does not exist.");
        }
        this.templateDir = f.getAbsolutePath();
        return this;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public CodegenConfigurator setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
        return this;
    }

    public String getAuth() {
        return this.auth;
    }

    public CodegenConfigurator setAuth(String auth) {
        this.auth = auth;
        return this;
    }

    public AuthorizationValue getAuthorizationValue() {
        return this.authorizationValue;
    }

    public void setAuthorizationValue(AuthorizationValue authorizationValue) {
        this.authorizationValue = authorizationValue;
    }

    public String getApiPackage() {
        return this.apiPackage;
    }

    public CodegenConfigurator setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
        return this;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public CodegenConfigurator setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public CodegenConfigurator setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public CodegenConfigurator setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public CodegenConfigurator setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
        return this;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public CodegenConfigurator setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
        return this;
    }

    public CodegenConfigurator addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
        return this;
    }

    public Map<String, String> getInstantiationTypes() {
        return this.instantiationTypes;
    }

    public CodegenConfigurator setInstantiationTypes(Map<String, String> instantiationTypes) {
        this.instantiationTypes = instantiationTypes;
        return this;
    }

    public CodegenConfigurator addInstantiationType(String key, String value) {
        this.instantiationTypes.put(key, value);
        return this;
    }

    public Map<String, String> getTypeMappings() {
        return this.typeMappings;
    }

    public CodegenConfigurator setTypeMappings(Map<String, String> typeMappings) {
        this.typeMappings = typeMappings;
        return this;
    }

    public CodegenConfigurator addTypeMapping(String key, String value) {
        this.typeMappings.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public CodegenConfigurator setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public CodegenConfigurator addAdditionalProperty(String key, Object value) {
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, String> getImportMappings() {
        return this.importMappings;
    }

    public CodegenConfigurator setImportMappings(Map<String, String> importMappings) {
        this.importMappings = importMappings;
        return this;
    }

    public CodegenConfigurator addImportMapping(String key, String value) {
        this.importMappings.put(key, value);
        return this;
    }

    public Set<String> getLanguageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    public CodegenConfigurator setLanguageSpecificPrimitives(Set<String> languageSpecificPrimitives) {
        this.languageSpecificPrimitives = languageSpecificPrimitives;
        return this;
    }

    public CodegenConfigurator addLanguageSpecificPrimitive(String value) {
        this.languageSpecificPrimitives.add(value);
        return this;
    }

    public String getLibrary() {
        return this.library;
    }

    public CodegenConfigurator setLibrary(String library) {
        this.library = library;
        return this;
    }

    public String getGitUserId() {
        return this.gitUserId;
    }

    public CodegenConfigurator setGitUserId(String gitUserId) {
        this.gitUserId = gitUserId;
        return this;
    }

    public String getGitRepoId() {
        return this.gitRepoId;
    }

    public CodegenConfigurator setGitRepoId(String gitRepoId) {
        this.gitRepoId = gitRepoId;
        return this;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    public CodegenConfigurator setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
        return this;
    }

    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    public CodegenConfigurator setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
        return this;
    }

    public Map<String, String> getReservedWordsMappings() {
        return this.reservedWordMappings;
    }

    public CodegenConfigurator setReservedWordsMappings(Map<String, String> reservedWordsMappings) {
        this.reservedWordMappings = reservedWordsMappings;
        return this;
    }

    public CodegenConfigurator addAdditionalReservedWordMapping(String key, String value) {
        this.reservedWordMappings.put(key, value);
        return this;
    }

    public String getIgnoreFileOverride() {
        return this.ignoreFileOverride;
    }

    public CodegenConfigurator setIgnoreFileOverride(String ignoreFileOverride) {
        this.ignoreFileOverride = ignoreFileOverride;
        return this;
    }

    public String loadSpecContent(String location, List<AuthorizationValue> auths) throws Exception {
        location = location.replaceAll("\\\\", "/");
        String data = "";
        if (location.toLowerCase().startsWith("http")) {
            data = RemoteUrl.urlToString((String)location, auths);
        } else {
            String fileScheme = "file:";
            Path path = location.toLowerCase().startsWith("file:") ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
            data = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (String)"UTF-8") : ClasspathHelper.loadFileFromClasspath((String)location);
        }
        LOGGER.trace("Loaded raw data: {}", (Object)data);
        return data;
    }

    public ClientOptInput toClientOptInput() {
        Validate.notEmpty((CharSequence)this.lang, (String)"language must be specified", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)this.inputSpec) && StringUtils.isBlank((CharSequence)this.inputSpecURL)) {
            throw new IllegalArgumentException("input spec or URL must be specified");
        }
        this.setVerboseFlags();
        this.setSystemProperties();
        CodegenConfig config = CodegenConfigLoader.forName(this.lang);
        ClientOptInput input = new ClientOptInput();
        List<AuthorizationValue> authorizationValues = AuthParser.parse(this.auth);
        if (this.authorizationValue != null) {
            authorizationValues.add(this.authorizationValue);
        }
        if (!StringUtils.isBlank((CharSequence)this.inputSpec)) {
            config.setInputSpec(this.inputSpec);
            ParseOptions options = new ParseOptions();
            options.setResolve(true);
            options.setFlatten(true);
            SwaggerParseResult result = new OpenAPIParser().readContents(this.inputSpec, authorizationValues, options);
            OpenAPI openAPI = result.getOpenAPI();
            if (config.needsUnflattenedSpec()) {
                ParseOptions optionsUnflattened = new ParseOptions();
                optionsUnflattened.setResolve(true);
                SwaggerParseResult resultUnflattened = new OpenAPIParser().readContents(this.inputSpec, authorizationValues, optionsUnflattened);
                OpenAPI openAPIUnflattened = resultUnflattened.getOpenAPI();
                config.setUnflattenedOpenAPI(openAPIUnflattened);
            }
            input.opts(new ClientOpts()).openAPI(openAPI);
            LOGGER.debug("getClientOptInput - parsed inputSpec");
        } else {
            String specContent = null;
            try {
                specContent = this.loadSpecContent(this.inputSpecURL, authorizationValues);
            }
            catch (Exception e) {
                String msg = "Unable to read URL: " + this.inputSpecURL;
                LOGGER.error(msg, (Throwable)e);
                throw new IllegalArgumentException(msg);
            }
            if (StringUtils.isBlank((CharSequence)specContent)) {
                String msg = "Empty content found in URL: " + this.inputSpecURL;
                LOGGER.error(msg);
                throw new IllegalArgumentException(msg);
            }
            config.setInputSpec(specContent);
            config.setInputURL(this.inputSpecURL);
            ParseOptions options = new ParseOptions();
            options.setResolve(true);
            options.setFlatten(true);
            SwaggerParseResult result = new OpenAPIParser().readLocation(this.inputSpecURL, authorizationValues, options);
            OpenAPI openAPI = result.getOpenAPI();
            LOGGER.debug("getClientOptInput - parsed inputSpecURL " + this.inputSpecURL);
            input.opts(new ClientOpts()).openAPI(openAPI);
            if (config.needsUnflattenedSpec()) {
                ParseOptions optionsUnflattened = new ParseOptions();
                optionsUnflattened.setResolve(true);
                SwaggerParseResult resultUnflattened = new OpenAPIParser().readLocation(this.inputSpecURL, authorizationValues, optionsUnflattened);
                OpenAPI openAPIUnflattened = resultUnflattened.getOpenAPI();
                config.setUnflattenedOpenAPI(openAPIUnflattened);
            }
        }
        config.setOutputDir(this.outputDir);
        config.setSkipOverwrite(this.skipOverwrite);
        config.setIgnoreFilePathOverride(this.ignoreFileOverride);
        config.setRemoveOperationIdPrefix(this.removeOperationIdPrefix);
        config.instantiationTypes().putAll(this.instantiationTypes);
        config.typeMapping().putAll(this.typeMappings);
        config.importMapping().putAll(this.importMappings);
        config.languageSpecificPrimitives().addAll(this.languageSpecificPrimitives);
        config.reservedWordsMappings().putAll(this.reservedWordMappings);
        config.setLanguageArguments(this.codegenArguments);
        this.checkAndSetAdditionalProperty(this.apiPackage, "apiPackage");
        this.checkAndSetAdditionalProperty(this.modelPackage, "modelPackage");
        this.checkAndSetAdditionalProperty(this.invokerPackage, "invokerPackage");
        this.checkAndSetAdditionalProperty(this.groupId, "groupId");
        this.checkAndSetAdditionalProperty(this.artifactId, "artifactId");
        this.checkAndSetAdditionalProperty(this.artifactVersion, "artifactVersion");
        this.checkAndSetAdditionalProperty(this.templateDir, CodegenConfigurator.toAbsolutePathStr(this.templateDir), "templateDir");
        this.checkAndSetAdditionalProperty(this.templateVersion, "templateVersion");
        this.checkAndSetAdditionalProperty(this.modelNamePrefix, "modelNamePrefix");
        this.checkAndSetAdditionalProperty(this.modelNameSuffix, "modelNameSuffix");
        this.checkAndSetAdditionalProperty(this.gitUserId, "gitUserId");
        this.checkAndSetAdditionalProperty(this.gitRepoId, "gitRepoId");
        this.checkAndSetAdditionalProperty(this.releaseNote, "releaseNote");
        this.checkAndSetAdditionalProperty(this.httpUserAgent, "httpUserAgent");
        this.handleDynamicProperties(config);
        if (StringUtils.isNotEmpty((CharSequence)this.library)) {
            config.setLibrary(this.library);
        }
        config.additionalProperties().putAll(this.additionalProperties);
        input.config(config);
        return input;
    }

    @JsonAnySetter
    public CodegenConfigurator addDynamicProperty(String name, Object value) {
        this.dynamicProperties.put(name, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getDynamicProperties() {
        return this.dynamicProperties;
    }

    private void handleDynamicProperties(CodegenConfig codegenConfig) {
        for (CliOption langCliOption : codegenConfig.cliOptions()) {
            String opt = langCliOption.getOpt();
            if (this.dynamicProperties.containsKey(opt)) {
                codegenConfig.additionalProperties().put(opt, this.dynamicProperties.get(opt));
                continue;
            }
            if (!this.systemProperties.containsKey(opt)) continue;
            codegenConfig.additionalProperties().put(opt, this.systemProperties.get(opt));
        }
    }

    private void setVerboseFlags() {
        if (!this.verbose) {
            return;
        }
        LOGGER.info("\nVERBOSE MODE: ON. Additional debug options are injected\n - [debugSwagger] prints the swagger specification as interpreted by the codegen\n - [debugModels] prints models passed to the template engine\n - [debugOperations] prints operations passed to the template engine\n - [debugSupportingFiles] prints additional data passed to the template engine");
        System.setProperty("debugSwagger", "");
        System.setProperty("debugModels", "");
        System.setProperty("debugOperations", "");
        System.setProperty("debugSupportingFiles", "");
    }

    public void setCodegenArguments(List<CodegenArgument> codegenArguments) {
        this.codegenArguments = codegenArguments;
    }

    public List<CodegenArgument> getCodegenArguments() {
        return this.codegenArguments;
    }

    private void setSystemProperties() {
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static String toAbsolutePathStr(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return Paths.get(path, new String[0]).toAbsolutePath().toString();
        }
        return path;
    }

    private void checkAndSetAdditionalProperty(String property, String propertyKey) {
        this.checkAndSetAdditionalProperty(property, property, propertyKey);
    }

    private void checkAndSetAdditionalProperty(String property, String valueToSet, String propertyKey) {
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            this.additionalProperties.put(propertyKey, valueToSet);
        }
    }

    public static CodegenConfigurator fromFile(String configFile) {
        if (StringUtils.isNotEmpty((CharSequence)configFile)) {
            try {
                return (CodegenConfigurator)Json.mapper().readValue(new File(configFile), CodegenConfigurator.class);
            }
            catch (IOException e) {
                LOGGER.error("Unable to deserialize config file: " + configFile, (Throwable)e);
            }
        }
        return null;
    }
}

