/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3;

import io.swagger.codegen.v3.AbstractGenerator;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenSecurity;
import io.swagger.codegen.v3.Generator;
import io.swagger.codegen.v3.GlobalSupportingFile;
import io.swagger.codegen.v3.ISchemaHandler;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.ignore.CodegenIgnoreProcessor;
import io.swagger.codegen.v3.templates.TemplateEngine;
import io.swagger.codegen.v3.utils.ImplementationVersion;
import io.swagger.codegen.v3.utils.URLPathUtil;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenerator
extends AbstractGenerator
implements Generator {
    protected final Logger LOGGER = LoggerFactory.getLogger(DefaultGenerator.class);
    protected CodegenConfig config;
    protected ClientOptInput opts;
    protected OpenAPI openAPI;
    protected CodegenIgnoreProcessor ignoreProcessor;
    protected TemplateEngine templateEngine;
    private Boolean generateApis = null;
    private Boolean generateModels = null;
    private Boolean generateSupportingFiles = null;
    private Boolean generateApiTests = null;
    private Boolean generateApiDocumentation = null;
    private Boolean generateModelTests = null;
    private Boolean generateModelDocumentation = null;
    private Boolean generateSwaggerMetadata = true;
    private Boolean useOas2 = false;
    private String basePath;
    private String basePathWithoutHost;
    private String contextPath;
    private Map<String, String> generatorPropertyDefaults = new HashMap<String, String>();

    @Override
    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.openAPI = opts.getOpenAPI();
        this.config = opts.getConfig();
        this.config.additionalProperties().putAll(opts.getOpts().getProperties());
        String ignoreFileLocation = this.config.getIgnoreFilePathOverride();
        if (ignoreFileLocation != null) {
            File ignoreFile = new File(ignoreFileLocation);
            if (ignoreFile.exists() && ignoreFile.canRead()) {
                this.ignoreProcessor = new CodegenIgnoreProcessor(ignoreFile);
            } else {
                this.LOGGER.warn("Ignore file specified at {} is not valid. This will fall back to an existing ignore file if present in the output directory.", (Object)ignoreFileLocation);
            }
        }
        if (this.ignoreProcessor == null) {
            this.ignoreProcessor = new CodegenIgnoreProcessor(this.config.getOutputDir());
        }
        return this;
    }

    public void setGenerateSwaggerMetadata(Boolean generateSwaggerMetadata) {
        this.generateSwaggerMetadata = generateSwaggerMetadata;
    }

    public void setGeneratorPropertyDefault(String key, String value) {
        this.generatorPropertyDefaults.put(key, value);
    }

    private Boolean getGeneratorPropertyDefaultSwitch(String key, Boolean defaultValue) {
        String result = null;
        if (this.generatorPropertyDefaults.containsKey(key)) {
            result = this.generatorPropertyDefaults.get(key);
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return defaultValue;
    }

    private String getScheme() {
        String scheme = URLPathUtil.getScheme(this.openAPI, this.config);
        if (StringUtils.isBlank((CharSequence)scheme)) {
            scheme = "https";
        }
        scheme = this.config.escapeText(scheme);
        return scheme;
    }

    private void configureGeneratorProperties() {
        Boolean generateAPIDocsOption;
        Boolean generateAPITestsOption;
        Boolean generateModelDocsOption;
        if (System.getProperty("generateApis") != null) {
            this.generateApis = Boolean.valueOf(System.getProperty("generateApis"));
        } else {
            Boolean bl = this.generateApis = System.getProperty("apis") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("apis", null);
        }
        this.generateModels = System.getProperty("generateModels") != null ? Boolean.valueOf(System.getProperty("generateModels")) : (System.getProperty("models") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("models", null));
        String supportingFilesProperty = System.getProperty("supportingFiles");
        if (supportingFilesProperty != null && supportingFilesProperty.equalsIgnoreCase("false")) {
            this.generateSupportingFiles = false;
        } else {
            Boolean bl = this.generateSupportingFiles = supportingFilesProperty != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("supportingFiles", null);
        }
        if (this.generateApis == null && this.generateModels == null && this.generateSupportingFiles == null) {
            this.generateModels = this.generateSupportingFiles = Boolean.valueOf(true);
            this.generateApis = this.generateSupportingFiles;
        } else {
            if (this.generateApis == null) {
                this.generateApis = false;
            }
            if (this.generateModels == null) {
                this.generateModels = false;
            }
            if (this.generateSupportingFiles == null) {
                this.generateSupportingFiles = false;
            }
        }
        Boolean generateModelTestsOption = this.getCustomOptionBooleanValue("--model-tests");
        if (generateModelTestsOption == null) {
            Boolean bl = generateModelTestsOption = System.getProperty("modelTests") != null ? Boolean.valueOf(System.getProperty("modelTests")) : null;
        }
        if ((generateModelDocsOption = this.getCustomOptionBooleanValue("--model-docs")) == null) {
            Boolean bl = generateModelDocsOption = System.getProperty("modelDocs") != null ? Boolean.valueOf(System.getProperty("modelDocs")) : null;
        }
        if ((generateAPITestsOption = this.getCustomOptionBooleanValue("--api-tests")) == null) {
            Boolean bl = generateAPITestsOption = System.getProperty("apiTests") != null ? Boolean.valueOf(System.getProperty("apiTests")) : null;
        }
        if ((generateAPIDocsOption = this.getCustomOptionBooleanValue("--api-docs")) == null) {
            generateAPIDocsOption = System.getProperty("apiDocs") != null ? Boolean.valueOf(System.getProperty("apiDocs")) : null;
        }
        Boolean useOas2Option = this.getCustomOptionBooleanValue("--use-oas2");
        this.generateModelTests = generateModelTestsOption != null ? generateModelTestsOption : this.getGeneratorPropertyDefaultSwitch("modelTests", true);
        this.generateModelDocumentation = generateModelDocsOption != null ? generateModelDocsOption : this.getGeneratorPropertyDefaultSwitch("modelDocs", true);
        this.generateApiTests = generateAPITestsOption != null ? generateAPITestsOption : this.getGeneratorPropertyDefaultSwitch("apiTests", true);
        this.generateApiDocumentation = generateAPIDocsOption != null ? generateAPIDocsOption : this.getGeneratorPropertyDefaultSwitch("apiDocs", true);
        this.useOas2 = useOas2Option != null ? useOas2Option : this.getGeneratorPropertyDefaultSwitch("useOas2", false);
        this.config.additionalProperties().put("generateApiTests", this.generateApiTests);
        this.config.additionalProperties().put("generateModelTests", this.generateModelTests);
        this.config.additionalProperties().put("generateApiDocs", this.generateApiDocumentation);
        this.config.additionalProperties().put("generateModelDocs", this.generateModelDocumentation);
        if (useOas2Option != null && !this.config.additionalProperties().containsKey("useOas2")) {
            this.config.additionalProperties().put("useOas2", this.useOas2);
        }
        if (!this.generateApiTests.booleanValue() && !this.generateModelTests.booleanValue()) {
            this.config.additionalProperties().put("excludeTests", true);
        }
        if (System.getProperty("debugSwagger") != null) {
            Json.prettyPrint((Object)this.openAPI);
        }
        this.config.processOpts();
        this.config.preprocessOpenAPI(this.openAPI);
        this.config.additionalProperties().put("generatorVersion", ImplementationVersion.read());
        this.config.additionalProperties().put("generatedDate", ZonedDateTime.now().toString());
        this.config.additionalProperties().put("generatedYear", String.valueOf(ZonedDateTime.now().getYear()));
        this.config.additionalProperties().put("generatorClass", this.config.getClass().getName());
        this.config.additionalProperties().put("inputSpec", this.config.getInputSpec());
        if (this.openAPI.getExtensions() != null) {
            this.config.vendorExtensions().putAll(this.openAPI.getExtensions());
        }
        this.templateEngine = this.config.getTemplateEngine();
        URL url = URLPathUtil.getServerURL(this.openAPI, this.config);
        this.contextPath = this.config.escapeText(url == null ? "" : url.getPath());
        this.basePath = this.config.escapeText(URLPathUtil.getHost(this.openAPI));
        this.basePathWithoutHost = this.config.escapeText(this.contextPath);
    }

    private void configureSwaggerInfo() {
        Info info = this.openAPI.getInfo();
        if (info == null) {
            return;
        }
        if (info.getTitle() != null) {
            this.config.additionalProperties().put("appName", this.config.escapeText(info.getTitle()));
        }
        if (info.getVersion() != null) {
            this.config.additionalProperties().put("appVersion", this.config.escapeText(info.getVersion()));
        } else {
            this.LOGGER.error("Missing required field info version. Default appVersion set to 1.0.0");
            this.config.additionalProperties().put("appVersion", "1.0.0");
        }
        if (StringUtils.isEmpty((CharSequence)info.getDescription())) {
            this.config.additionalProperties().put("appDescription", "No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)");
            this.config.additionalProperties().put("unescapedAppDescription", "No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)");
        } else {
            this.config.additionalProperties().put("appDescription", this.config.escapeText(info.getDescription()));
            this.config.additionalProperties().put("unescapedAppDescription", info.getDescription());
        }
        if (info.getContact() != null) {
            Contact contact = info.getContact();
            if (contact.getEmail() != null) {
                this.config.additionalProperties().put("infoEmail", this.config.escapeText(contact.getEmail()));
            }
            if (contact.getName() != null) {
                this.config.additionalProperties().put("infoName", this.config.escapeText(contact.getName()));
            }
            if (contact.getUrl() != null) {
                this.config.additionalProperties().put("infoUrl", this.config.escapeText(contact.getUrl()));
            }
        }
        if (info.getLicense() != null) {
            License license = info.getLicense();
            if (license.getName() != null) {
                this.config.additionalProperties().put("licenseInfo", this.config.escapeText(license.getName()));
            }
            if (license.getUrl() != null) {
                this.config.additionalProperties().put("licenseUrl", this.config.escapeText(license.getUrl()));
            }
        }
        if (info.getVersion() != null) {
            this.config.additionalProperties().put("version", this.config.escapeText(info.getVersion()));
        } else {
            this.LOGGER.error("Missing required field info version. Default version set to 1.0.0");
            this.config.additionalProperties().put("version", "1.0.0");
        }
        if (info.getTermsOfService() != null) {
            this.config.additionalProperties().put("termsOfService", this.config.escapeText(info.getTermsOfService()));
        }
    }

    private void generateModelTests(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelTestTemplateFiles().keySet()) {
            String suffix = this.config.modelTestTemplateFiles().get(templateName);
            String filename = this.config.modelTestFileFolder() + File.separator + this.config.toModelTestFilename(modelName) + suffix;
            if (new File(filename).exists()) {
                this.LOGGER.info("File exists. Skipped overwriting " + filename);
                continue;
            }
            File written = this.processTemplateToFile(models, templateName, filename);
            if (written == null) continue;
            files.add(written);
        }
    }

    private void generateModelDocumentation(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelDocTemplateFiles().keySet()) {
            String suffix = this.config.modelDocTemplateFiles().get(templateName);
            String filename = this.config.modelDocFileFolder() + File.separator + this.config.toModelDocFilename(modelName) + suffix;
            if (!this.config.shouldOverwrite(filename)) {
                this.LOGGER.info("Skipped overwriting " + filename);
                continue;
            }
            File written = this.processTemplateToFile(models, templateName, filename);
            if (written == null) continue;
            files.add(written);
        }
    }

    private void generateModels(List<File> files, List<Object> allModels) {
        Map models;
        if (!this.generateModels.booleanValue()) {
            return;
        }
        Map schemas = this.openAPI.getComponents().getSchemas();
        if (schemas == null) {
            return;
        }
        String modelNames = System.getProperty("models");
        HashSet<String> modelsToGenerate = null;
        if (modelNames != null && !modelNames.isEmpty()) {
            modelsToGenerate = new HashSet<String>(Arrays.asList(modelNames.split(",")));
        }
        Set modelKeys = schemas.keySet();
        if (modelsToGenerate != null && !modelsToGenerate.isEmpty()) {
            HashSet updatedKeys = new HashSet();
            for (String m : modelKeys) {
                if (!modelsToGenerate.contains(m)) continue;
                updatedKeys.add(m);
            }
            modelKeys = updatedKeys;
        }
        Map<String, Object> allProcessedModels = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ObjectUtils.compare((Comparable)((Object)DefaultGenerator.this.config.toModelName(o1)), (Comparable)((Object)DefaultGenerator.this.config.toModelName(o2)));
            }
        });
        for (String name : modelKeys) {
            try {
                if (!this.config.getIgnoreImportMapping() && this.config.importMapping().containsKey(name)) {
                    this.LOGGER.info("Model " + name + " not imported due to import mapping");
                    continue;
                }
                Schema schema = (Schema)schemas.get(name);
                HashMap<String, Schema> schemaMap = new HashMap<String, Schema>();
                schemaMap.put(name, schema);
                models = this.processModels(this.config, schemaMap, schemas);
                models.put("classname", this.config.toModelName(name));
                models.putAll(this.config.additionalProperties());
                allProcessedModels.put(name, models);
                List modelList = (List)models.get("models");
                if (modelList == null || !modelList.isEmpty()) continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not process model '" + name + "'.Please make sure that your schema is correct!", e);
            }
        }
        ISchemaHandler schemaHandler = this.config.getSchemaHandler();
        schemaHandler.readProcessedModels(allProcessedModels);
        List<CodegenModel> composedModels = schemaHandler.getModels();
        if (composedModels != null && !composedModels.isEmpty()) {
            for (CodegenModel composedModel : composedModels) {
                models = this.processModel(composedModel, this.config, schemas);
                models.put("classname", this.config.toModelName(composedModel.name));
                models.putAll(this.config.additionalProperties());
                allProcessedModels.put(composedModel.name, models);
            }
        }
        allProcessedModels = this.config.postProcessAllModels(allProcessedModels);
        for (String modelName : allProcessedModels.keySet()) {
            models = (Map)allProcessedModels.get(modelName);
            try {
                if (!this.config.getIgnoreImportMapping() && this.config.importMapping().containsKey(modelName)) continue;
                Map modelTemplate = (Map)((List)models.get("models")).get(0);
                if (this.config.checkAliasModel() && modelTemplate != null && modelTemplate.containsKey("model")) {
                    CodegenModel codegenModel = (CodegenModel)modelTemplate.get("model");
                    Map<String, Object> vendorExtensions = codegenModel.getVendorExtensions();
                    boolean isAlias = false;
                    if (vendorExtensions.get("x-is-alias") != null) {
                        isAlias = Boolean.parseBoolean(vendorExtensions.get("x-is-alias").toString());
                    }
                    if (isAlias) continue;
                }
                allModels.add(modelTemplate);
                for (String templateName : this.config.modelTemplateFiles().keySet()) {
                    String suffix = this.config.modelTemplateFiles().get(templateName);
                    String filename = this.config.modelFileFolder() + File.separator + this.config.toModelFilename(modelName) + suffix;
                    if (!this.config.shouldOverwrite(filename)) {
                        this.LOGGER.info("Skipped overwriting " + filename);
                        continue;
                    }
                    File written = this.processTemplateToFile(models, templateName, filename);
                    if (written == null) continue;
                    files.add(written);
                }
                if (this.generateModelTests.booleanValue()) {
                    this.generateModelTests(files, models, modelName);
                }
                if (!this.generateModelDocumentation.booleanValue()) continue;
                this.generateModelDocumentation(files, models, modelName);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate model '" + modelName + "'", e);
            }
        }
        if (System.getProperty("debugModels") != null) {
            this.LOGGER.info("############ Model info ############");
            Json.prettyPrint(allModels);
        }
    }

    private void generateApis(List<File> files, List<Object> allOperations, List<Object> allModels) {
        if (!this.generateApis.booleanValue()) {
            return;
        }
        boolean hasModel = true;
        if (allModels == null || allModels.isEmpty()) {
            hasModel = false;
        }
        Map<String, List<CodegenOperation>> paths = this.processPaths(this.openAPI.getPaths());
        HashSet<String> apisToGenerate = null;
        String apiNames = System.getProperty("apis");
        if (apiNames != null && !apiNames.isEmpty()) {
            apisToGenerate = new HashSet<String>(Arrays.asList(apiNames.split(",")));
        }
        if (apisToGenerate != null && !apisToGenerate.isEmpty()) {
            TreeMap<String, List<CodegenOperation>> updatedPaths = new TreeMap<String, List<CodegenOperation>>();
            for (String m : paths.keySet()) {
                if (!apisToGenerate.contains(m)) continue;
                updatedPaths.put(m, paths.get(m));
            }
            paths = updatedPaths;
        }
        for (String tag : paths.keySet()) {
            try {
                File written;
                String filename;
                List<CodegenOperation> ops = paths.get(tag);
                Collections.sort(ops, new Comparator<CodegenOperation>(){

                    @Override
                    public int compare(CodegenOperation one, CodegenOperation another) {
                        return ObjectUtils.compare((Comparable)((Object)one.operationId), (Comparable)((Object)another.operationId));
                    }
                });
                Map<String, Object> operation = this.processOperations(this.config, tag, ops, allModels);
                this.processSecurityProperties(operation);
                operation.put("basePath", this.basePath);
                operation.put("basePathWithoutHost", this.basePathWithoutHost);
                operation.put("contextPath", this.contextPath);
                operation.put("baseName", tag);
                operation.put("modelPackage", this.config.modelPackage());
                operation.putAll(this.config.additionalProperties());
                operation.put("classname", this.config.toApiName(tag));
                operation.put("classVarName", this.config.toApiVarName(tag));
                operation.put("importPath", this.config.toApiImport(tag));
                operation.put("classFilename", this.config.toApiFilename(tag));
                if (!this.config.vendorExtensions().isEmpty()) {
                    operation.put("vendorExtensions", this.config.vendorExtensions());
                }
                boolean sortParamsByRequiredFlag = true;
                if (this.config.additionalProperties().containsKey("sortParamsByRequiredFlag")) {
                    sortParamsByRequiredFlag = Boolean.valueOf(this.config.additionalProperties().get("sortParamsByRequiredFlag").toString());
                }
                operation.put("sortParamsByRequiredFlag", sortParamsByRequiredFlag);
                operation.put("hasModel", hasModel);
                allOperations.add(new HashMap<String, Object>(operation));
                for (int i = 0; i < allOperations.size(); ++i) {
                    Map oo = (Map)allOperations.get(i);
                    if (i >= allOperations.size() - 1) continue;
                    oo.put("hasMore", "true");
                }
                for (String templateName : this.config.apiTemplateFiles().keySet()) {
                    filename = this.config.apiFilename(templateName, tag);
                    if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) {
                        this.LOGGER.info("Skipped overwriting " + filename);
                        continue;
                    }
                    written = this.processTemplateToFile(operation, templateName, filename);
                    if (written == null) continue;
                    files.add(written);
                }
                if (this.generateApiTests.booleanValue()) {
                    for (String templateName : this.config.apiTestTemplateFiles().keySet()) {
                        filename = this.config.apiTestFilename(templateName, tag);
                        if (new File(filename).exists()) {
                            this.LOGGER.info("File exists. Skipped overwriting " + filename);
                            continue;
                        }
                        written = this.processTemplateToFile(operation, templateName, filename);
                        if (written == null) continue;
                        files.add(written);
                    }
                }
                if (!this.generateApiDocumentation.booleanValue()) continue;
                for (String templateName : this.config.apiDocTemplateFiles().keySet()) {
                    filename = this.config.apiDocFilename(templateName, tag);
                    if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) {
                        this.LOGGER.info("Skipped overwriting " + filename);
                        continue;
                    }
                    written = this.processTemplateToFile(operation, templateName, filename);
                    if (written == null) continue;
                    files.add(written);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate api file for '" + tag + "'", e);
            }
        }
        if (System.getProperty("debugOperations") != null) {
            this.LOGGER.info("############ Operation info ############");
            Json.prettyPrint(allOperations);
        }
    }

    private void generateSupportingFiles(List<File> files, Map<String, Object> bundle) {
        if (!this.generateSupportingFiles.booleanValue()) {
            return;
        }
        HashSet<String> supportingFilesToGenerate = null;
        String supportingFiles = System.getProperty("supportingFiles");
        boolean generateAll = false;
        if (supportingFiles != null && supportingFiles.equalsIgnoreCase("true")) {
            generateAll = true;
        } else if (supportingFiles != null && !supportingFiles.isEmpty()) {
            supportingFilesToGenerate = new HashSet<String>(Arrays.asList(supportingFiles.split(",")));
        }
        for (SupportingFile support : this.config.supportingFiles()) {
            try {
                String outputFilename;
                File of;
                String outputFolder = this.config.outputFolder();
                if (StringUtils.isNotEmpty((CharSequence)support.folder)) {
                    outputFolder = outputFolder + File.separator + support.folder;
                }
                if (!(of = new File(outputFolder)).isDirectory()) {
                    of.mkdirs();
                }
                if (!this.config.shouldOverwrite(outputFilename = outputFolder + File.separator + support.destinationFilename.replace('/', File.separatorChar))) {
                    this.LOGGER.info("Skipped overwriting " + outputFilename);
                    continue;
                }
                String templateFile = support instanceof GlobalSupportingFile ? this.config.getCommonTemplateDir() + File.separator + support.templateFile : this.getFullTemplateFile(this.config, support.templateFile);
                boolean shouldGenerate = true;
                if (!generateAll && supportingFilesToGenerate != null && !supportingFilesToGenerate.isEmpty()) {
                    shouldGenerate = supportingFilesToGenerate.contains(support.destinationFilename);
                }
                if (!shouldGenerate) continue;
                if (this.ignoreProcessor.allowsFile(new File(outputFilename))) {
                    if (templateFile.endsWith("mustache")) {
                        String rendered = this.templateEngine.getRendered(templateFile, bundle);
                        this.writeToFile(outputFilename, rendered);
                        files.add(new File(outputFilename));
                        continue;
                    }
                    InputStream in = null;
                    try {
                        in = new FileInputStream(templateFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (in == null) {
                        in = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(templateFile));
                    }
                    File outputFile = new File(outputFilename);
                    FileOutputStream out = new FileOutputStream(outputFile, false);
                    if (in != null) {
                        this.LOGGER.info("writing file " + outputFile);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        ((OutputStream)out).close();
                    } else {
                        this.LOGGER.warn("can't open " + templateFile + " for input");
                    }
                    files.add(outputFile);
                    continue;
                }
                this.LOGGER.info("Skipped generation of " + outputFilename + " due to rule in .swagger-codegen-ignore");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate supporting file '" + support + "'", e);
            }
        }
        String swaggerCodegenIgnore = ".swagger-codegen-ignore";
        String ignoreFileNameTarget = this.config.outputFolder() + File.separator + ".swagger-codegen-ignore";
        File ignoreFile = new File(ignoreFileNameTarget);
        if (this.generateSwaggerMetadata.booleanValue() && !ignoreFile.exists()) {
            String ignoreFileNameSource = File.separator + this.config.getCommonTemplateDir() + File.separator + ".swagger-codegen-ignore";
            String ignoreFileContents = this.readResourceContents(ignoreFileNameSource);
            try {
                this.writeToFile(ignoreFileNameTarget, ignoreFileContents);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate supporting file '.swagger-codegen-ignore'", e);
            }
            files.add(ignoreFile);
        }
        if (this.generateSwaggerMetadata.booleanValue()) {
            String swaggerVersionMetadata = this.config.outputFolder() + File.separator + ".swagger-codegen" + File.separator + "VERSION";
            File swaggerVersionMetadataFile = new File(swaggerVersionMetadata);
            try {
                this.writeToFile(swaggerVersionMetadata, ImplementationVersion.read());
                files.add(swaggerVersionMetadataFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate supporting file '" + swaggerVersionMetadata + "'", e);
            }
        }
    }

    private Map<String, Object> buildSupportFileBundle(List<Object> allOperations, List<Object> allModels) {
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.putAll(this.config.additionalProperties());
        bundle.put("apiPackage", this.config.apiPackage());
        HashMap<String, List<Object>> apis = new HashMap<String, List<Object>>();
        apis.put("apis", allOperations);
        URL url = URLPathUtil.getServerURL(this.openAPI, this.config);
        if (url != null) {
            bundle.put("host", url.getHost());
        }
        bundle.put("openAPI", this.openAPI);
        bundle.put("basePath", this.basePath);
        bundle.put("basePathWithoutHost", this.basePathWithoutHost);
        bundle.put("scheme", URLPathUtil.getScheme(this.openAPI, this.config));
        bundle.put("contextPath", this.contextPath);
        bundle.put("apiInfo", apis);
        bundle.put("models", allModels);
        boolean hasModel = true;
        if (allModels == null || allModels.isEmpty()) {
            hasModel = false;
        }
        bundle.put("hasModel", hasModel);
        bundle.put("apiFolder", this.config.apiPackage().replace('.', File.separatorChar));
        bundle.put("modelPackage", this.config.modelPackage());
        this.processSecurityProperties(bundle);
        if (this.openAPI.getExternalDocs() != null) {
            bundle.put("externalDocs", this.openAPI.getExternalDocs());
        }
        for (int i = 0; i < allModels.size() - 1; ++i) {
            HashMap cm = (HashMap)allModels.get(i);
            CodegenModel m = (CodegenModel)cm.get("model");
            m.getVendorExtensions().put("x-has-more-models", Boolean.TRUE);
        }
        this.config.postProcessSupportingFileData(bundle);
        if (System.getProperty("debugSupportingFiles") != null) {
            this.LOGGER.info("############ Supporting file info ############");
            Json.prettyPrint(bundle);
        }
        return bundle;
    }

    @Override
    public List<File> generate() {
        if (this.openAPI == null) {
            throw new RuntimeException("missing OpenAPI input!");
        }
        if (this.config == null) {
            throw new RuntimeException("missing configuration input!");
        }
        this.configureGeneratorProperties();
        this.configureSwaggerInfo();
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<Object> allModels = new ArrayList<Object>();
        this.generateModels(files, allModels);
        ArrayList<Object> allOperations = new ArrayList<Object>();
        this.generateApis(files, allOperations, allModels);
        Map<String, Object> bundle = this.buildSupportFileBundle(allOperations, allModels);
        this.generateSupportingFiles(files, bundle);
        this.config.processOpenAPI(this.openAPI);
        return files;
    }

    private File processTemplateToFile(Map<String, Object> templateData, String templateName, String outputFilename) throws IOException {
        String adjustedOutputFilename = outputFilename.replaceAll("//", "/").replace('/', File.separatorChar);
        if (this.ignoreProcessor.allowsFile(new File(adjustedOutputFilename))) {
            String templateFile = this.getFullTemplateFile(this.config, templateName);
            String rendered = this.templateEngine.getRendered(templateFile, templateData);
            this.writeToFile(adjustedOutputFilename, rendered);
            return new File(adjustedOutputFilename);
        }
        this.LOGGER.info("Skipped generation of " + adjustedOutputFilename + " due to rule in .swagger-codegen-ignore");
        return null;
    }

    private static void processMimeTypes(List<String> mimeTypeList, Map<String, Object> operation, String source) {
        if (mimeTypeList == null || mimeTypeList.isEmpty()) {
            return;
        }
        ArrayList c = new ArrayList();
        int count = 0;
        for (String key : mimeTypeList) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            mediaType.put("mediaType", key);
            if (++count < mimeTypeList.size()) {
                mediaType.put("hasMore", "true");
            } else {
                mediaType.put("hasMore", null);
            }
            c.add(mediaType);
        }
        operation.put(source, c);
        String flagFieldName = "has" + source.substring(0, 1).toUpperCase() + source.substring(1);
        operation.put(flagFieldName, true);
    }

    public Map<String, List<CodegenOperation>> processPaths(Paths paths) {
        TreeMap<String, List<CodegenOperation>> ops = new TreeMap<String, List<CodegenOperation>>();
        for (String resourcePath : paths.keySet()) {
            PathItem path = (PathItem)paths.get((Object)resourcePath);
            this.processOperation(resourcePath, "get", path.getGet(), ops, path);
            this.processOperation(resourcePath, "head", path.getHead(), ops, path);
            this.processOperation(resourcePath, "put", path.getPut(), ops, path);
            this.processOperation(resourcePath, "post", path.getPost(), ops, path);
            this.processOperation(resourcePath, "delete", path.getDelete(), ops, path);
            this.processOperation(resourcePath, "patch", path.getPatch(), ops, path);
            this.processOperation(resourcePath, "options", path.getOptions(), ops, path);
        }
        return ops;
    }

    private void processOperation(String resourcePath, String httpMethod, Operation operation, Map<String, List<CodegenOperation>> operations, PathItem path) {
        if (operation == null) {
            return;
        }
        if (System.getProperty("debugOperations") != null) {
            this.LOGGER.info("processOperation: resourcePath= " + resourcePath + "\t;" + httpMethod + " " + operation + "\n");
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List tagNames = operation.getTags();
        List swaggerTags = this.openAPI.getTags();
        if (tagNames != null) {
            if (swaggerTags == null) {
                for (Iterator tagName : tagNames) {
                    tags.add(new Tag().name(tagName));
                }
            } else {
                for (Iterator tagName : tagNames) {
                    boolean foundTag = false;
                    for (Tag tag : swaggerTags) {
                        if (!tag.getName().equals(tagName)) continue;
                        tags.add(tag);
                        foundTag = true;
                        break;
                    }
                    if (foundTag) continue;
                    tags.add(new Tag().name(tagName));
                }
            }
        }
        if (tags.isEmpty()) {
            tags.add(new Tag().name("default"));
        }
        HashSet<String> operationParameters = new HashSet<String>();
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                operationParameters.add(DefaultGenerator.generateParameterId(parameter));
            }
        }
        if (path.getParameters() != null) {
            for (Parameter parameter : path.getParameters()) {
                if (operationParameters.contains(DefaultGenerator.generateParameterId(parameter)) || operation.getParameters() == null) continue;
                operation.getParameters().add(parameter);
            }
        }
        Map schemas = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSchemas() : null;
        Map securitySchemes = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null;
        List globalSecurities = this.openAPI.getSecurity();
        for (Tag tag : tags) {
            try {
                CodegenOperation codegenOperation = this.config.fromOperation(resourcePath, httpMethod, operation, schemas, this.openAPI);
                codegenOperation.tags = new ArrayList<Tag>(tags);
                this.config.addOperationToGroup(this.config.sanitizeTag(tag.getName()), resourcePath, operation, codegenOperation, operations);
                List securities = operation.getSecurity();
                if (securities != null && securities.isEmpty()) continue;
                Map<String, SecurityScheme> authMethods = this.getAuthMethods(securities, securitySchemes);
                if (authMethods == null || authMethods.isEmpty()) {
                    authMethods = this.getAuthMethods(globalSecurities, securitySchemes);
                }
                if (authMethods == null || authMethods.isEmpty()) continue;
                codegenOperation.authMethods = this.config.fromSecurity(authMethods);
                codegenOperation.getVendorExtensions().put("x-has-auth-methods", Boolean.TRUE);
            }
            catch (Exception ex) {
                String msg = "Could not process operation:\n  Tag: " + tag + "\n  Operation: " + operation.getOperationId() + "\n  Resource: " + httpMethod + " " + resourcePath + "\n  Exception: " + ex.getMessage();
                throw new RuntimeException(msg, ex);
            }
        }
    }

    private static String generateParameterId(Parameter parameter) {
        return parameter.getName() + ":" + parameter.getIn();
    }

    private Map<String, Object> processOperations(CodegenConfig config, String tag, List<CodegenOperation> ops, List<Object> allModels) {
        List list;
        HashMap<String, Object> operations = new HashMap<String, Object>();
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("classname", config.toApiName(tag));
        objs.put("pathPrefix", config.toApiVarName(tag));
        HashSet<String> opIds = new HashSet<String>();
        int counter = 0;
        for (CodegenOperation codegenOperation : ops) {
            String string = codegenOperation.nickname;
            if (opIds.contains(string)) {
                codegenOperation.nickname = codegenOperation.nickname + "_" + ++counter;
            }
            opIds.add(string);
        }
        objs.put("operation", ops);
        operations.put("operations", objs);
        operations.put("package", config.apiPackage());
        TreeSet<String> allImports = new TreeSet<String>();
        for (CodegenOperation codegenOperation : ops) {
            allImports.addAll(codegenOperation.imports);
        }
        ArrayList arrayList = new ArrayList();
        for (String nextImport : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping == null) continue;
            im.put("import", mapping);
            arrayList.add(im);
        }
        operations.put("imports", arrayList);
        if (arrayList.size() > 0) {
            operations.put("hasImport", true);
        }
        config.postProcessOperations(operations);
        config.postProcessOperationsWithModels(operations, allModels);
        if (objs.size() > 0 && (list = (List)objs.get("operation")) != null && list.size() > 0) {
            CodegenOperation op = (CodegenOperation)list.get(list.size() - 1);
            op.getVendorExtensions().put("x-has-more", Boolean.FALSE);
        }
        return operations;
    }

    private Map<String, Object> processModels(CodegenConfig config, Map<String, Schema> definitions, Map<String, Schema> allDefinitions) {
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("package", config.modelPackage());
        ArrayList models = new ArrayList();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (String string : definitions.keySet()) {
            Schema schema = definitions.get(string);
            CodegenModel cm = config.fromModel(string, schema, allDefinitions);
            HashMap<String, Object> mo = new HashMap<String, Object>();
            mo.put("model", cm);
            mo.put("schema", schema);
            mo.put("importPath", config.toModelImport(cm.classname));
            models.add(mo);
            allImports.addAll(cm.imports);
        }
        objs.put("models", models);
        TreeSet<String> importSet = new TreeSet<String>();
        for (String nextImport : allImports) {
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping != null && !config.defaultIncludes().contains(mapping)) {
                importSet.add(mapping);
            }
            if ((mapping = config.instantiationTypes().get(nextImport)) == null || config.defaultIncludes().contains(mapping)) continue;
            importSet.add(mapping);
        }
        ArrayList arrayList = new ArrayList();
        for (String s : importSet) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", s);
            arrayList.add(item);
        }
        objs.put("imports", arrayList);
        config.postProcessModels(objs);
        return objs;
    }

    private Map<String, Object> processModel(CodegenModel codegenModel, CodegenConfig config, Map<String, Schema> allDefinitions) {
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("package", config.modelPackage());
        ArrayList models = new ArrayList();
        objs.put("x-is-composed-model", codegenModel.isComposedModel);
        HashMap<String, Object> modelObject = new HashMap<String, Object>();
        modelObject.put("model", codegenModel);
        modelObject.put("importPath", config.toModelImport(codegenModel.classname));
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        allImports.addAll(codegenModel.imports);
        models.add(modelObject);
        objs.put("models", models);
        TreeSet<String> importSet = new TreeSet<String>();
        for (String nextImport : allImports) {
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping != null && !config.defaultIncludes().contains(mapping)) {
                importSet.add(mapping);
            }
            if ((mapping = config.instantiationTypes().get(nextImport)) == null || config.defaultIncludes().contains(mapping)) continue;
            importSet.add(mapping);
        }
        ArrayList imports = new ArrayList();
        for (String s : importSet) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", s);
            imports.add(item);
        }
        objs.put("imports", imports);
        config.postProcessModels(objs);
        return objs;
    }

    private Map<String, SecurityScheme> getAuthMethods(List<SecurityRequirement> securities, Map<String, SecurityScheme> securitySchemes) {
        if (securities == null || securitySchemes == null || securitySchemes.isEmpty()) {
            return null;
        }
        HashMap<String, SecurityScheme> authMethods = new HashMap<String, SecurityScheme>();
        for (SecurityRequirement requirement : securities) {
            for (String key : requirement.keySet()) {
                SecurityScheme securityScheme = securitySchemes.get(key);
                if (securityScheme == null) continue;
                authMethods.put(key, securityScheme);
            }
        }
        return authMethods;
    }

    private Boolean getCustomOptionBooleanValue(String option) {
        List<CodegenArgument> languageArguments = this.config.getLanguageArguments();
        if (languageArguments == null || languageArguments.isEmpty()) {
            return null;
        }
        Optional<CodegenArgument> optionalCodegenArgument = languageArguments.stream().filter(argument -> option.equalsIgnoreCase(argument.getOption())).findFirst();
        if (!optionalCodegenArgument.isPresent()) {
            return null;
        }
        return Boolean.valueOf(optionalCodegenArgument.get().getValue());
    }

    protected void processSecurityProperties(Map<String, Object> bundle) {
        Map securitySchemeMap = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null;
        List<CodegenSecurity> authMethods = this.config.fromSecurity(securitySchemeMap);
        if (authMethods != null && !authMethods.isEmpty()) {
            bundle.put("authMethods", authMethods);
            bundle.put("hasAuthMethods", true);
        }
    }
}

