/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.service;

import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.DefaultGenerator;
import io.swagger.codegen.v3.service.GenerationRequest;
import io.swagger.codegen.v3.service.GeneratorUtil;
import io.swagger.codegen.v3.service.exception.BadRequestException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorService {
    protected final Logger LOGGER = LoggerFactory.getLogger(GeneratorService.class);
    private GenerationRequest generationRequest;
    private ClientOptInput optsV3;
    private io.swagger.codegen.ClientOptInput optsV2;

    public GeneratorService generationRequest(GenerationRequest generationRequest) {
        this.generationRequest = generationRequest;
        if (GenerationRequest.CodegenVersion.V2.equals((Object)generationRequest.getCodegenVersion())) {
            io.swagger.codegen.ClientOptInput clientOptInputV2;
            try {
                clientOptInputV2 = GeneratorUtil.getClientOptInputV2(generationRequest);
            }
            catch (Exception e) {
                String msg = "Error processing input options: " + e.getMessage();
                this.LOGGER.error(msg, (Throwable)e);
                throw new BadRequestException(msg);
            }
            this.optsV2 = clientOptInputV2;
        } else {
            ClientOptInput clientOptInput;
            try {
                clientOptInput = GeneratorUtil.getClientOptInput(generationRequest);
            }
            catch (Exception e) {
                String msg = "Error processing input options: " + e.getMessage();
                this.LOGGER.error(msg, (Throwable)e);
                throw new BadRequestException(msg);
            }
            this.optsV3 = clientOptInput;
        }
        return this;
    }

    public List<File> generate() {
        if (this.optsV3 != null) {
            return new DefaultGenerator().opts(this.optsV3).generate();
        }
        if (this.optsV2 != null) {
            return new io.swagger.codegen.DefaultGenerator().opts(this.optsV2).generate();
        }
        throw new RuntimeException("missing opts input");
    }

    public Map<String, Object> generateBundle() {
        if (this.optsV3 != null) {
            return new DefaultGenerator().opts(this.optsV3).generateBundle();
        }
        throw new RuntimeException("missing opts input");
    }
}

