/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.exception.EncodingNotSupportedException;
import io.swagger.v3.parser.exception.ReadContentException;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.InlineModelResolver;
import io.swagger.v3.parser.util.OpenAPIDeserializer;
import io.swagger.v3.parser.util.RemoteUrl;
import io.swagger.v3.parser.util.ResolverFully;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIV3Parser
implements SwaggerParserExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIV3Parser.class);
    private static ObjectMapper JSON_MAPPER;
    private static ObjectMapper YAML_MAPPER;
    private static String encoding;

    public static List<SwaggerParserExtension> getExtensions() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        List<SwaggerParserExtension> extensions = OpenAPIV3Parser.getExtensions(tccl);
        ClassLoader cl = SwaggerParserExtension.class.getClassLoader();
        if (cl != tccl) {
            extensions.addAll(OpenAPIV3Parser.getExtensions(cl));
        }
        extensions.add(0, new OpenAPIV3Parser());
        return extensions;
    }

    protected static List<SwaggerParserExtension> getExtensions(ClassLoader cl) {
        ArrayList<SwaggerParserExtension> extensions = new ArrayList<SwaggerParserExtension>();
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class, cl);
        for (SwaggerParserExtension extension : loader) {
            extensions.add(extension);
        }
        return extensions;
    }

    public static String getEncoding() {
        return encoding;
    }

    public static void setEncoding(String encoding) {
        if (!Charset.isSupported(encoding)) {
            throw new EncodingNotSupportedException(encoding);
        }
        OpenAPIV3Parser.encoding = encoding;
    }

    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auth, ParseOptions options) {
        try {
            String content = this.readContentFromLocation(url, this.emptyListIfNull(auth));
            LOGGER.debug("Loaded raw data: {}", (Object)content);
            return this.readContents(content, auth, options, url);
        }
        catch (ReadContentException e) {
            LOGGER.warn("Exception while reading:", (Throwable)e);
            return SwaggerParseResult.ofError((String)e.getMessage());
        }
    }

    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options) {
        return this.readContents(swaggerAsString, auth, options, null);
    }

    public OpenAPI read(String location) {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        return this.read(location, null, options);
    }

    public OpenAPI read(String location, List<AuthorizationValue> auths, ParseOptions resolve) {
        if (location == null) {
            return null;
        }
        List<SwaggerParserExtension> parserExtensions = OpenAPIV3Parser.getExtensions();
        for (SwaggerParserExtension extension : parserExtensions) {
            SwaggerParseResult parsed = extension.readLocation(location, auths, resolve);
            for (String message : parsed.getMessages()) {
                LOGGER.info("{}: {}", (Object)extension, (Object)message);
            }
            OpenAPI result = parsed.getOpenAPI();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Deprecated
    public SwaggerParseResult readWithInfo(String path, JsonNode node) {
        return this.parseJsonNode(path, node);
    }

    public SwaggerParseResult parseJsonNode(String path, JsonNode node) {
        return new OpenAPIDeserializer().deserialize(node, path);
    }

    public SwaggerParseResult readContents(String yaml) {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        return this.readContents(yaml, null, options);
    }

    private SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options, String location) {
        if (swaggerAsString == null || swaggerAsString.trim().isEmpty()) {
            return SwaggerParseResult.ofError((String)"Null or empty definition");
        }
        try {
            ObjectMapper mapper = this.getRightMapper(swaggerAsString);
            JsonNode rootNode = mapper.readTree(swaggerAsString);
            SwaggerParseResult result = this.parseJsonNode(location, rootNode);
            if (result.getOpenAPI() != null) {
                return this.resolve(result, auth, options, location);
            }
            return result;
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Exception while parsing:", (Throwable)e);
            String message = this.getParseErrorMessage(e.getOriginalMessage(), location);
            return SwaggerParseResult.ofError((String)message);
        }
    }

    @Deprecated
    public SwaggerParseResult readWithInfo(String location, List<AuthorizationValue> auths) {
        return this.readContents(this.readContentFromLocation(location, auths), auths, null);
    }

    private SwaggerParseResult resolve(SwaggerParseResult result, List<AuthorizationValue> auth, ParseOptions options, String location) {
        try {
            if (options != null) {
                if (options.isResolve() || options.isResolveFully()) {
                    result.setOpenAPI(new OpenAPIResolver(result.getOpenAPI(), this.emptyListIfNull(auth), location).resolve());
                    if (options.isResolveFully()) {
                        new ResolverFully(options.isResolveCombinators()).resolveFully(result.getOpenAPI());
                    }
                }
                if (options.isFlatten()) {
                    InlineModelResolver inlineModelResolver = new InlineModelResolver(options.isFlattenComposedSchemas(), options.isCamelCaseFlattenNaming(), options.isSkipMatches());
                    if (result.getOpenAPI() != null) {
                        inlineModelResolver.flatten(result.getOpenAPI());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while resolving:", (Throwable)e);
            result.setMessages(Collections.singletonList(e.getMessage()));
        }
        return result;
    }

    private String getParseErrorMessage(String originalMessage, String location) {
        if (Objects.isNull(originalMessage)) {
            return String.format("Unable to parse `%s`", location);
        }
        if (originalMessage.startsWith("Duplicate field")) {
            return String.format(originalMessage + " in `%s`", location);
        }
        return originalMessage;
    }

    private <T> List<T> emptyListIfNull(List<T> list) {
        return Objects.isNull(list) ? new ArrayList() : list;
    }

    private ObjectMapper getRightMapper(String data) {
        if (data.trim().startsWith("{")) {
            return JSON_MAPPER;
        }
        return YAML_MAPPER;
    }

    private String readContentFromLocation(String location, List<AuthorizationValue> auth) {
        String adjustedLocation = location.replaceAll("\\\\", "/");
        try {
            Path path;
            if (adjustedLocation.toLowerCase().startsWith("http")) {
                return RemoteUrl.urlToString(adjustedLocation, auth);
            }
            String fileScheme = "file:";
            Path path2 = path = adjustedLocation.toLowerCase().startsWith("file:") ? Paths.get(URI.create(adjustedLocation)) : Paths.get(adjustedLocation, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                return FileUtils.readFileToString((File)path.toFile(), (String)encoding);
            }
            return ClasspathHelper.loadFileFromClasspath(adjustedLocation);
        }
        catch (SSLHandshakeException e) {
            String message = String.format("Unable to read location `%s` due to a SSL configuration error. It is possible that the server SSL certificate is invalid, self-signed, or has an untrusted Certificate Authority.", adjustedLocation);
            throw new ReadContentException(message, e);
        }
        catch (Exception e) {
            throw new ReadContentException(String.format("Unable to read location `%s`", adjustedLocation), e);
        }
    }

    @Deprecated
    protected List<AuthorizationValue> transform(List<AuthorizationValue> input) {
        if (input == null) {
            return null;
        }
        ArrayList<AuthorizationValue> output = new ArrayList<AuthorizationValue>();
        for (AuthorizationValue value : input) {
            AuthorizationValue v = new AuthorizationValue();
            v.setKeyName(value.getKeyName());
            v.setValue(value.getValue());
            v.setType(value.getType());
            v.setUrlMatcher(value.getUrlMatcher());
            output.add(v);
        }
        return output;
    }

    static {
        encoding = StandardCharsets.UTF_8.displayName();
        JSON_MAPPER = ObjectMapperFactory.createJson();
        YAML_MAPPER = ObjectMapperFactory.createYaml();
    }
}

