/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaPKMSTServerCodegen
extends AbstractJavaCodegen {
    public static final String FULL_JAVA_UTIL = "fullJavaUtil";
    public static final String SUPPORT_JAVA6 = "supportJava6";
    public static final String CONFIG_PACKAGE = "configPackage";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String TITLE = "title";
    public static final String WITH_XML = "withXml";
    public static final String EUREKA_URI = "eurekaUri";
    public static final String ZIPKIN_URI = "zipkinUri";
    public static final String SPRINGADMIN_URI = "springBootAdminUri";
    protected String projectFolder = "src" + File.separator + "main";
    protected String projectTestFolder = "src" + File.separator + "test";
    protected String sourceFolder = this.projectFolder + File.separator + "java";
    protected String testFolder = this.projectTestFolder + File.separator + "java";
    protected String basePackage = "com.prokarma.pkmst";
    protected String serviceName = "Pkmst";
    protected String configPackage = "com.prokarma.pkmst.config";
    protected boolean implicitHeaders = false;
    protected boolean serializeBigDecimalAsString = false;
    protected boolean withXml = false;
    protected boolean fullJavaUtil;
    protected String javaUtilPrefix = "";
    protected Boolean serializableModel = false;
    protected String invokerPackage;
    protected String title;
    protected String eurekaUri;
    protected String zipkinUri;
    protected String springBootAdminUri;

    public JavaPKMSTServerCodegen() {
        this.groupId = "com.prokarma";
        this.artifactId = "pkmst-microservice";
        this.artifactVersion = "1.0.0";
        this.templateDir = "java-pkmst";
        this.embeddedTemplateDir = "java-pkmst";
        this.apiPackage = "com.prokarma.pkmst.controller";
        this.modelPackage = "com.prokarma.pkmst.model";
        this.invokerPackage = "com.prokarma.pkmst.controller";
        this.additionalProperties.put("jackson", "true");
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml"));
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "base package for java source code"));
        this.cliOptions.add(new CliOption("serviceName", "Service Name"));
        this.cliOptions.add(new CliOption(TITLE, "server title name or client service name"));
        this.cliOptions.add(new CliOption(EUREKA_URI, "Eureka URI"));
        this.cliOptions.add(new CliOption(ZIPKIN_URI, "Zipkin URI"));
        this.cliOptions.add(new CliOption(SPRINGADMIN_URI, "Spring-Boot URI"));
        this.cliOptions.add(new CliOption("pkmstInterceptor", "PKMST Interceptor"));
        this.apiTestTemplateFiles.put("api_test.mustache", ".java");
        if (".md".equals(this.modelDocTemplateFiles.get("model_doc.mustache"))) {
            this.modelDocTemplateFiles.remove("model_doc.mustache");
        }
        if (".md".equals(this.apiDocTemplateFiles.get("api_doc.mustache"))) {
            this.apiDocTemplateFiles.remove("api_doc.mustache");
        }
    }

    private static String getAccept(Operation operation) {
        String accepts = null;
        String defaultContentType = "application/json";
        if (operation.getProduces() != null && !operation.getProduces().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String produces : operation.getProduces()) {
                if (defaultContentType.equalsIgnoreCase(produces)) {
                    accepts = defaultContentType;
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(produces);
            }
            if (accepts == null) {
                accepts = sb.toString();
            }
        } else {
            accepts = defaultContentType;
        }
        return accepts;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-pkmst";
    }

    @Override
    public String getHelp() {
        return "Generates a PKMST SpringBoot Server application using the SpringFox integration. Also enables EurekaServerClient / Zipkin / Spring-Boot admin";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
            this.setInvokerPackage(this.getBasePackage());
            this.apiPackage = this.getBasePackage() + ".controller";
            this.modelPackage = this.getBasePackage() + ".model";
            this.setConfigPackage(this.getBasePackage() + ".config");
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            this.additionalProperties.put(CONFIG_PACKAGE, this.getConfigPackage());
            this.additionalProperties.put("apiPackage", this.apiPackage);
            this.additionalProperties.put("modelPackage", this.modelPackage);
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("serviceName")) {
            this.setServiceName((String)this.additionalProperties.get("serviceName"));
        } else {
            this.additionalProperties.put("serviceName", this.serviceName);
        }
        if (this.additionalProperties.containsKey("bigDecimalAsString")) {
            this.setSerializeBigDecimalAsString(Boolean.valueOf(this.additionalProperties.get("bigDecimalAsString").toString()));
        }
        if (this.additionalProperties.containsKey("serializableModel")) {
            this.setSerializableModel(Boolean.valueOf(this.additionalProperties.get("serializableModel").toString()));
        }
        if (this.additionalProperties.containsKey(TITLE)) {
            this.setTitle((String)this.additionalProperties.get(TITLE));
        }
        this.additionalProperties.put("serializableModel", this.serializableModel);
        if (this.additionalProperties.containsKey(FULL_JAVA_UTIL)) {
            this.setFullJavaUtil(Boolean.valueOf(this.additionalProperties.get(FULL_JAVA_UTIL).toString()));
        }
        if (this.additionalProperties.containsKey(EUREKA_URI)) {
            this.setEurekaUri((String)this.additionalProperties.get(EUREKA_URI));
        }
        if (this.additionalProperties.containsKey(ZIPKIN_URI)) {
            this.setZipkinUri((String)this.additionalProperties.get(ZIPKIN_URI));
        }
        if (this.additionalProperties.containsKey(SPRINGADMIN_URI)) {
            this.setSpringBootAdminUri((String)this.additionalProperties.get(SPRINGADMIN_URI));
        }
        if (this.fullJavaUtil) {
            this.javaUtilPrefix = "java.util.";
        }
        this.additionalProperties.put(FULL_JAVA_UTIL, this.fullJavaUtil);
        this.additionalProperties.put("javaUtilPrefix", this.javaUtilPrefix);
        this.additionalProperties.put(SUPPORT_JAVA6, false);
        this.additionalProperties.put("java8", true);
        if (this.additionalProperties.containsKey(WITH_XML)) {
            this.setWithXml(Boolean.valueOf(this.additionalProperties.get(WITH_XML).toString()));
        }
        this.additionalProperties.put(WITH_XML, this.withXml);
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTemplateFiles.put("apiController.mustache", "Controller.java");
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.supportingFiles.add(new SupportingFile("SpringBootApplication.mustache", (this.getSourceFolder() + File.separator + this.getBasePackage()).replace(".", File.separator), this.getServiceName() + "Application.java"));
        this.supportingFiles.add(new SupportingFile("config" + File.separator + "swaggerDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.getConfigPackage()).replace(".", File.separator) + File.separator + "swagger", "SwaggerDocumentationConfig.java"));
        this.supportingFiles.add(new SupportingFile("config" + File.separator + "pkmstproperties.mustache", (this.sourceFolder + File.separator + this.getConfigPackage()).replace(".", File.separator) + File.separator + "swagger", "PkmstProperties.java"));
        this.supportingFiles.add(new SupportingFile("config" + File.separator + "appconfig.mustache", (this.sourceFolder + File.separator + this.getConfigPackage()).replace(".", File.separator) + File.separator, "AppConfig.java"));
        this.supportingFiles.add(new SupportingFile("security" + File.separator + "authorizationServerConfiguration.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "security", "AuthorizationServerConfiguration.java"));
        this.supportingFiles.add(new SupportingFile("security" + File.separator + "oAuth2SecurityConfiguration.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "security", "OAuth2SecurityConfiguration.java"));
        this.supportingFiles.add(new SupportingFile("security" + File.separator + "resourceServerConfiguration.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "security", "ResourceServerConfiguration.java"));
        this.supportingFiles.add(new SupportingFile("logging" + File.separator + "httpLoggingFilter.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "logging", "HttpLoggingFilter.java"));
        this.supportingFiles.add(new SupportingFile("resources" + File.separator + "application-local.mustache", "src.main.resources".replace(".", File.separator), "application-local.yml"));
        this.supportingFiles.add(new SupportingFile("resources" + File.separator + "application-dev.mustache", "src.main.resources".replace(".", File.separator), "application-dev.yml"));
        this.supportingFiles.add(new SupportingFile("resources" + File.separator + "application-dev-config.mustache", "src.main.resources".replace(".", File.separator), "application-dev-config.yml"));
        this.supportingFiles.add(new SupportingFile("resources" + File.separator + "bootstrap.mustache", "src.main.resources".replace(".", File.separator), "bootstrap.yml"));
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("readme.mustache", "", "Readme.md"));
        this.supportingFiles.add(new SupportingFile("manifest.mustache", "", "manifest.yml"));
        this.supportingFiles.add(new SupportingFile("docker.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("logstash.mustache", "", "logstash.conf"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "executeReport.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "cucumber" + File.separator + "report", "ExecuteReport.java"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "cucumberTest.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "cucumber", this.serviceName + "Test.java"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "cucumberSteps.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "cucumber", this.serviceName + "Steps.java"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "package.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "cucumber", this.serviceName + "package-info.java"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "cucumber.mustache", ("src.test.resources" + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "cucumber", this.serviceName + ".feature"));
        this.supportingFiles.add(new SupportingFile("testresources" + File.separator + "bootstrap.mustache", "src.test.resources".replace(".", File.separator), "bootstrap.yml"));
        this.supportingFiles.add(new SupportingFile("testresources" + File.separator + "application.mustache", "src.test.resources".replace(".", File.separator), "application.properties"));
        this.supportingFiles.add(new SupportingFile("testresources" + File.separator + "application-test.mustache", "src.test.resources".replace(".", File.separator), "application-test.properties"));
        this.supportingFiles.add(new SupportingFile("gatling" + File.separator + "gatling.mustache", "src.test.resources".replace(".", File.separator), "gatling.conf"));
        this.supportingFiles.add(new SupportingFile("gatling" + File.separator + "application.mustache", "src.test.resources".replace(".", File.separator), "application.conf"));
        this.supportingFiles.add(new SupportingFile("gatling" + File.separator + "testapi.mustache", "src" + File.separator + "test" + File.separator + "scala" + File.separator + "scalaFiles".replace(".", File.separator), "testapi.scala"));
        this.supportingFiles.add(new SupportingFile("integration" + File.separator + "integrationtest.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "controller", this.serviceName + "IT.java"));
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (final CodegenOperation operation : ops) {
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (final CodegenResponse resp : responses) {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        this.doDataTypeAssignment(resp.dataType, new DataTypeAssigner(){

                            @Override
                            public void setReturnType(String returnType) {
                                resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                resp.containerType = returnContainer;
                            }
                        });
                    }
                }
                this.doDataTypeAssignment(operation.returnType, new DataTypeAssigner(){

                    @Override
                    public void setReturnType(String returnType) {
                        operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        operation.returnContainer = returnContainer;
                    }
                });
                if (!this.implicitHeaders) continue;
                this.removeHeadersFromAllParams(operation.allParams);
            }
        }
        return objs;
    }

    private void removeHeadersFromAllParams(List<CodegenParameter> allParams) {
        if (allParams.isEmpty()) {
            return;
        }
        ArrayList<CodegenParameter> copy = new ArrayList<CodegenParameter>(allParams);
        allParams.clear();
        for (CodegenParameter p : copy) {
            if (p.isHeaderParam) continue;
            allParams.add(p);
        }
        allParams.get((int)(allParams.size() - 1)).hasMore = false;
    }

    private void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        int end;
        String rt = returnType;
        if (rt == null) {
            dataTypeAssigner.setReturnType("Void");
        } else if (rt.startsWith("List")) {
            int end2 = rt.lastIndexOf(">");
            if (end2 > 0) {
                dataTypeAssigner.setReturnType(rt.substring("List<".length(), end2).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (rt.startsWith("Map")) {
            int end3 = rt.lastIndexOf(">");
            if (end3 > 0) {
                dataTypeAssigner.setReturnType(rt.substring("Map<".length(), end3).split(",")[1].trim());
                dataTypeAssigner.setReturnContainer("Map");
            }
        } else if (rt.startsWith("Set") && (end = rt.lastIndexOf(">")) > 0) {
            dataTypeAssigner.setReturnType(rt.substring("Set<".length(), end).trim());
            dataTypeAssigner.setReturnContainer("Set");
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(model.isEnum)) {
            model.imports.add("JsonProperty");
            if (Boolean.TRUE.equals(model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        String[] parts;
        Map vendorExt;
        super.preprocessSwagger(swagger);
        if (swagger == null || swagger.getPaths() == null) {
            return;
        }
        if (swagger.getTags() != null) {
            ArrayList<ResourcePath> resourcePaths = new ArrayList<ResourcePath>();
            for (Tag tag : swagger.getTags()) {
                ResourcePath resourcePath = new ResourcePath();
                resourcePath.setPath(tag.getName());
                resourcePaths.add(resourcePath);
            }
            this.additionalProperties.put("resourcePaths", resourcePaths);
        }
        if ((vendorExt = swagger.getInfo().getVendorExtensions()) != null && !vendorExt.toString().equals("") && vendorExt.containsKey("x-codegen")) {
            Map uris = (Map)vendorExt.get("x-codegen");
            if (uris.containsKey(EUREKA_URI)) {
                String eurekaUri = (String)uris.get(EUREKA_URI);
                this.additionalProperties.put(EUREKA_URI, eurekaUri);
            }
            if (uris.containsKey(ZIPKIN_URI)) {
                String zipkinUri = (String)uris.get(ZIPKIN_URI);
                this.additionalProperties.put(ZIPKIN_URI, zipkinUri);
            }
            if (uris.containsKey(SPRINGADMIN_URI)) {
                String springBootAdminUri = (String)uris.get(SPRINGADMIN_URI);
                this.additionalProperties.put(SPRINGADMIN_URI, springBootAdminUri);
            }
            if (uris.containsKey("pkmstInterceptor")) {
                String pkmstInterceptor = (String)uris.get("pkmstInterceptor");
                this.additionalProperties.put("pkmstInterceptor", pkmstInterceptor);
            }
        }
        for (String pathname : swagger.getPaths().keySet()) {
            Path path = swagger.getPath(pathname);
            if (path.getOperations() == null) continue;
            for (Operation operation : path.getOperations()) {
                boolean hasFormParameters = false;
                for (Parameter parameter : operation.getParameters()) {
                    if (!(parameter instanceof FormParameter)) continue;
                    hasFormParameters = true;
                }
                if (path.getGet() != null || !operation.equals((Object)path.getGet())) {
                    String defaultContentType = hasFormParameters ? "application/x-www-form-urlencoded" : "application/json";
                    String contentType = operation.getConsumes() == null || operation.getConsumes().isEmpty() ? defaultContentType : (String)operation.getConsumes().get(0);
                    operation.setVendorExtension("x-contentType", (Object)contentType);
                }
                String accepts = JavaPKMSTServerCodegen.getAccept(operation);
                operation.setVendorExtension("x-accepts", (Object)accepts);
            }
        }
        if ("/".equals(swagger.getBasePath())) {
            swagger.setBasePath("");
        }
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = swagger.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase().endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = JavaPKMSTServerCodegen.camelize(this.sanitizeName(title), true);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        String host = swagger.getHost();
        String port = "8008";
        if (host != null && (parts = host.split(":")).length > 1) {
            port = parts[1];
        }
        this.additionalProperties.put("serverPort", port);
        if (swagger.getPaths() != null) {
            for (String pathname : swagger.getPaths().keySet()) {
                Path path = swagger.getPath(pathname);
                if (path.getOperations() == null) continue;
                for (Operation operation : path.getOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        value.put("hasMore", "true");
                        tags.add(value);
                    }
                    if (tags.size() > 0) {
                        ((Map)tags.get(tags.size() - 1)).remove("hasMore");
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.setVendorExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        co.subresourceOperation = !co.path.isEmpty();
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return JavaPKMSTServerCodegen.camelize(name) + "Api";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace(".", "/");
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.testFolder + "/" + this.apiPackage().replace(".", "/");
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace(".", "/");
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace("/", File.separator);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace("/", File.separator);
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    @Override
    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public String getProjectFolder() {
        return this.projectFolder;
    }

    public void setProjectFolder(String projectFolder) {
        this.projectFolder = projectFolder;
    }

    public String getEurekaUri() {
        return this.eurekaUri;
    }

    public void setEurekaUri(String eurekaUri) {
        this.eurekaUri = eurekaUri;
    }

    public String getZipkinUri() {
        return this.zipkinUri;
    }

    public void setZipkinUri(String zipkinUri) {
        this.zipkinUri = zipkinUri;
    }

    public String getSpringBootAdminUri() {
        return this.springBootAdminUri;
    }

    public void setSpringBootAdminUri(String springBootAdminUri) {
        this.springBootAdminUri = springBootAdminUri;
    }

    public String getProjectTestFolder() {
        return this.projectTestFolder;
    }

    public void setProjectTestFolder(String projectTestFolder) {
        this.projectTestFolder = projectTestFolder;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    @Override
    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getTestFolder() {
        return this.testFolder;
    }

    @Override
    public void setTestFolder(String testFolder) {
        this.testFolder = testFolder;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getConfigPackage() {
        return this.configPackage;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public boolean isImplicitHeaders() {
        return this.implicitHeaders;
    }

    public void setImplicitHeaders(boolean implicitHeaders) {
        this.implicitHeaders = implicitHeaders;
    }

    public boolean isSerializeBigDecimalAsString() {
        return this.serializeBigDecimalAsString;
    }

    @Override
    public void setSerializeBigDecimalAsString(boolean serializeBigDecimalAsString) {
        this.serializeBigDecimalAsString = serializeBigDecimalAsString;
    }

    public boolean isFullJavaUtil() {
        return this.fullJavaUtil;
    }

    @Override
    public void setFullJavaUtil(boolean fullJavaUtil) {
        this.fullJavaUtil = fullJavaUtil;
    }

    public Boolean getSerializableModel() {
        return this.serializableModel;
    }

    @Override
    public void setSerializableModel(Boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    @Override
    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isWithXml() {
        return this.withXml;
    }

    @Override
    public void setWithXml(boolean withXml) {
        this.withXml = withXml;
    }

    private class ResourcePath {
        private String path;

        private ResourcePath() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path;
        }
    }

    private static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);
    }
}

