/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractTypeScriptClientCodegen;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.Property;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeScriptJqueryClientCodegen
extends AbstractTypeScriptClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeScriptJqueryClientCodegen.class);
    private static final SimpleDateFormat SNAPSHOT_SUFFIX_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    public static final String NPM_NAME = "npmName";
    public static final String NPM_VERSION = "npmVersion";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String SNAPSHOT = "snapshot";
    public static final String JQUERY_ALREADY_IMPORTED = "jqueryAlreadyImported";
    protected String npmName = null;
    protected String npmVersion = "1.0.0";
    protected String npmRepository = null;

    public TypeScriptJqueryClientCodegen() {
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api.mustache", ".ts");
        this.typeMapping.put("Date", "Date");
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.outputFolder = "generated-code/typescript-jquery";
        this.templateDir = "typescript-jquery";
        this.embeddedTemplateDir = "typescript-jquery";
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package"));
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(SNAPSHOT, "When setting this property to true the version will be suffixed with -SNAPSHOT.yyyyMMddHHmm", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(JQUERY_ALREADY_IMPORTED, "When using this in legacy app using mix of typescript and javascript, this will only declare jquery and not import it", "boolean").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', File.separatorChar), "models.ts"));
        this.supportingFiles.add(new SupportingFile("apis.mustache", this.apiPackage().replace('.', File.separatorChar), "api.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.getIndexDirectory(), "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.getIndexDirectory(), "index.ts"));
        this.supportingFiles.add(new SupportingFile("variables.mustache", this.getIndexDirectory(), "variables.ts"));
        LOGGER.warn("check additionals: " + this.additionalProperties.get(NPM_NAME));
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.addNpmPackageGeneration();
        }
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        if (this.isLanguagePrimitive(swaggerType) || this.isLanguageGenericType(swaggerType)) {
            return swaggerType;
        }
        return this.addModelPrefix(swaggerType);
    }

    private String addModelPrefix(String swaggerType) {
        String type = null;
        type = this.typeMapping.containsKey(swaggerType) ? (String)this.typeMapping.get(swaggerType) : swaggerType;
        if (!this.isLanguagePrimitive(type) && !this.isLanguageGenericType(type)) {
            type = "models." + swaggerType;
        }
        return type;
    }

    private boolean isLanguagePrimitive(String type) {
        return this.languageSpecificPrimitives.contains(type);
    }

    private boolean isLanguageGenericType(String type) {
        for (String genericType : this.languageGenericTypes) {
            if (!type.startsWith(genericType + "<")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        parameter.dataType = this.addModelPrefix(parameter.dataType);
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.valueOf(this.additionalProperties.get(SNAPSHOT).toString()).booleanValue()) {
            this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.format(new Date()));
        }
        this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getPackageRootDirectory(), "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", this.getPackageRootDirectory(), "package.json"));
        this.supportingFiles.add(new SupportingFile("typings.mustache", this.getPackageRootDirectory(), "typings.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", this.getPackageRootDirectory(), "tsconfig.json"));
    }

    private String getPackageRootDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, ModelImpl swaggerModel) {
        codegenModel.additionalPropertiesType = this.getSwaggerType(swaggerModel.getAdditionalProperties());
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public String getName() {
        return "typescript-jquery";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript jquery client library.";
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }
}

