/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.dot;

import io.takari.graph.dot.CommonNode;
import io.takari.graph.dot.DotUtils;
import io.takari.graph.dot.Graph;
import io.takari.graph.dot.Rectangle;
import io.takari.graph.dot.SubGraph;
import java.util.Vector;

public class BasicNode
extends CommonNode {
    static final int USER = 0;
    static final int NONE = 1;
    static final int ELLIPSE = 2;
    static final int POLYGON = 3;
    static final int POINT = 4;
    static final int EGG = 5;
    static final int TRAPEZIUM = 6;
    static final int HOUSE = 7;
    static final int INVTRIANGLE = 8;
    static final int INVTRAPEZIUM = 9;
    static final int INVHOUSE = 10;
    static final String[] attributeNames = new String[]{"user", "none", "ellipse", "polygon", "point", "egg", "trapezium", "house", "invtriangle", "invtrapezium", "invhouse"};
    int shape = 2;
    String shapefile = "";
    int sides = 4;
    double distortion = 0.0;
    double skew = 0.0;
    boolean regular = false;
    Rectangle rects;

    public BasicNode(Object root, String id) throws Exception {
        super(root, id);
        this.label = id;
        this.getGenericAttributes();
    }

    private void getAttributes(BasicNode node) {
        if (this.distortion != node.distortion) {
            this.distortion = node.distortion;
        }
        if (this.rects != null && node.rects != null && !this.rects.equals(node.rects)) {
            this.rects = node.rects;
        }
        if (this.regular != node.regular) {
            this.regular = node.regular;
        }
        if (this.shape != node.shape) {
            this.shape = node.shape;
        }
        if (this.sides != node.sides) {
            this.sides = node.sides;
        }
        if (this.skew != node.skew) {
            this.skew = node.skew;
        }
        if (this.fixedsize != node.fixedsize) {
            this.fixedsize = node.fixedsize;
        }
        if (!this.group.equals(node.group)) {
            this.group = node.group;
        }
        if (this.height != node.height) {
            this.height = node.height;
        }
        if (this.layer != null && node.layer != null && !this.layer.equals(node.layer)) {
            this.layer = node.layer;
        }
        if (!this.margin.equals(node.margin)) {
            this.margin = node.margin;
        }
        if (this.pin != node.pin) {
            this.pin = node.pin;
        }
        if (this.pos != null && node.pos != null && !this.pos.equals(node.pos)) {
            this.pos = node.pos;
        }
        if (this.rotate != node.rotate) {
            this.rotate = node.rotate;
        }
        if (this.showboxes != node.showboxes) {
            this.showboxes = node.showboxes;
        }
        if (!this.tooltip.equals(node.tooltip)) {
            this.tooltip = node.tooltip;
        }
        if (this.vertices != null && node.vertices != null && !this.vertices.equals(node.vertices)) {
            this.vertices = node.vertices;
        }
        if (this.width != node.width) {
            this.width = node.width;
        }
        if (this.z != node.z) {
            this.z = node.z;
        }
        if (this.color == null) {
            this.color = node.color;
        } else if (!this.color.equals(node.color)) {
            this.color = node.color;
        }
        if (this.fillcolor == null) {
            this.fillcolor = node.fillcolor;
        } else if (!this.fillcolor.equals(node.fillcolor)) {
            this.fillcolor = node.fillcolor;
        }
        if (this.fontcolor == null) {
            this.fontcolor = node.fontcolor;
        } else if (!this.fontcolor.equals(node.fontcolor)) {
            this.fontcolor = node.fontcolor;
        }
        if (!this.fontname.equals(node.fontname)) {
            this.fontname = node.fontname;
        }
        if (this.fontsize != node.fontsize) {
            this.fontsize = node.fontsize;
        }
        if (!this.label.equals(node.label) && !node.label.equals("node")) {
            this.label = node.label;
        }
        if (this.nojustify != node.nojustify) {
            this.nojustify = node.nojustify;
        }
        if (this.peripheries != node.peripheries) {
            this.peripheries = node.peripheries;
        }
        if (!this.style.equals(node.style)) {
            this.style = node.style;
        }
        if (this.target != null && node.target != null && !this.target.equals(node.target)) {
            this.target = node.target;
        }
        if (this.URL != null && node.URL != null && !this.URL.equals(node.URL)) {
            this.URL = node.URL;
        }
    }

    private void getGenericAttributes() {
        Object rootGraph = this.root;
        Vector<Object> roots = new Vector<Object>();
        while (rootGraph instanceof SubGraph) {
            roots.add(rootGraph);
            rootGraph = ((SubGraph)rootGraph).root;
        }
        if (((Graph)rootGraph).genericNode != null) {
            this.getAttributes(((Graph)rootGraph).genericNode);
        }
        for (int i = roots.size() - 1; i == 0; --i) {
            BasicNode generic = ((SubGraph)roots.get((int)i)).genericNode;
            if (generic == null) continue;
            this.getAttributes(generic);
        }
    }

    @Override
    protected void changeOption(String name, String value) {
        try {
            super.changeOption(name, value);
        }
        catch (Exception e) {
            String v = value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? value.substring(1, value.length() - 1) : value;
            v = v.replaceAll("\\\\\\n", "");
            if (name.equals("distortion")) {
                this.distortion = DotUtils.readDouble(v);
            }
            if (name.equals("rect")) {
                this.rects = DotUtils.readRectangle(v);
            }
            if (name.equals("regular")) {
                this.regular = DotUtils.readBoolean(v);
            }
            if (name.equals("shape")) {
                if (v.endsWith("record")) {
                    ((Graph)this.root).record = true;
                }
                DotUtils.readShape(this, v);
            }
            if (name.equals("shapefile")) {
                this.shapefile = v;
            }
            if (name.equals("sides")) {
                this.sides = DotUtils.readInteger(v);
            }
            if (name.equals("skew")) {
                this.skew = DotUtils.readDouble(v);
            }
            System.err.println("BasicNode attribute \"" + name + "\" does not exist");
        }
    }

    @Override
    protected String nodeOptions() {
        String o = super.nodeOptions();
        if (!this.shapefile.equals("")) {
            o = o + this.printOption("shapefile", this.shapefile);
        }
        if (this.sides != 4) {
            o = o + this.printOption("sides", this.sides);
        }
        if (this.distortion != 0.0) {
            o = o + this.printOption("distortion", this.distortion);
        }
        if (this.skew != 0.0) {
            o = o + this.printOption("skew", this.skew);
        }
        if (this.regular) {
            o = o + this.printOption("regular", this.regular);
        }
        if (this.shape != 2) {
            o = o + this.printNamedOption("shape", this.shape);
        }
        if (this.rects != null) {
            o = o + this.printOption("rects", this.rects);
        }
        return o;
    }

    private String printOption(String attribute, Rectangle value) {
        return attribute + "=\"" + value + "\" ";
    }

    private String printNamedOption(String attribute, int i) {
        return attribute + "=\"" + attributeNames[i] + "\" ";
    }
}

