/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.dot;

import io.takari.graph.dot.BasicNode;
import io.takari.graph.dot.Point;
import io.takari.graph.dot.Record;
import io.takari.graph.dot.Rectangle;
import io.takari.graph.dot.Spline;
import io.takari.graph.dot.Style;
import io.takari.graph.dot.SubRecord;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.StringTokenizer;
import java.util.Vector;

public class DotUtils {
    public static Rectangle readRectangle(String v) {
        if (v.equals("")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(v);
        int x1 = Integer.parseInt(st.nextToken(", "));
        int y1 = Integer.parseInt(st.nextToken(", "));
        int x2 = Integer.parseInt(st.nextToken(", "));
        int y2 = Integer.parseInt(st.nextToken(", "));
        return new Rectangle(x1, y1, x2, y2);
    }

    public static boolean readBoolean(String v) {
        return Boolean.valueOf(v);
    }

    public static Point2D.Double readPointf(String v) {
        StringTokenizer st = new StringTokenizer(v);
        double x = Double.parseDouble(st.nextToken(", "));
        double y = Double.parseDouble(st.nextToken(", "));
        return new Point2D.Double(x, y);
    }

    public static Point readPoint(String v) {
        String r;
        Point p;
        if (v.endsWith("!")) {
            p = new Point(false);
            r = v.substring(0, v.length() - 1);
        } else {
            p = new Point(true);
            r = v;
        }
        String[] str = r.split(",");
        p.coords = new long[str.length];
        for (int i = 0; i < p.coords.length; ++i) {
            try {
                p.coords[i] = Long.valueOf(str[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return p;
    }

    public static double readDouble(String v) {
        try {
            return Double.valueOf(v);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static int readInteger(String v) throws NumberFormatException {
        try {
            return Integer.valueOf(v);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Color readColor(String v) {
        if (v.equals("none") || v.equals("transparent")) {
            return null;
        }
        try {
            return (Color)Class.forName("net.claribole.zgrviewer.dot.Colors").getDeclaredField(v.toLowerCase().replaceAll("[ _]", "")).get(null);
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (v.charAt(0) == '#') {
            int a;
            int b;
            int g;
            int r;
            String value = v.substring(1);
            if (value.length() == 6) {
                r = Integer.parseInt(value.substring(0, 2), 16);
                g = Integer.parseInt(value.substring(2, 4), 16);
                b = Integer.parseInt(value.substring(4, 6), 16);
                a = 255;
            } else if (value.length() == 8) {
                r = Integer.parseInt(value.substring(0, 2), 16);
                g = Integer.parseInt(value.substring(2, 4), 16);
                b = Integer.parseInt(value.substring(4, 6), 16);
                a = Integer.parseInt(value.substring(6, 8), 16);
            } else {
                System.err.println("Color " + v + " unknown");
                return null;
            }
            return new Color(r, g, b, a);
        }
        try {
            StringTokenizer st = new StringTokenizer(v);
            float h = Float.parseFloat(st.nextToken(" "));
            float s = Float.parseFloat(st.nextToken(" "));
            float b = Float.parseFloat(st.nextToken(" "));
            return Color.getHSBColor(h, s, b);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Spline readSpline(String v) {
        String[] points = v.split(" ");
        Spline spline = new Spline();
        for (int i = 0; i < points.length; ++i) {
            if (points[i].trim().equals("")) continue;
            DotUtils.readSplinePoint(points[i], spline);
        }
        return spline;
    }

    public static void readSplinePoint(String v, Spline s) {
        char c = v.charAt(0);
        if (c == 'e') {
            s.endingPoint = DotUtils.readPoint(v.substring(2));
        } else if (c == 's') {
            s.startingPoint = DotUtils.readPoint(v.substring(2));
        } else {
            s.addControls(DotUtils.readPoint(v));
        }
    }

    public static void readStyle(Style s, String v) {
        String[] styles = v.split(" ");
        for (int i = 0; i < styles.length; ++i) {
            int value;
            boolean found = false;
            for (value = 0; value < Style.styleAttributeName.length && !(found = styles[i].equalsIgnoreCase(Style.styleAttributeName[value])); ++value) {
            }
            if (found) {
                s.setStyle(value, true);
                continue;
            }
            System.err.println("Style " + styles[i] + " unknown");
        }
    }

    public static Point2D.Double[] readPointfList(String v) {
        String[] str = v.split(" ");
        Point2D.Double[] values = new Point2D.Double[str.length];
        for (int i = 0; i < str.length; ++i) {
            values[i] = DotUtils.readPointf(str[i]);
        }
        return values;
    }

    public static Rectangle[] readRectangleList(String v) {
        String[] str = v.split(" ");
        Rectangle[] values = new Rectangle[str.length];
        for (int i = 0; i < str.length; ++i) {
            values[i] = DotUtils.readRectangle(str[i]);
        }
        return values;
    }

    public static Color[] readColors(String v) {
        String[] clrs = v.split(":");
        Color[] colors = new Color[clrs.length];
        for (int i = 0; i < clrs.length; ++i) {
            colors[i] = DotUtils.readColor(clrs[i]);
        }
        return colors;
    }

    public static void expandRects(Record r) {
        if (r.rects != null && r.subRecords != null) {
            int i;
            Vector rects = new Vector(r.rects.length);
            for (i = 0; i < r.rects.length; ++i) {
                rects.add(r.rects[i]);
            }
            for (i = 0; i < r.subRecords.length; ++i) {
                rects = DotUtils.expandRects(r.subRecords[i], rects);
            }
        }
    }

    private static Vector expandRects(SubRecord sub, Vector rects) {
        if (sub.label != null && !sub.label.equals("")) {
            sub.rect = (Rectangle)rects.remove(0);
        }
        if (sub.subRecords != null) {
            for (int i = 0; i < sub.subRecords.length; ++i) {
                rects = DotUtils.expandRects(sub.subRecords[i], rects);
            }
        }
        return rects;
    }

    public static void readShape(BasicNode basicNode, String v) {
        int value;
        if (v.charAt(0) == 'M') {
            basicNode.style.setStyle(6, true);
            v = v.substring(1);
        }
        boolean found = false;
        for (value = 0; value < BasicNode.attributeNames.length && !(found = v.equals(BasicNode.attributeNames[value])); ++value) {
        }
        if (found) {
            basicNode.shape = value;
            if (value == 4) {
                basicNode.color = Color.black;
            }
        } else if (v.equals("box") || v.equals("rect") || v.equals("rectangle") || v.equals("square")) {
            basicNode.shape = 3;
            basicNode.sides = 4;
        } else if (v.endsWith("circle")) {
            basicNode.shape = 2;
            basicNode.regular = true;
            basicNode.peripheries = v.equals("doublecircle") ? 2 : 1;
        } else if (v.equals("triangle")) {
            basicNode.shape = 3;
            basicNode.sides = 3;
        } else if (v.equals("invtriangle")) {
            basicNode.shape = 8;
        } else if (v.equals("plaintext") || v.equals("none")) {
            basicNode.shape = 1;
        } else if (v.equals("diamond")) {
            basicNode.shape = 3;
            basicNode.sides = 4;
            basicNode.regular = true;
            basicNode.rotate = 45.0;
        } else if (v.equals("trapezium")) {
            basicNode.shape = 6;
        } else if (v.equals("invtrapezium")) {
            basicNode.shape = 9;
        } else if (v.equals("parallelogram")) {
            basicNode.shape = 3;
            basicNode.sides = 4;
            basicNode.skew = 0.6;
        } else if (v.equals("house")) {
            basicNode.shape = 7;
        } else if (v.equals("invhouse")) {
            basicNode.shape = 10;
        } else if (v.endsWith("octagon")) {
            basicNode.shape = 3;
            basicNode.sides = 8;
            basicNode.peripheries = v.equals("doubleoctagon") ? 2 : (v.equals("tripleoctagon") ? 3 : 1);
        } else if (v.endsWith("agon")) {
            basicNode.shape = 3;
            if (v.startsWith("pent")) {
                basicNode.sides = 5;
            }
            if (v.startsWith("hex")) {
                basicNode.sides = 6;
            }
            if (v.startsWith("sept")) {
                basicNode.sides = 7;
            }
        } else {
            System.err.println(v + " is not a BasicNode shape");
        }
    }

    public static void readShape(Record record, String v) {
        if (v.endsWith("record")) {
            record.setRounded(v.charAt(0) == 'M');
        }
    }

    public static int readOrientation(String v) {
        v = v.toLowerCase();
        for (int i = 0; i < v.length(); ++i) {
            if (v.charAt(i) != 'l') continue;
            return 90;
        }
        return 0;
    }
}

