/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.internal;

import io.takari.incrementalbuild.MessageSeverity;
import io.takari.incrementalbuild.maven.internal.Nullable;
import io.takari.incrementalbuild.spi.AbstractBuildContext;
import io.takari.incrementalbuild.spi.BuildContextFinalizer;
import io.takari.incrementalbuild.spi.Message;
import io.takari.incrementalbuild.spi.MessageSinkAdaptor;
import io.takari.incrementalbuild.workspace.MessageSink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.execution.scope.WeakMojoExecutionListener;
import org.apache.maven.plugin.MojoExecutionException;

@Named
@MojoExecutionScoped
public class MavenBuildContextFinalizer
implements WeakMojoExecutionListener,
BuildContextFinalizer {
    @Inject
    @Nullable
    private MessageSink messageSink;
    private final List<AbstractBuildContext> contexts = new ArrayList<AbstractBuildContext>();

    @Inject
    public MavenBuildContextFinalizer() {
    }

    @Override
    public void registerContext(AbstractBuildContext context) {
        this.contexts.add(context);
    }

    protected List<AbstractBuildContext> getRegisteredContexts() {
        return this.contexts;
    }

    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
        final HashMap<Object, Collection<Message>> messages = new HashMap<Object, Collection<Message>>();
        MessageSinkAdaptor messager = new MessageSinkAdaptor(){

            @Override
            public void record(Map<Object, Collection<Message>> allMessages, Map<Object, Collection<Message>> newMessages) {
                if (MavenBuildContextFinalizer.this.messageSink != null) {
                    for (Map.Entry<Object, Collection<Message>> entry : newMessages.entrySet()) {
                        Object resource = entry.getKey();
                        for (Message message : entry.getValue()) {
                            MavenBuildContextFinalizer.this.messageSink.message(resource, message.line, message.column, message.message, MavenBuildContextFinalizer.toMessageSinkSeverity(message.severity), message.cause);
                        }
                    }
                }
                messages.putAll(allMessages);
            }

            @Override
            public void clear(Object resource) {
                if (MavenBuildContextFinalizer.this.messageSink != null) {
                    MavenBuildContextFinalizer.this.messageSink.clearMessages(resource);
                }
            }
        };
        try {
            for (AbstractBuildContext context : this.contexts) {
                context.commit(messager);
            }
            if (this.messageSink == null) {
                this.failBuild(messages);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not maintain incremental build state", (Exception)e);
        }
    }

    protected void failBuild(Map<Object, Collection<Message>> messages) throws MojoExecutionException {
        int errorCount = 0;
        StringBuilder errors = new StringBuilder();
        for (Map.Entry<Object, Collection<Message>> entry : messages.entrySet()) {
            Object resource = entry.getKey();
            for (Message message : entry.getValue()) {
                if (message.severity != MessageSeverity.ERROR) continue;
                ++errorCount;
                errors.append(String.format("%s:[%d:%d] %s\n", resource.toString(), message.line, message.column, message.message));
            }
        }
        if (errorCount > 0) {
            throw new MojoExecutionException(String.valueOf(errorCount) + " error(s) encountered:\n" + errors.toString());
        }
    }

    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
    }

    public void afterExecutionFailure(MojoExecutionEvent event) {
    }

    protected static MessageSink.Severity toMessageSinkSeverity(MessageSeverity severity) {
        switch (severity) {
            case ERROR: {
                return MessageSink.Severity.ERROR;
            }
            case WARNING: {
                return MessageSink.Severity.WARNING;
            }
            case INFO: {
                return MessageSink.Severity.INFO;
            }
        }
        throw new IllegalArgumentException();
    }
}

