/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.internal.digest;

import io.takari.incrementalbuild.Incremental;
import io.takari.incrementalbuild.maven.internal.digest.BytesHash;
import io.takari.incrementalbuild.maven.internal.digest.SHA1Digester;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;

class Digesters {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Map<Class<?>, Digester<?>> DIGESTERS;
    private static final Digester<Serializable> DIGESTER_ECHO;
    private static final Digester<MavenProject> DIGESTER_MAVENPROJECT;
    private static final Digester<MavenSession> DIGESTER_MAVENSESSION;
    private static final Digester<Collection<?>> DIGESTER_COLLECTION;
    private static Digester<Artifact> DIGESTER_ARTIFACT;
    private static Digester<ArtifactRepository> DIGESTER_ARTIFACTREPOSITORY;

    static {
        DIGESTER_ECHO = new Digester<Serializable>(){

            @Override
            public Serializable digest(Member member, Serializable value) {
                return value;
            }
        };
        DIGESTER_MAVENPROJECT = new Digester<MavenProject>(){

            @Override
            public Serializable digest(Member member, MavenProject value) {
                if (Digesters.getConfiguration(member) == null) {
                    throw new IllegalArgumentException("Explicit @Incremental required: " + member);
                }
                final MessageDigest digester = SHA1Digester.newInstance();
                try {
                    new MavenXpp3Writer().write(new OutputStream(){

                        @Override
                        public void write(int b) throws IOException {
                            digester.update((byte)b);
                        }
                    }, value.getModel());
                }
                catch (IOException iOException) {}
                return new BytesHash(digester.digest());
            }
        };
        DIGESTER_MAVENSESSION = new Digester<MavenSession>(){

            @Override
            public Serializable digest(Member member, MavenSession session) {
                if (Digesters.getConfiguration(member) == null) {
                    throw new IllegalArgumentException("Explicit @Incremental required: " + member);
                }
                TreeMap<String, String> executionProperties = new TreeMap<String, String>();
                for (Map.Entry<Object, Object> property : session.getExecutionProperties().entrySet()) {
                    Object key = property.getKey();
                    Object value = property.getValue();
                    if (!(key instanceof String) || !(value instanceof String)) continue;
                    executionProperties.put(key.toString(), value.toString());
                }
                executionProperties.remove("classworlds.conf");
                Iterator iter = executionProperties.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry property = iter.next();
                    if (!((String)property.getKey()).startsWith("env.")) continue;
                    iter.remove();
                }
                MessageDigest digester = SHA1Digester.newInstance();
                for (Map.Entry property : executionProperties.entrySet()) {
                    digester.update(((String)property.getKey()).getBytes(UTF_8));
                    digester.update(((String)property.getValue()).getBytes(UTF_8));
                }
                return new BytesHash(digester.digest());
            }
        };
        DIGESTER_COLLECTION = new Digester<Collection<?>>(){

            @Override
            public Serializable digest(Member member, Collection<?> collection) {
                ArrayList<Serializable> digest = new ArrayList<Serializable>();
                for (Object element : collection) {
                    Serializable elementDigest = Digesters.rawtypesDigest(member, element);
                    if (elementDigest == null) continue;
                    digest.add(elementDigest);
                }
                return digest;
            }
        };
        DIGESTER_ARTIFACT = new Digester<Artifact>(){

            @Override
            public Serializable digest(Member member, Artifact value) {
                return value.getFile();
            }
        };
        DIGESTER_ARTIFACTREPOSITORY = new Digester<ArtifactRepository>(){

            @Override
            public Serializable digest(Member member, ArtifactRepository value) {
                return value.getUrl();
            }
        };
        LinkedHashMap<Class, Digester<Object>> digesters = new LinkedHashMap<Class, Digester<Object>>();
        digesters.put(ArtifactRepository.class, DIGESTER_ARTIFACTREPOSITORY);
        digesters.put(Artifact.class, DIGESTER_ARTIFACT);
        digesters.put(MavenProject.class, DIGESTER_MAVENPROJECT);
        digesters.put(MavenSession.class, DIGESTER_MAVENSESSION);
        digesters.put(Collection.class, DIGESTER_COLLECTION);
        digesters.put(Serializable.class, DIGESTER_ECHO);
        DIGESTERS = Collections.unmodifiableMap(digesters);
    }

    Digesters() {
    }

    public static Serializable digest(Member member, Object value) {
        Incremental configuration = Digesters.getConfiguration(member);
        if (configuration != null && configuration.configuration() == Incremental.Configuration.ignore) {
            return null;
        }
        return Digesters.rawtypesDigest(member, value);
    }

    static Incremental getConfiguration(Member member) {
        if (member instanceof AnnotatedElement) {
            return ((AnnotatedElement)((Object)member)).getAnnotation(Incremental.class);
        }
        return null;
    }

    private static Serializable rawtypesDigest(Member member, Object value) {
        return Digesters.getDigester(value).digest(member, value);
    }

    private static Digester<?> getDigester(Object value) {
        Digester<?> digester = null;
        for (Map.Entry<Class<?>, Digester<?>> entry : DIGESTERS.entrySet()) {
            if (!entry.getKey().isInstance(value)) continue;
            digester = entry.getValue();
            break;
        }
        if (digester == null) {
            throw new UnsupportedParameterTypeException(value.getClass());
        }
        return digester;
    }

    static interface Digester<T> {
        public Serializable digest(Member var1, T var2);
    }

    public static class UnsupportedParameterTypeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        final Class<?> type;

        public UnsupportedParameterTypeException(Class<?> type) {
            this.type = type;
        }
    }
}

