/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.internal.digest;

import io.takari.incrementalbuild.maven.internal.digest.ClasspathDigester;
import io.takari.incrementalbuild.maven.internal.digest.Digesters;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Named
@MojoExecutionScoped
public class MojoConfigurationDigester {
    private final ClasspathDigester classpathDigester;
    private final MavenSession session;
    private final MavenProject project;
    private final MojoExecution execution;

    @Inject
    public MojoConfigurationDigester(MavenSession session, MavenProject project, MojoExecution execution) {
        this.session = session;
        this.project = project;
        this.execution = execution;
        this.classpathDigester = new ClasspathDigester(session);
    }

    public Map<String, Serializable> digest() throws IOException {
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        List classpath = this.execution.getMojoDescriptor().getPluginDescriptor().getArtifacts();
        result.put("mojo.classpath", this.classpathDigester.digest(classpath));
        Xpp3Dom dom = this.execution.getConfiguration();
        if (dom != null) {
            ArrayList<String> errors = new ArrayList<String>();
            XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(dom);
            PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(this.session, this.execution);
            PlexusConfiguration[] plexusConfigurationArray = configuration.getChildren();
            int n = plexusConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlexusConfiguration child = plexusConfigurationArray[n2];
                String name = this.fromXML(child.getName());
                try {
                    Field field = this.getField(this.execution.getMojoDescriptor().getImplementationClass(), name);
                    if (field != null) {
                        Serializable digest;
                        Object value;
                        String expression = child.getValue();
                        if (expression == null) {
                            expression = this.getChildrenXml(child);
                        }
                        if (expression == null) {
                            expression = child.getAttribute("default-value");
                        }
                        if (expression != null && (value = evaluator.evaluate(expression)) != null && (digest = Digesters.digest(field, value)) != null) {
                            result.put("mojo.parameter." + name, digest);
                        }
                    }
                }
                catch (Digesters.UnsupportedParameterTypeException e) {
                    errors.add("parameter " + name + " has unsupported type " + e.type.getName());
                }
                catch (ExpressionEvaluationException e) {
                    errors.add("parameter " + name + " " + e.getMessage());
                }
                ++n2;
            }
            if (!errors.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.project.toString());
                sb.append(" could not digest configuration of ").append(this.execution.toString());
                for (String error : errors) {
                    sb.append("\n   ").append(error);
                }
                throw new IllegalArgumentException(sb.toString());
            }
        }
        return result;
    }

    private String getChildrenXml(PlexusConfiguration node) {
        PlexusConfiguration[] children = node.getChildren();
        if (children == null || children.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        PlexusConfiguration[] plexusConfigurationArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            PlexusConfiguration child = plexusConfigurationArray[n2];
            this.append(sb, child);
            ++n2;
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, PlexusConfiguration node) {
        sb.append('<').append(node.getName());
        String[] stringArray = node.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            sb.append(' ').append(a).append("=\"").append(node.getAttribute(a)).append('\"');
            ++n2;
        }
        if (node.getChildCount() > 0) {
            sb.append('>');
            int i = 0;
            int size = node.getChildCount();
            while (i < size) {
                this.append(sb, node.getChild(i));
                ++i;
            }
            sb.append("</").append(node.getName()).append('>');
        } else if (node.getValue() != null) {
            sb.append('>').append(node.getValue()).append("</").append(node.getName()).append('>');
        } else {
            sb.append("/>");
        }
    }

    private Field getField(Class<?> clazz, String name) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (name.equals(field.getName())) {
                return field;
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            return this.getField(clazz.getSuperclass(), name);
        }
        return null;
    }

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter((String)StringUtils.removeAndHump((String)elementName, (String)"-"));
    }
}

