/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import io.takari.jpgp.PgpKeyLocator;
import io.takari.jpgp.PgpSigningRequest;
import io.takari.jpgp.passphrase.PgpPassphraseFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpSigner {
    private static final Logger logger = LoggerFactory.getLogger(PgpSigner.class);
    private final PGPSecretKey secretKey;
    private final PgpKeyLocator locator;
    private final PgpPassphraseFinder passphraseFinder;
    private final PgpSigningRequest request;
    private final Path gpgHomedir;

    public PgpSigner(PgpSigningRequest request) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            this.request = request;
            this.locator = new PgpKeyLocator(request);
            this.gpgHomedir = this.locator.gpgHomedir();
            this.secretKey = request.privateKeyFromPath() != null ? PgpSigner.loadKeyFromArmoredPath(request.privateKeyFromPath()) : this.locator.findPgpSecretKey();
            this.passphraseFinder = new PgpPassphraseFinder();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public File sign(File fileToSign) throws IOException, PGPException {
        return this.sign(fileToSign, this.request.privateKeyPassphrase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File sign(File fileToSign, String passphrase) throws IOException, PGPException {
        if (passphrase == null) {
            passphrase = this.findPassphrase();
        }
        File signatureFile = new File(fileToSign.getParentFile(), String.valueOf(fileToSign.getName()) + ".asc");
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileInputStream inputStream = new FileInputStream(fileToSign);
            try {
                try (FileOutputStream outputStream = new FileOutputStream(signatureFile);){
                    this.signMessage(passphrase, inputStream, outputStream);
                }
                if (inputStream == null) return signatureFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            ((InputStream)inputStream).close();
            return signatureFile;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private String findPassphrase() {
        return this.passphraseFinder.find(this.gpgHomedir, this.secretKey.getKeyID());
    }

    private static PGPSecretKey loadKeyFromArmoredPath(Path keyFile) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = Files.newInputStream(keyFile, new OpenOption[0]);){
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)inputStream), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Object pgpObject = pgpObjectFactory.nextObject();
            if (!(pgpObject instanceof PGPSecretKeyRing)) {
                throw new IOException(keyFile + " doesn't contain PGP private key!");
            }
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)pgpObject;
            return keyRing.getSecretKey();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean signMessage(String passwordOfPrivateKey, InputStream message, OutputStream signature) throws PGPException, IOException {
        PGPPrivateKey privateKey = this.findPrivateKey(this.secretKey, passwordOfPrivateKey);
        return this.signatureGenerator(message, signature, privateKey);
    }

    private boolean signatureGenerator(InputStream message, OutputStream signature, PGPPrivateKey privateKey) throws PGPException, IOException {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), 8));
        signatureGenerator.init(0, privateKey);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)new ArmoredOutputStream(signature));){
            PgpSigner.process(message, (arg_0, arg_1, arg_2) -> ((PGPSignatureGenerator)signatureGenerator).update(arg_0, arg_1, arg_2));
            signatureGenerator.generate().encode((OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    public boolean verify(Path armoredPublicKey, Path artifact, Path signature) {
        try {
            return this.verifyMessage(Files.newInputStream(armoredPublicKey, new OpenOption[0]), Files.newInputStream(artifact, new OpenOption[0]), Files.newInputStream(signature, new OpenOption[0]));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean verifyMessage(InputStream publicKeyOfSender, InputStream message, InputStream signatureStream) {
        boolean result = false;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ArmoredInputStream armordPublicKeyStream = new ArmoredInputStream(signatureStream);){
                Object pgpObject;
                PGPObjectFactory pgpObjectFactory = new PGPObjectFactory((InputStream)armordPublicKeyStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                while ((pgpObject = pgpObjectFactory.nextObject()) != null) {
                    if (!(pgpObject instanceof PGPSignatureList)) continue;
                    PGPSignatureList signatureList = (PGPSignatureList)pgpObject;
                    for (PGPSignature signature : signatureList) {
                        PGPPublicKey pgpPublicKey = this.findPublicKey(publicKeyOfSender, pgpKey -> pgpKey.getKeyID() == signature.getKeyID());
                        if (pgpPublicKey == null) continue;
                        signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), pgpPublicKey);
                        PgpSigner.process(message, (arg_0, arg_1, arg_2) -> ((PGPSignature)signature).update(arg_0, arg_1, arg_2));
                        result = signature.verify();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException throwable) {
            result = false;
        }
        return result;
    }

    private PGPPrivateKey findPrivateKey(PGPSecretKey pgpSecretKey, String password) throws PGPException {
        PBESecretKeyDecryptor pbeSecretKeyDecryptor = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().build()).build(password.toCharArray());
        return pgpSecretKey.extractPrivateKey(pbeSecretKeyDecryptor);
    }

    private PGPPublicKey findPublicKey(InputStream publicKey, KeyFilter<PGPPublicKey> keyFilter) {
        return this.retrievePublicKey(this.readPublicKeyRing(publicKey), keyFilter);
    }

    private PGPPublicKey retrievePublicKey(PGPPublicKeyRing publicKeyRing, KeyFilter<PGPPublicKey> keyFilter) {
        PGPPublicKey result = null;
        Iterator publicKeyIterator = publicKeyRing.getPublicKeys();
        while (result == null && publicKeyIterator.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)publicKeyIterator.next();
            if (!keyFilter.accept(key)) continue;
            result = key;
        }
        return result;
    }

    private PGPPublicKeyRing readPublicKeyRing(InputStream publicKey) {
        PGPPublicKeyRing result = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)publicKey);){
                Object o;
                PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(decoderStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                while ((o = pgpObjectFactory.nextObject()) != null && result == null) {
                    if (!(o instanceof PGPPublicKeyRing)) continue;
                    result = (PGPPublicKeyRing)o;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public static void process(InputStream inputStream, StreamHandler handler) throws IOException {
        PgpSigner.process(inputStream, handler, new byte[4096]);
    }

    public static void process(InputStream inputStream, StreamHandler handler, byte[] buffer) throws IOException {
        int read;
        while ((read = inputStream.read(buffer)) != -1) {
            handler.handleStreamBuffer(buffer, 0, read);
        }
    }

    public static interface KeyFilter<T> {
        public boolean accept(T var1);
    }

    public static interface StreamHandler {
        public void handleStreamBuffer(byte[] var1, int var2, int var3) throws IOException;
    }
}

