/*
 * Decompiled with CFR 0.152.
 */
package io.takari.resources.filtering;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.Resource;
import io.takari.resources.filtering.CopyResourcesProcessor;
import io.takari.resources.filtering.FilterResourcesProcessor;
import io.takari.resources.filtering.MissingPropertyAction;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ResourcesProcessor {
    private final CopyResourcesProcessor copyProcessor;
    private final FilterResourcesProcessor filterProcessor;

    @Inject
    public ResourcesProcessor(BuildContext buildContext) {
        this.copyProcessor = new CopyResourcesProcessor(buildContext);
        this.filterProcessor = new FilterResourcesProcessor(buildContext);
    }

    public void process(File sourceDirectory, File targetDirectory, List<String> includes, List<String> excludes, String encoding) throws IOException {
        this.copyProcessor.process(sourceDirectory, targetDirectory, includes, excludes, encoding);
    }

    public void process(File sourceDirectory, File targetDirectory, List<String> includes, List<String> excludes, Map<Object, Object> filterProperties, String encoding, MissingPropertyAction mpa) throws IOException {
        this.filterProcessor.process(sourceDirectory, targetDirectory, includes, excludes, filterProperties, Collections.emptyList(), encoding, mpa);
    }

    public void process(File sourceDirectory, File targetDirectory, List<String> includes, List<String> excludes, Map<Object, Object> filterProperties, List<File> filters, String encoding, MissingPropertyAction mpa) throws IOException {
        this.filterProcessor.process(sourceDirectory, targetDirectory, includes, excludes, filterProperties, filters, encoding, mpa);
    }

    public void filter(Resource resource, Reader reader, Writer writer, Map<Object, Object> properties, MissingPropertyAction mpa) throws IOException {
        this.filterProcessor.filter(resource, reader, writer, properties, mpa);
    }
}

