/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.PathNormalizer;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;

@Named
public class ClasspathEntryCache {
    private static final Map<Path, CacheEntry> CACHE = new HashMap<Path, CacheEntry>();
    private static final Map<Path, CacheEntry> SOURCEPATH_CACHE = new HashMap<Path, CacheEntry>();

    public DependencyClasspathEntry get(Path location, CacheMode cacheMode, Factory factory) {
        return ClasspathEntryCache.get(CACHE, location, cacheMode, factory);
    }

    public DependencyClasspathEntry getSourcepathEntry(Path location, CacheMode cacheMode, Factory factory) {
        return ClasspathEntryCache.get(SOURCEPATH_CACHE, location, cacheMode, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DependencyClasspathEntry get(Map<Path, CacheEntry> cache, Path location, CacheMode cacheMode, Factory factory) {
        location = PathNormalizer.getCanonicalPath(location);
        Map<Path, CacheEntry> map = cache;
        synchronized (map) {
            CacheEntry entry = cache.get(location);
            CacheEntry newEntry = ClasspathEntryCache.revalidate(location, entry, cacheMode, factory);
            if (entry != newEntry) {
                entry = newEntry;
                cache.put(location, entry);
            }
            return entry.getCpe();
        }
    }

    private static CacheEntry revalidate(Path location, CacheEntry entry, CacheMode cacheMode, Factory factory) {
        long length = -1L;
        long lastModified = -1L;
        if (cacheMode == CacheMode.PESSIMISTIC) {
            try {
                File file = location.toFile();
                if (file.isDirectory()) {
                    length = 0L;
                    lastModified = System.currentTimeMillis();
                } else {
                    length = file.length();
                    lastModified = file.lastModified();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        if (entry == null || entry.getSize() != length || entry.getTimestamp() != lastModified) {
            entry = new CacheEntry(factory.newClasspathEntry(location), lastModified, length);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        Map<Path, CacheEntry> map = CACHE;
        synchronized (map) {
            CACHE.clear();
        }
        map = SOURCEPATH_CACHE;
        synchronized (map) {
            SOURCEPATH_CACHE.clear();
        }
    }

    public static class CacheEntry {
        private final DependencyClasspathEntry cpe;
        private final long timestamp;
        private final long size;

        public CacheEntry(DependencyClasspathEntry cpe, long timestamp, long size) {
            this.cpe = cpe;
            this.timestamp = timestamp;
            this.size = size;
        }

        public DependencyClasspathEntry getCpe() {
            return this.cpe;
        }

        public long getSize() {
            return this.size;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static enum CacheMode {
        DEFAULT,
        PESSIMISTIC;

    }

    public static interface Factory {
        public DependencyClasspathEntry newClasspathEntry(Path var1);
    }
}

