/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin;

import io.takari.incrementalbuild.Incremental;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.aggregator.AggregatorBuildContext;
import io.takari.incrementalbuild.aggregator.InputAggregator;
import io.takari.incrementalbuild.aggregator.InputSet;
import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.plugin.LegacyPluginDescriptors;
import io.takari.maven.plugins.plugin.PluginDescriptorWriter;
import io.takari.maven.plugins.plugin.model.MojoDescriptor;
import io.takari.maven.plugins.plugin.model.MojoParameter;
import io.takari.maven.plugins.plugin.model.MojoRequirement;
import io.takari.maven.plugins.plugin.model.PluginDescriptor;
import io.takari.maven.plugins.plugin.model.io.xpp3.PluginDescriptorXpp3Reader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="plugin-descriptor", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PluginDescriptorMojo
extends TakariLifecycleMojo {
    static final String PATH_MOJOS_XML = "META-INF/takari/mojos.xml";
    private static final String PATH_PLUGIN_XML = "META-INF/maven/plugin.xml";
    private static final String PATH_METADATA_XML = "META-INF/m2e/lifecycle-mapping-metadata.xml";
    @Parameter(defaultValue="${project.groupId}", readonly=true)
    private String groupId;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    private String artifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String version;
    @Parameter(defaultValue="${project.name}", readonly=true)
    private String name;
    @Parameter(defaultValue="${project.description}", readonly=true)
    private String description;
    @Parameter
    private String goalPrefix;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.compileArtifacts}", readonly=true)
    private List<Artifact> dependencies;
    @Parameter(defaultValue="${project.basedir}/src/main/m2e/lifecycle-mapping-metadata.xml")
    private File eclipseMetadataFile;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.build.resources}", readonly=true)
    private List<Resource> resources;
    @Component
    private AggregatorBuildContext context;

    @Override
    protected void executeMojo() throws MojoExecutionException {
        try {
            final File mojosXml = new File(this.outputDirectory, PATH_MOJOS_XML);
            if (!mojosXml.isFile()) {
                return;
            }
            InputSet inputSet = this.context.newInputSet();
            final LinkedHashSet<File> classpathJars = new LinkedHashSet<File>();
            final LinkedHashSet<File> classpathFiles = new LinkedHashSet<File>();
            for (Artifact artifact : this.dependencies) {
                File file;
                if (artifact.getFile().isFile()) {
                    classpathJars.add(inputSet.addInput(artifact.getFile()));
                    continue;
                }
                if (!artifact.getFile().isDirectory() || !(file = new File(artifact.getFile(), PATH_MOJOS_XML)).canRead()) continue;
                classpathFiles.add(inputSet.addInput(file));
            }
            inputSet.addInput(new File(this.outputDirectory, PATH_MOJOS_XML));
            if (this.eclipseMetadataFile.isFile()) {
                inputSet.addInput(this.eclipseMetadataFile);
            }
            for (Resource resource : this.resources) {
                File otherEclipseMetadataFile = new File(resource.getDirectory(), PATH_METADATA_XML);
                if (!otherEclipseMetadataFile.isFile()) continue;
                throw new MojoExecutionException(String.format("Unexpected Eclipse m2e metadata found %s. Did you mean to move it to %s", otherEclipseMetadataFile, this.eclipseMetadataFile));
            }
            inputSet.aggregateIfNecessary(new File(this.outputDirectory, PATH_PLUGIN_XML), new InputAggregator(){

                public void aggregate(Output<File> output, Iterable<File> inputs) throws IOException {
                    PluginDescriptorMojo.this.createPluginXml(output, mojosXml, classpathFiles, classpathJars);
                }
            });
            inputSet.aggregateIfNecessary(new File(this.outputDirectory, PATH_METADATA_XML), new InputAggregator(){

                public void aggregate(Output<File> output, Iterable<File> inputs) throws IOException {
                    PluginDescriptorMojo.this.createEclipseMetadataXml(output, mojosXml, PluginDescriptorMojo.this.eclipseMetadataFile);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create plugin descriptor", (Exception)e);
        }
    }

    protected void createPluginXml(Output<File> output, File input, Set<File> classpathFiles, Set<File> classpathJars) throws IOException {
        Map<String, MojoDescriptor> classpathMojos = this.loadClasspathMojos(classpathFiles, classpathJars);
        Map<String, MojoDescriptor> mojos = this.loadMojos(input);
        PluginDescriptor plugin = this.newPluginDescriptor();
        for (MojoDescriptor gleaned : mojos.values()) {
            MojoDescriptor descriptor = gleaned.clone();
            if (descriptor.getGoal() == null) continue;
            for (String parent : descriptor.getSuperclasses()) {
                MojoDescriptor inherited = mojos.get(parent);
                if (inherited == null) {
                    inherited = classpathMojos.get(parent);
                }
                if (inherited == null) continue;
                for (MojoParameter parameter : inherited.getParameters()) {
                    if (this.containsField(descriptor, parameter.getName())) continue;
                    descriptor.addParameter(parameter.clone());
                }
                for (MojoRequirement requirement : inherited.getRequirements()) {
                    if (this.containsField(descriptor, requirement.getFieldName())) continue;
                    descriptor.addRequirement(requirement.clone());
                }
            }
            plugin.addMojo(descriptor);
        }
        Throwable throwable = null;
        Iterator<MojoDescriptor> iterator = null;
        try (OutputStream out = output.newOutputStream();){
            new PluginDescriptorWriter().writeDescriptor(out, plugin);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean containsField(MojoDescriptor descriptor, String fieldName) {
        for (MojoParameter parameter : descriptor.getParameters()) {
            if (!fieldName.equals(parameter.getName())) continue;
            return true;
        }
        for (MojoRequirement requirement : descriptor.getRequirements()) {
            if (!fieldName.equals(requirement.getFieldName())) continue;
            return true;
        }
        return false;
    }

    private Map<String, MojoDescriptor> loadMojos(File mojosXml) throws IOException {
        HashMap<String, MojoDescriptor> mojos = new HashMap<String, MojoDescriptor>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(mojosXml);){
                this.readMojosXml(mojos, is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        return mojos;
    }

    private Map<String, MojoDescriptor> loadClasspathMojos(Set<File> files, Set<File> jars) {
        Object var7_11;
        HashMap<String, MojoDescriptor> mojos = new HashMap<String, MojoDescriptor>();
        for (File jarFile : jars) {
            try {
                Throwable throwable = null;
                var7_11 = null;
                try (ZipFile zip = new ZipFile(jarFile);){
                    InputStream is;
                    Object var11_19;
                    Throwable throwable2;
                    ZipEntry entry = zip.getEntry(PATH_MOJOS_XML);
                    if (entry != null) {
                        throwable2 = null;
                        var11_19 = null;
                        try {
                            is = zip.getInputStream(entry);
                            try {
                                this.readMojosXml(mojos, is);
                                continue;
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    entry = zip.getEntry(PATH_PLUGIN_XML);
                    if (entry == null) continue;
                    throwable2 = null;
                    var11_19 = null;
                    try {
                        is = zip.getInputStream(entry);
                        try {
                            this.readPluginXml(mojos, is);
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (IOException | XmlPullParserException e) {
                this.logger.warn("Could not read dependency mojos.xml " + jarFile, e);
            }
        }
        for (File mojosXmlFile : files) {
            try {
                Throwable e = null;
                var7_11 = null;
                try (FileInputStream is = new FileInputStream(mojosXmlFile);){
                    this.readMojosXml(mojos, is);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException | XmlPullParserException e) {
                this.logger.warn("Could not read dependency mojos.xml " + mojosXmlFile, e);
            }
        }
        return mojos;
    }

    private void readMojosXml(Map<String, MojoDescriptor> mojos, InputStream is) throws XmlPullParserException, IOException {
        PluginDescriptor pluginDescriptor = new PluginDescriptorXpp3Reader().read(is);
        for (MojoDescriptor mojo : pluginDescriptor.getMojos()) {
            mojos.put(mojo.getImplementation(), mojo);
        }
    }

    private void readPluginXml(Map<String, MojoDescriptor> mojos, InputStream is) throws XmlPullParserException, IOException {
        for (MojoDescriptor mojo : LegacyPluginDescriptors.readMojos(is)) {
            mojos.put(mojo.getImplementation(), mojo);
        }
    }

    private PluginDescriptor newPluginDescriptor() {
        String defaultGoalPrefix = org.apache.maven.plugin.descriptor.PluginDescriptor.getGoalPrefixFromArtifactId((String)this.artifactId);
        if (this.goalPrefix == null) {
            this.goalPrefix = defaultGoalPrefix;
        } else if (!this.goalPrefix.equals(defaultGoalPrefix)) {
            this.getLog().warn((CharSequence)("\n\nGoal prefix is specified as: '" + this.goalPrefix + "'. " + "Maven currently expects it to be '" + defaultGoalPrefix + "'.\n"));
        }
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.groupId);
        pluginDescriptor.setArtifactId(this.artifactId);
        pluginDescriptor.setVersion(this.version);
        pluginDescriptor.setGoalPrefix(this.goalPrefix);
        pluginDescriptor.setName(this.name);
        pluginDescriptor.setDescription(this.description);
        pluginDescriptor.setInheritedByDefault(true);
        return pluginDescriptor;
    }

    protected void createEclipseMetadataXml(Output<File> output, File mojosXml, File existingEclipseMetadataXml) throws IOException {
        block19: {
            Throwable throwable = null;
            Object var5_6 = null;
            try (OutputStream out = output.newOutputStream();){
                if (existingEclipseMetadataXml.isFile()) {
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (InputStream in = Files.newInputStream(existingEclipseMetadataXml.toPath(), new OpenOption[0]);){
                        in.transferTo(out);
                        break block19;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                Map<String, MojoDescriptor> mojos = this.loadMojos(mojosXml);
                List<String> goals = mojos.values().stream().filter(MojoDescriptor::isTakariBuilder).map(MojoDescriptor::getGoal).collect(Collectors.toList());
                this.writeEclipseMetadataXml(out, goals);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private void writeEclipseMetadataXml(OutputStream out, List<String> goals) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer, "UTF-8", null);
        w.writeMarkup("\n<!-- Generated by " + ((Object)((Object)this)).getClass().getSimpleName() + " -->\n\n");
        w.startElement("lifecycleMappingMetadata");
        if (!goals.isEmpty()) {
            w.startElement("pluginExecutions");
            w.startElement("pluginExecution");
            w.startElement("pluginExecutionFilter");
            w.startElement("goals");
            goals.forEach(arg_0 -> this.lambda$2((XMLWriter)w, arg_0));
            w.endElement();
            w.endElement();
            w.startElement("action");
            w.startElement("configurator");
            w.startElement("id");
            w.writeText("io.takari.m2e.incrementalbuild.builderMojoExecutionConfigurator");
            w.endElement();
            w.endElement();
            w.endElement();
            w.endElement();
            w.endElement();
        }
        w.endElement();
        writer.close();
    }

    private void writeGoalElement(XMLWriter w, String goal) {
        w.startElement("goal");
        w.writeText(goal);
        w.endElement();
    }

    private /* synthetic */ void lambda$2(XMLWriter xMLWriter, String g) {
        this.writeGoalElement(xMLWriter, g);
    }
}

