/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin.model.io.xpp3;

import io.takari.maven.plugins.plugin.model.MojoDescriptor;
import io.takari.maven.plugins.plugin.model.MojoParameter;
import io.takari.maven.plugins.plugin.model.MojoRequirement;
import io.takari.maven.plugins.plugin.model.PluginDependency;
import io.takari.maven.plugins.plugin.model.PluginDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PluginDescriptorXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public PluginDescriptorXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public PluginDescriptorXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public PluginDescriptor read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginDescriptor pluginDescriptor = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"mojos".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'mojos' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'mojos'", parser, null);
                }
                pluginDescriptor = this.parsePluginDescriptor(parser, strict);
                pluginDescriptor.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return pluginDescriptor;
        }
        throw new XmlPullParserException("Expected root element 'mojos' but found no element at all: invalid XML document", parser, null);
    }

    public PluginDescriptor read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public PluginDescriptor read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public PluginDescriptor read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public PluginDescriptor read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private MojoDescriptor parseMojoDescriptor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        MojoDescriptor mojoDescriptor = new MojoDescriptor();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            parser.getAttributeValue(i);
            if (name.indexOf(58) < 0) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "superclasses", null, parsed)) {
                ArrayList<String> superclasses = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("superclasse".equals(parser.getName())) {
                        superclasses.add(this.interpolatedTrimmed(parser.nextText(), "superclasses"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                mojoDescriptor.setSuperclasses(superclasses);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goal", null, parsed)) {
                mojoDescriptor.setGoal(this.interpolatedTrimmed(parser.nextText(), "goal"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                mojoDescriptor.setDescription(this.interpolatedTrimmed(parser.nextText(), "description"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "since", null, parsed)) {
                mojoDescriptor.setSince(this.interpolatedTrimmed(parser.nextText(), "since"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresDependencyResolution", null, parsed)) {
                mojoDescriptor.setRequiresDependencyResolution(this.interpolatedTrimmed(parser.nextText(), "requiresDependencyResolution"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresDependencyCollection", null, parsed)) {
                mojoDescriptor.setRequiresDependencyCollection(this.interpolatedTrimmed(parser.nextText(), "requiresDependencyCollection"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresDirectInvocation", null, parsed)) {
                mojoDescriptor.setRequiresDirectInvocation(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "requiresDirectInvocation"), "requiresDirectInvocation", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresProject", null, parsed)) {
                mojoDescriptor.setRequiresProject(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "requiresProject"), "requiresProject", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresReports", null, parsed)) {
                mojoDescriptor.setRequiresReports(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "requiresReports"), "requiresReports", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "aggregator", null, parsed)) {
                mojoDescriptor.setAggregator(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "aggregator"), "aggregator", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresOnline", null, parsed)) {
                mojoDescriptor.setRequiresOnline(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "requiresOnline"), "requiresOnline", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inheritedByDefault", null, parsed)) {
                mojoDescriptor.setInheritedByDefault(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "inheritedByDefault"), "inheritedByDefault", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "phase", null, parsed)) {
                mojoDescriptor.setPhase(this.interpolatedTrimmed(parser.nextText(), "phase"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "implementation", null, parsed)) {
                mojoDescriptor.setImplementation(this.interpolatedTrimmed(parser.nextText(), "implementation"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "language", null, parsed)) {
                mojoDescriptor.setLanguage(this.interpolatedTrimmed(parser.nextText(), "language"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configurator", null, parsed)) {
                mojoDescriptor.setConfigurator(this.interpolatedTrimmed(parser.nextText(), "configurator"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "instantiationStrategy", null, parsed)) {
                mojoDescriptor.setInstantiationStrategy(this.interpolatedTrimmed(parser.nextText(), "instantiationStrategy"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "executionStrategy", null, parsed)) {
                mojoDescriptor.setExecutionStrategy(this.interpolatedTrimmed(parser.nextText(), "executionStrategy"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "threadSafe", null, parsed)) {
                mojoDescriptor.setThreadSafe(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "threadSafe"), "threadSafe", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "deprecated", null, parsed)) {
                mojoDescriptor.setDeprecated(this.interpolatedTrimmed(parser.nextText(), "deprecated"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "parameters", null, parsed)) {
                ArrayList<MojoParameter> parameters = new ArrayList<MojoParameter>();
                while (parser.nextTag() == 2) {
                    if ("parameter".equals(parser.getName())) {
                        parameters.add(this.parseMojoParameter(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                mojoDescriptor.setParameters(parameters);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requirements", null, parsed)) {
                ArrayList<MojoRequirement> requirements = new ArrayList<MojoRequirement>();
                while (parser.nextTag() == 2) {
                    if ("requirement".equals(parser.getName())) {
                        requirements.add(this.parseMojoRequirement(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                mojoDescriptor.setRequirements(requirements);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "takariBuilder", null, parsed)) {
                mojoDescriptor.setTakariBuilder(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "takariBuilder"), "takariBuilder", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return mojoDescriptor;
    }

    private MojoParameter parseMojoParameter(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        MojoParameter mojoParameter = new MojoParameter();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            parser.getAttributeValue(i);
            if (name.indexOf(58) < 0) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                mojoParameter.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "alias", null, parsed)) {
                mojoParameter.setAlias(this.interpolatedTrimmed(parser.nextText(), "alias"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                mojoParameter.setType(this.interpolatedTrimmed(parser.nextText(), "type"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "required", null, parsed)) {
                mojoParameter.setRequired(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "required"), "required", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "editable", null, parsed)) {
                mojoParameter.setEditable(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "editable"), "editable", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                mojoParameter.setDescription(this.interpolatedTrimmed(parser.nextText(), "description"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "deprecated", null, parsed)) {
                mojoParameter.setDeprecated(this.interpolatedTrimmed(parser.nextText(), "deprecated"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "since", null, parsed)) {
                mojoParameter.setSince(this.interpolatedTrimmed(parser.nextText(), "since"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "implementation", null, parsed)) {
                mojoParameter.setImplementation(this.interpolatedTrimmed(parser.nextText(), "implementation"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "defaultValue", null, parsed)) {
                mojoParameter.setDefaultValue(this.interpolatedTrimmed(parser.nextText(), "defaultValue"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "expression", null, parsed)) {
                mojoParameter.setExpression(this.interpolatedTrimmed(parser.nextText(), "expression"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return mojoParameter;
    }

    private MojoRequirement parseMojoRequirement(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        MojoRequirement mojoRequirement = new MojoRequirement();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            parser.getAttributeValue(i);
            if (name.indexOf(58) < 0) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "fieldName", null, parsed)) {
                mojoRequirement.setFieldName(this.interpolatedTrimmed(parser.nextText(), "fieldName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "role", null, parsed)) {
                mojoRequirement.setRole(this.interpolatedTrimmed(parser.nextText(), "role"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "roleHint", null, parsed)) {
                mojoRequirement.setRoleHint(this.interpolatedTrimmed(parser.nextText(), "roleHint"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return mojoRequirement;
    }

    private PluginDependency parsePluginDependency(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginDependency pluginDependency = new PluginDependency();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            parser.getAttributeValue(i);
            if (name.indexOf(58) < 0) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                pluginDependency.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                pluginDependency.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                pluginDependency.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                pluginDependency.setType(this.interpolatedTrimmed(parser.nextText(), "type"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return pluginDependency;
    }

    private PluginDescriptor parsePluginDescriptor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            String name = parser.getAttributeName(i);
            parser.getAttributeValue(i);
            if (name.indexOf(58) < 0 && !"xmlns".equals(name)) {
                this.checkUnknownAttribute(parser, name, tagName, strict);
            }
            --i;
        }
        new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("mojo".equals(parser.getName())) {
                List<MojoDescriptor> mojos = pluginDescriptor.getMojos();
                if (mojos == null) {
                    mojos = new ArrayList<MojoDescriptor>();
                }
                mojos.add(this.parseMojoDescriptor(parser, strict));
                pluginDescriptor.setMojos(mojos);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return pluginDescriptor;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

