/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.junit.Assert;

public class TestProperties {
    public static final String PROP_CLASSPATH = "classpath";
    public static final String PROP_USER_SETTING = "userSettings";
    public static final String PROP_USER_SETTING_FILE = "userSettingsFile";
    public static final String PROP_GLOBAL_SETTING_FILE = "globalSettingsFile";
    public static final String PROP_LOCAL_REPOSITORY = "localRepository";
    public static final String PROP_OFFLINE = "offline";
    public static final String PROP_UPDATESNAPSHOTS = "updateSnapshots";
    public static final String PROP_REPOSITORY = "repository.";
    private final Map<String, String> properties;

    public TestProperties() {
        try {
            this.properties = this.loadProperties();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, String> loadProperties() throws IOException {
        Properties p = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream os = this.getClass().getClassLoader().getResourceAsStream("test.properties");){
            Assert.assertNotNull((String)"test.properties must be preset on test classpath, see https://github.com/takari/takari-plugin-testing-project/blob/master/testproperties.md for me details", (Object)os);
            p.load(os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key : p.stringPropertyNames()) {
            properties.put(key, p.getProperty(key));
        }
        return Collections.unmodifiableMap(properties);
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public File getUserSettings() {
        String path = this.properties.get(PROP_USER_SETTING_FILE);
        if (path == null) {
            path = this.properties.get(PROP_USER_SETTING);
        }
        if (path == null) {
            return null;
        }
        File file = new File(path);
        Assert.assertTrue((String)"Can read user settings.xml", (boolean)file.canRead());
        return file;
    }

    public File getGlobalSettings() {
        String path = this.properties.get(PROP_GLOBAL_SETTING_FILE);
        if (path == null) {
            return null;
        }
        File file = new File(path);
        Assert.assertTrue((String)"Can read global settings.xml", (boolean)file.canRead());
        return file;
    }

    public File getLocalRepository() {
        String path = this.properties.get(PROP_LOCAL_REPOSITORY);
        Assert.assertNotNull((String)"Local repository specified", (Object)path);
        return new File(path);
    }

    public boolean getOffline() {
        String value = this.properties.get(PROP_OFFLINE);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    public boolean getUpdateSnapshots() {
        String value = this.properties.get(PROP_UPDATESNAPSHOTS);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    public String getPluginVersion() {
        return this.properties.get("project.version");
    }

    public List<File> getRuntimeClasspath() {
        StringTokenizer st = new StringTokenizer(this.properties.get(PROP_CLASSPATH), File.pathSeparator);
        ArrayList<File> dependencies = new ArrayList<File>();
        while (st.hasMoreTokens()) {
            dependencies.add(new File(st.nextToken()));
        }
        return dependencies;
    }

    public List<String> getRepositories() {
        TreeMap<String, String> repositories = new TreeMap<String, String>();
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            if (!property.getKey().startsWith(PROP_REPOSITORY)) continue;
            repositories.put(property.getKey(), property.getValue());
        }
        return new ArrayList<String>(repositories.values());
    }
}

