/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor.junit;

import io.takari.maven.testing.executor.MavenInstallationUtils;
import io.takari.maven.testing.executor.MavenRuntime;
import io.takari.maven.testing.executor.junit.MavenHomeUtils;
import java.io.File;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

final class ForcedMavenRuntimeBuilderParameterResolver
implements ParameterResolver {
    ForcedMavenRuntimeBuilderParameterResolver() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == MavenRuntime.MavenRuntimeBuilder.class && MavenHomeUtils.isForced();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        File forcedMavenHome = MavenInstallationUtils.getForcedMavenHome();
        File forcedClassworldsConf = MavenInstallationUtils.getForcedClassworldsConf();
        if (forcedMavenHome != null && (forcedMavenHome.isDirectory() || forcedClassworldsConf != null && forcedClassworldsConf.isFile())) {
            return MavenRuntime.builder(forcedMavenHome, forcedClassworldsConf);
        }
        throw new ParameterResolutionException("Invalid -Dmaven.home=" + forcedMavenHome.getAbsolutePath());
    }
}

