/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor.junit;

import io.takari.maven.testing.executor.MavenVersions;
import io.takari.maven.testing.executor.junit.MavenHomeUtils;
import io.takari.maven.testing.executor.junit.MavenVersionDisplayNameFormatter;
import io.takari.maven.testing.executor.junit.MavenVersionResolver;
import io.takari.maven.testing.executor.junit.MavenVersionTestInvocationContext;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.runners.model.InitializationError;

final class MavenVersionsTestExtension
implements TestTemplateInvocationContextProvider {
    MavenVersionsTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        if (MavenHomeUtils.isForced()) {
            return false;
        }
        return context.getTestClass().map(clazz -> clazz.isAnnotationPresent(MavenVersions.class)).orElse(false);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        final String displayName = context.getDisplayName();
        String[] versions = ((Class)context.getTestClass().get()).getAnnotation(MavenVersions.class).value();
        final ArrayList contexts = new ArrayList();
        final ArrayList errors = new ArrayList();
        try {
            new MavenVersionResolver(){

                @Override
                protected void resolved(File mavenHome, String version) throws InitializationError {
                    contexts.add(new MavenVersionTestInvocationContext(version, mavenHome, new MavenVersionDisplayNameFormatter(displayName)));
                }

                @Override
                protected void error(String version, Exception cause) {
                    errors.add(new Exception("Could not resolve maven version " + version, cause));
                }
            }.resolve(versions);
        }
        catch (Exception e) {
            throw new ExtensionConfigurationException("Could not resolve maven versions", (Throwable)e);
        }
        if (!errors.isEmpty()) {
            ExtensionConfigurationException extensionConfigurationException = new ExtensionConfigurationException("Could not resolve maven versions");
            for (Throwable error : errors) {
                extensionConfigurationException.addSuppressed(error);
            }
            throw extensionConfigurationException;
        }
        return contexts.stream();
    }
}

