/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive;

import ca.vanzyl.provisio.archive.ArchiverHelper;
import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import ca.vanzyl.provisio.archive.Selector;
import ca.vanzyl.provisio.archive.Source;
import ca.vanzyl.provisio.archive.UnarchivingEntryProcessor;
import ca.vanzyl.provisio.archive.perms.FileMode;
import ca.vanzyl.provisio.archive.perms.PosixModes;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class UnArchiver {
    private final Selector selector;
    private final boolean useRoot;
    private final boolean flatten;
    private final boolean dereferenceHardlinks;
    private final UnArchiverBuilder builder;

    public UnArchiver(UnArchiverBuilder builder) {
        this.builder = builder;
        this.useRoot = builder.useRoot;
        this.flatten = builder.flatten;
        this.dereferenceHardlinks = builder.dereferenceHardlinks;
        this.selector = new Selector(builder.includes, builder.excludes);
    }

    public void unarchive(File archive, File outputDirectory) throws IOException {
        this.unarchive(archive, outputDirectory, new NoopEntryProcessor());
    }

    public void unarchive(File archive, File outputDirectory, UnarchivingEntryProcessor entryProcessor) throws IOException {
        outputDirectory.mkdirs();
        Source source = ArchiverHelper.getArchiveHandler(archive, this.builder).getArchiveSource();
        for (ExtendedArchiveEntry archiveEntry : source.entries()) {
            String entryName = this.adjustPath(archiveEntry.getName(), entryProcessor);
            if (!this.selector.include(entryName)) continue;
            if (archiveEntry.isDirectory()) {
                this.createDir(new File(outputDirectory, entryName));
                continue;
            }
            File outputFile = new File(outputDirectory, entryName);
            if (outputFile.getAbsolutePath().equals(outputDirectory.getAbsolutePath())) continue;
            if (!outputFile.getParentFile().exists()) {
                this.createDir(outputFile.getParentFile());
            }
            if (archiveEntry.isHardLink()) {
                File hardLinkSource = new File(outputDirectory, this.adjustPath(archiveEntry.getHardLinkPath(), entryProcessor));
                if (this.dereferenceHardlinks) {
                    Files.copy(hardLinkSource.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.deleteIfExists(outputFile.toPath());
                    Files.createLink(outputFile.toPath(), hardLinkSource.toPath());
                }
                this.setFilePermission(archiveEntry, outputFile);
                continue;
            }
            if (archiveEntry.isSymbolicLink()) {
                Path outputPath = outputDirectory.toPath();
                Path link = outputDirectory.toPath().resolve(entryName);
                Path target = outputDirectory.toPath().relativize(outputPath.resolve(archiveEntry.getSymbolicLinkPath()));
                Files.createDirectories(link.getParent(), new FileAttribute[0]);
                Files.createSymbolicLink(link, target, new FileAttribute[0]);
                continue;
            }
            Throwable throwable = null;
            Object var10_11 = null;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
                entryProcessor.processStream(archiveEntry.getName(), archiveEntry.getInputStream(), outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.setFilePermission(archiveEntry, outputFile);
        }
        source.close();
    }

    private String adjustPath(String entryName, UnarchivingEntryProcessor entryProcessor) {
        if (!this.useRoot) {
            entryName = entryName.substring(entryName.indexOf(47) + 1);
        }
        entryName = entryProcessor.processName(entryName);
        if (this.flatten) {
            entryName = entryName.substring(entryName.lastIndexOf("/") + 1);
        }
        return entryName;
    }

    private void setFilePermission(ExtendedArchiveEntry archiveEntry, File outputFile) throws IOException {
        int mode = archiveEntry.getFileMode();
        if (mode > 0) {
            this.setFilePermissions(outputFile, FileMode.toPermissionsSet(mode));
        } else if (archiveEntry.isDirectory()) {
            this.setFilePermissions(outputFile, PosixModes.intModeToPosix(493));
        } else {
            this.setFilePermissions(outputFile, PosixModes.intModeToPosix(420));
        }
    }

    private void setFilePermissions(File file, Set<PosixFilePermission> perms) throws IOException {
        try {
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    private void createDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static UnArchiverBuilder builder() {
        return new UnArchiverBuilder();
    }

    static class NoopEntryProcessor
    implements UnarchivingEntryProcessor {
        NoopEntryProcessor() {
        }

        @Override
        public String processName(String entryName) {
            return entryName;
        }

        @Override
        public void processStream(String entryName, InputStream inputStream, OutputStream outputStream) throws IOException {
            inputStream.transferTo(outputStream);
        }
    }

    public static class UnArchiverBuilder {
        List<String> includes = new ArrayList<String>();
        List<String> excludes = new ArrayList<String>();
        boolean useRoot = true;
        boolean flatten = false;
        boolean posixLongFileMode;
        boolean dereferenceHardlinks = false;

        public UnArchiverBuilder includes(String ... includes) {
            ArrayList<String> i = new ArrayList<String>();
            String[] stringArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                String include = stringArray[n2];
                if (include != null) {
                    i.add(include);
                }
                ++n2;
            }
            return this.includes(List.copyOf(i));
        }

        public UnArchiverBuilder includes(Iterable<String> includes) {
            includes.forEach(this.includes::add);
            return this;
        }

        public UnArchiverBuilder excludes(String ... excludes) {
            ArrayList<String> i = new ArrayList<String>();
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                if (exclude != null) {
                    i.add(exclude);
                }
                ++n2;
            }
            return this.excludes(List.copyOf(i));
        }

        public UnArchiverBuilder excludes(Iterable<String> excludes) {
            excludes.forEach(this.excludes::add);
            return this;
        }

        public UnArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public UnArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public UnArchiverBuilder posixLongFileMode(boolean posixLongFileMode) {
            this.posixLongFileMode = posixLongFileMode;
            return this;
        }

        public UnArchiverBuilder dereferenceHardlinks(boolean dereferenceHardlinks) {
            this.dereferenceHardlinks = dereferenceHardlinks;
            return this;
        }

        public UnArchiver build() {
            return new UnArchiver(this);
        }
    }
}

