/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.generator;

import ca.vanzyl.provisio.archive.generator.ArtifactGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarArtifactGenerator
implements ArtifactGenerator {
    private static final int BUF_SIZE_BYTES = 4096;
    private static final long bytesInMegabyte = 0x100000L;
    private final long sizeInMegabytes;
    private final Random rnd;
    private final File file;

    public JarArtifactGenerator(File file, long sizeInMegabytes) {
        this.file = file;
        this.sizeInMegabytes = sizeInMegabytes * 0x100000L;
        this.rnd = new Random(12345L);
    }

    @Override
    public void generate() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream outputStream = new FileOutputStream(this.file);){
            this.writeTo(outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeTo(OutputStream os) throws IOException {
        int chunk = 100000;
        ZipOutputStream zos = new ZipOutputStream(os);
        int j = 1;
        int i = 0;
        while ((long)i < this.sizeInMegabytes - 1L) {
            zos.setLevel(0);
            ZipEntry ze = new ZipEntry("content-" + String.format("%03d", j));
            zos.putNextEntry(ze);
            this.writeBytesTo(zos, this.rnd.nextLong(), chunk);
            zos.closeEntry();
            ++j;
            i += chunk;
        }
        zos.finish();
    }

    private void writeBytesTo(OutputStream os, long seed, int chunk) throws IOException {
        Random content = new Random(seed);
        byte[] buf = new byte[4096];
        int i = 0;
        while (i < chunk / 4096) {
            content.nextBytes(buf);
            os.write(buf);
            ++i;
        }
        content.nextBytes(buf);
        os.write(buf, 0, chunk % 4096);
    }
}

