/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.generator;

import ca.vanzyl.provisio.archive.Archiver;
import ca.vanzyl.provisio.archive.generator.ArtifactEntry;
import ca.vanzyl.provisio.archive.generator.ArtifactGenerator;
import ca.vanzyl.provisio.archive.generator.ArtifactLayout;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class TarGzArtifactGenerator
implements ArtifactGenerator {
    private final File artifact;
    private final ArtifactLayout artifactLayout;

    public TarGzArtifactGenerator(File artifact, File layoutDirectory) {
        this.artifact = artifact;
        this.artifactLayout = new ArtifactLayout(layoutDirectory);
    }

    public TarGzArtifactGenerator(File artifact, File layoutDirectory, List<ArtifactEntry> artifactEntries) {
        this.artifact = artifact;
        this.artifactLayout = new ArtifactLayout(layoutDirectory, artifactEntries);
    }

    public TarGzArtifactGenerator(File artifact, ArtifactLayout layout) {
        this.artifact = artifact;
        this.artifactLayout = layout;
    }

    public TarGzArtifactGenerator entry(String name, String content) {
        this.artifactLayout.entry(name, content);
        return this;
    }

    @Override
    public void generate() throws IOException {
        this.artifactLayout.build();
        Archiver archiver = Archiver.builder().useRoot(false).normalize(true).posixLongFileMode(true).build();
        archiver.archive(this.artifact, this.artifactLayout.directory());
    }
}

