/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.zip;

import ca.vanzyl.provisio.archive.ArchiveHandlerSupport;
import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import ca.vanzyl.provisio.archive.Source;
import ca.vanzyl.provisio.archive.zip.ExtendedZipArchiveEntry;
import ca.vanzyl.provisio.archive.zip.ZipArchiveSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipArchiveHandler
extends ArchiveHandlerSupport {
    private final File archive;

    public ZipArchiveHandler(File archive) {
        this.archive = archive;
    }

    @Override
    public ExtendedArchiveEntry newEntry(String entryName, ExtendedArchiveEntry entry) {
        return new ExtendedZipArchiveEntry(entryName, entry);
    }

    @Override
    public ArchiveInputStream getInputStream() throws IOException {
        return new ZipArchiveInputStream((InputStream)new FileInputStream(this.archive), "UTF8", true, true);
    }

    @Override
    public Source getArchiveSource() {
        return new ZipArchiveSource(this.archive);
    }

    @Override
    public ArchiveOutputStream getOutputStream() throws IOException {
        return new ZipArchiveOutputStream((OutputStream)new FileOutputStream(this.archive));
    }
}

