/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executor;
import org.xnio.channels.StreamSourceChannel;

public class WorkerDispatcher {
    private static final ThreadLocal<DispatchData> executingInWorker = new ThreadLocal();
    public static final AttachmentKey<Executor> EXECUTOR_ATTACHMENT_KEY = AttachmentKey.create(Executor.class);

    public static void dispatch(HttpServerExchange exchange, Runnable runnable) {
        DispatchData dd;
        Executor executor = exchange.getAttachment(EXECUTOR_ATTACHMENT_KEY);
        if (executor == null) {
            executor = exchange.getConnection().getWorker();
        }
        if ((dd = executingInWorker.get()) != null && dd.executor == executor) {
            runnable.run();
        } else {
            executor.execute(new DispatchedRunnable(executor, runnable));
        }
    }

    public static void forceDispatch(HttpServerExchange exchange, Runnable runnable) {
        Executor executor = exchange.getAttachment(EXECUTOR_ATTACHMENT_KEY);
        if (executor == null) {
            executor = exchange.getConnection().getWorker();
        }
        DispatchData dd = executingInWorker.get();
        executor.execute(new DispatchedRunnable(executor, runnable));
    }

    public static void dispatch(Executor executor, Runnable runnable) {
        executor.execute(new DispatchedRunnable(executor, runnable));
    }

    public static void dispatchNextRequest(StreamSourceChannel channel, Runnable runnable) {
        DispatchData dd = executingInWorker.get();
        if (dd == null) {
            channel.getReadThread().execute(runnable);
        } else {
            dd.tasks.add(runnable);
        }
    }

    private WorkerDispatcher() {
    }

    private static class DispatchedRunnable
    implements Runnable {
        private final Executor executor;
        private final Runnable runnable;

        public DispatchedRunnable(Executor executor, Runnable runnable) {
            this.executor = executor;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DispatchData data = new DispatchData(this.executor);
            try {
                executingInWorker.set(data);
                this.runnable.run();
            }
            catch (Exception e) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
            }
            finally {
                Runnable next = data.tasks.poll();
                try {
                    while (next != null) {
                        try {
                            next.run();
                        }
                        catch (Exception e) {
                            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
                        }
                        next = data.tasks.poll();
                    }
                }
                finally {
                    executingInWorker.remove();
                }
            }
        }
    }

    private static final class DispatchData {
        final Executor executor;
        final Deque<Runnable> tasks = new ArrayDeque<Runnable>();

        private DispatchData(Executor executor) {
            this.executor = executor;
        }
    }
}

