/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConduitFactory;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;

public class PipelingBufferingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    public static final AttachmentKey<PipelingBufferingStreamSinkConduit> ATTACHMENT_KEY = AttachmentKey.create(PipelingBufferingStreamSinkConduit.class);
    private static final int SHUTDOWN = 1;
    private static final int DELEGATE_SHUTDOWN = 2;
    private static final int FLUSHING = 8;
    private int state;
    private final Pool<ByteBuffer> pool;
    private Pooled<ByteBuffer> buffer;
    private final ExchangeCompletionListener completionListener = new ExchangeCompletionListener(){

        @Override
        public void exchangeEvent(HttpServerExchange exchange, final ExchangeCompletionListener.NextListener nextListener) {
            HttpServerConnection connection = exchange.getConnection();
            if (connection.getExtraBytes() == null || exchange.isUpgrade()) {
                try {
                    if (!PipelingBufferingStreamSinkConduit.this.flushPipelinedData()) {
                        final ConnectedStreamChannel channel = connection.getChannel();
                        channel.getWriteSetter().set((ChannelListener)new ChannelListener<Channel>(){

                            public void handleEvent(Channel c) {
                                try {
                                    if (PipelingBufferingStreamSinkConduit.this.flushPipelinedData()) {
                                        channel.getWriteSetter().set(null);
                                        channel.suspendWrites();
                                        nextListener.proceed();
                                    }
                                }
                                catch (IOException e) {
                                    UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
                                    IoUtils.safeClose((Closeable)channel);
                                }
                            }
                        });
                        connection.getChannel().resumeWrites();
                        return;
                    }
                    nextListener.proceed();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                nextListener.proceed();
            }
        }
    };

    public PipelingBufferingStreamSinkConduit(StreamSinkConduit next, Pool<ByteBuffer> pool) {
        super(next);
        this.pool = pool;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int put;
        boolean res;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet((int)this.state, (int)8) && !(res = this.flushBuffer())) {
            return 0L;
        }
        Pooled pooled = this.buffer;
        if (pooled == null) {
            this.buffer = pooled = this.pool.allocate();
        }
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        int total = 0;
        for (int i = offset; i < offset + length; ++i) {
            total += srcs[i].remaining();
        }
        if (buffer.remaining() > total) {
            put = total;
            Buffers.copy((ByteBuffer)buffer, (ByteBuffer[])srcs, (int)offset, (int)length);
            return put;
        }
        put = buffer.remaining();
        Buffers.copy((int)put, (ByteBuffer)buffer, (ByteBuffer[])srcs, (int)offset, (int)length);
        this.flushBuffer();
        return put;
    }

    public int write(ByteBuffer src) throws IOException {
        ByteBuffer buffer;
        boolean res;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet((int)this.state, (int)8) && !(res = this.flushBuffer())) {
            return 0;
        }
        Pooled pooled = this.buffer;
        if (pooled == null) {
            this.buffer = pooled = this.pool.allocate();
        }
        if ((buffer = (ByteBuffer)pooled.getResource()).remaining() > src.remaining()) {
            int put = src.remaining();
            buffer.put(src);
            return put;
        }
        int put = buffer.remaining();
        int old = src.limit();
        src.limit(src.position() + put);
        buffer.put(src);
        src.limit(old);
        this.flushBuffer();
        return put;
    }

    public boolean flushPipelinedData() throws IOException {
        if (this.buffer == null || ((ByteBuffer)this.buffer.getResource()).position() == 0) {
            return ((StreamSinkConduit)this.next).flush();
        }
        if (!this.flushBuffer()) {
            return false;
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    public ConduitWrapper<StreamSinkConduit> getChannelWrapper() {
        return new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                exchange.addExchangeCompleteListener(PipelingBufferingStreamSinkConduit.this.completionListener);
                return PipelingBufferingStreamSinkConduit.this;
            }
        };
    }

    private boolean flushBuffer() throws IOException {
        if (this.buffer == null) {
            return ((StreamSinkConduit)this.next).flush();
        }
        ByteBuffer byteBuffer = (ByteBuffer)this.buffer.getResource();
        if (!Bits.anyAreSet((int)this.state, (int)8)) {
            this.state |= 8;
            byteBuffer.flip();
        }
        int res = 0;
        do {
            if ((res = ((StreamSinkConduit)this.next).write(byteBuffer)) != 0) continue;
            return false;
        } while (byteBuffer.hasRemaining());
        if (!((StreamSinkConduit)this.next).flush()) {
            return false;
        }
        this.buffer.free();
        this.buffer = null;
        this.state &= 0xFFFFFFF7;
        return true;
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.buffer != null && ((ByteBuffer)this.buffer.getResource()).hasRemaining()) {
            return;
        }
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    public void awaitWritable() throws IOException {
        if (this.buffer != null) {
            if (((ByteBuffer)this.buffer.getResource()).hasRemaining()) {
                return;
            }
            ((StreamSinkConduit)this.next).awaitWritable();
        }
    }

    public boolean flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            if (!this.flushBuffer()) {
                return false;
            }
            if (Bits.anyAreSet((int)this.state, (int)1) && Bits.anyAreClear((int)this.state, (int)2)) {
                this.state |= 2;
                ((StreamSinkConduit)this.next).terminateWrites();
            }
            return ((StreamSinkConduit)this.next).flush();
        }
        return true;
    }

    public void terminateWrites() throws IOException {
        this.state |= 1;
        if (this.buffer == null) {
            this.state |= 2;
            ((StreamSinkConduit)this.next).terminateWrites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateWrites() throws IOException {
        try {
            ((StreamSinkConduit)this.next).truncateWrites();
        }
        finally {
            if (this.buffer != null) {
                this.buffer.free();
            }
        }
    }
}

