/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.security.api.RoleMappingManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RoleMappingManagerImpl
implements RoleMappingManager {
    private final Map<String, Set<String>> principleVsRoleMappings;
    private final Map<String, Set<String>> roleVsPrincipleMappings;

    public RoleMappingManagerImpl(Map<String, Set<String>> principleVsRoleMappings) {
        this.principleVsRoleMappings = principleVsRoleMappings;
        HashMap<String, Set<String>> roleVsPrincipleMappings = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : principleVsRoleMappings.entrySet()) {
            for (String val : entry.getValue()) {
                HashSet<String> principles = (HashSet<String>)roleVsPrincipleMappings.get(val);
                if (principles == null) {
                    principles = new HashSet<String>();
                    roleVsPrincipleMappings.put(val, principles);
                }
                principles.add(entry.getKey());
            }
        }
        this.roleVsPrincipleMappings = roleVsPrincipleMappings;
    }

    @Override
    public boolean isUserInRole(String role, SecurityContext securityContext) {
        if (!securityContext.isAuthenticated()) {
            return false;
        }
        Account account = securityContext.getAuthenticatedAccount();
        Principal principal = account.getPrincipal();
        Set<String> principleGroups = this.principleVsRoleMappings.get(principal.getName());
        if (principleGroups != null && principleGroups.contains(role)) {
            return true;
        }
        Set<String> groupRoles = this.roleVsPrincipleMappings.get(role);
        if (groupRoles != null) {
            for (String group : groupRoles) {
                if (!account.isUserInGroup(group)) continue;
                return true;
            }
        }
        return account.isUserInGroup(role);
    }
}

