/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;

class PathMatchPredicate
implements Predicate<HttpServerExchange> {
    private final String slashPath;
    private final String path;

    public PathMatchPredicate(String path) {
        if (path.startsWith("/")) {
            this.slashPath = path;
            this.path = path.substring(1);
        } else {
            this.slashPath = "/" + path;
            this.path = path;
        }
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String relativePath = value.getRelativePath();
        if (relativePath.startsWith("/")) {
            return relativePath.equals(this.slashPath);
        }
        return relativePath.equals(this.path);
    }
}

