/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class GatedStreamSinkChannel
implements StreamSinkChannel {
    private final StreamSinkChannel delegate;
    private final Object permit;
    private final ChannelListener.SimpleSetter<GatedStreamSinkChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<GatedStreamSinkChannel> closeSetter = new ChannelListener.SimpleSetter();
    private final int config;
    private volatile int state;
    private volatile Thread waiter;
    private volatile Thread lockWaiter;
    private static final AtomicIntegerFieldUpdater<GatedStreamSinkChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(GatedStreamSinkChannel.class, "state");
    private static final AtomicReferenceFieldUpdater<GatedStreamSinkChannel, Thread> waiterUpdater = AtomicReferenceFieldUpdater.newUpdater(GatedStreamSinkChannel.class, Thread.class, "waiter");
    private static final AtomicReferenceFieldUpdater<GatedStreamSinkChannel, Thread> lockWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(GatedStreamSinkChannel.class, Thread.class, "lockWaiter");
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final int FLAG_IN_WRITE = 1;
    private static final int FLAG_IN = 2;
    private static final int FLAG_CLOSE_REQ = 4;
    private static final int FLAG_CLOSE_SENT = 8;
    private static final int FLAG_CLOSE_DONE = 16;
    private static final int FLAG_GATE_OPEN = 32;
    private static final int FLAG_RESUME = 64;

    public GatedStreamSinkChannel(StreamSinkChannel delegate, Object permit, boolean configurable, boolean passClose) {
        this.delegate = delegate;
        this.permit = permit;
        this.config = (configurable ? 1 : 0) | (passClose ? 2 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enter(int setFlags, int clearFlags, int skipIfSet, int skipIfClear) {
        boolean writeIntended = Bits.allAreSet((int)setFlags, (int)1);
        Thread currentThread = Thread.currentThread();
        boolean intr = false;
        try {
            int newVal;
            int oldVal;
            do {
                oldVal = this.state;
                if (writeIntended && Bits.allAreSet((int)oldVal, (int)1)) {
                    throw new ConcurrentStreamChannelAccessException();
                }
                if (Bits.anyAreSet((int)oldVal, (int)skipIfSet) || Bits.anyAreClear((int)oldVal, (int)skipIfClear)) {
                    int n = oldVal;
                    return n;
                }
                while (Bits.anyAreSet((int)oldVal, (int)3)) {
                    Thread waiter = lockWaiterUpdater.getAndSet(this, currentThread);
                    oldVal = this.state;
                    if (Bits.anyAreSet((int)oldVal, (int)3)) {
                        LockSupport.park(this);
                        if (Thread.interrupted()) {
                            intr = true;
                        }
                    }
                    GatedStreamSinkChannel.safeUnpark(waiter);
                }
            } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & ~clearFlags | setFlags));
            int n = oldVal;
            return n;
        }
        finally {
            if (intr) {
                currentThread.interrupt();
            }
        }
    }

    private void exit(int enterFlag, int setFlags) {
        int newVal = this.state & ~enterFlag | setFlags;
        stateUpdater.set(this, newVal);
        GatedStreamSinkChannel.safeUnpark(lockWaiterUpdater.getAndSet(this, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openGate(Object permit) {
        if (permit != this.permit) {
            throw new SecurityException();
        }
        int val = this.enter(34, 0, 32, 0);
        if (Bits.allAreSet((int)val, (int)32)) {
            return;
        }
        try {
            if (Bits.allAreSet((int)val, (int)16)) {
                IoUtils.safeClose((Closeable)this.delegate);
            } else {
                boolean doResume = Bits.allAreSet((int)val, (int)64);
                if (!doResume && this.delegate.isWriteResumed()) {
                    this.delegate.suspendWrites();
                }
                this.delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.writeSetter));
                if (doResume && !this.delegate.isWriteResumed()) {
                    this.delegate.resumeWrites();
                }
            }
            GatedStreamSinkChannel.safeUnpark(waiterUpdater.getAndSet(this, null));
        }
        finally {
            this.exit(2, 0);
        }
    }

    public boolean isGateOpen() {
        return Bits.allAreSet((int)this.state, (int)32);
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        int val = this.enter(1, 0, 4, 0);
        if (Bits.anyAreSet((int)val, (int)4)) {
            throw new ClosedChannelException();
        }
        try {
            if (Bits.anyAreClear((int)val, (int)32)) {
                int n = 0;
                return n;
            }
            int n = this.delegate.write(src);
            return n;
        }
        finally {
            this.exit(1, 0);
        }
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int val = this.enter(1, 0, 4, 0);
        if (Bits.anyAreSet((int)val, (int)4)) {
            throw new ClosedChannelException();
        }
        try {
            if (Bits.anyAreClear((int)val, (int)32)) {
                long l = 0L;
                return l;
            }
            long l = this.delegate.write(srcs, offset, length);
            return l;
        }
        finally {
            this.exit(1, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        int val = this.enter(1, 0, 4, 0);
        if (Bits.anyAreSet((int)val, (int)4)) {
            throw new ClosedChannelException();
        }
        try {
            if (Bits.anyAreClear((int)val, (int)32)) {
                long l = 0L;
                return l;
            }
            long l = this.delegate.transferFrom(src, position, count);
            return l;
        }
        finally {
            this.exit(1, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        int val = this.enter(1, 0, 4, 0);
        if (Bits.anyAreSet((int)val, (int)4)) {
            throw new ClosedChannelException();
        }
        try {
            if (Bits.anyAreClear((int)val, (int)32)) {
                long l = 0L;
                return l;
            }
            long l = this.delegate.transferFrom(source, count, throughBuffer);
            return l;
        }
        finally {
            this.exit(1, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        int val = this.enter(2, 0, 16, 0);
        if (Bits.allAreSet((int)val, (int)16)) {
            return true;
        }
        int setFlags = 0;
        try {
            boolean flushed;
            if (Bits.allAreClear((int)val, (int)32)) {
                boolean bl = false;
                return bl;
            }
            if (Bits.allAreSet((int)this.config, (int)2) && Bits.allAreSet((int)val, (int)4) && Bits.allAreClear((int)val, (int)8)) {
                setFlags |= 8;
                this.delegate.shutdownWrites();
            }
            if ((flushed = this.delegate.flush()) && Bits.anyAreSet((int)(val | setFlags), (int)8)) {
                this.delegate.suspendWrites();
                this.delegate.getWriteSetter().set(null);
                setFlags |= 0x10;
            }
            boolean bl = flushed;
            return bl;
        }
        finally {
            this.exit(2, setFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendWrites() {
        int val = this.enter(2, 64, 0, 64);
        if (Bits.allAreClear((int)val, (int)64)) {
            return;
        }
        try {
            if (Bits.allAreSet((int)val, (int)32)) {
                this.delegate.suspendWrites();
            }
        }
        finally {
            this.exit(2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWrites() {
        int val = this.enter(66, 0, 64, 0);
        if (Bits.allAreSet((int)val, (int)64)) {
            return;
        }
        try {
            if (Bits.allAreSet((int)val, (int)32)) {
                this.delegate.resumeWrites();
            }
        }
        finally {
            this.exit(2, 0);
        }
    }

    public boolean isWriteResumed() {
        int state = this.state;
        return Bits.allAreSet((int)state, (int)64) && Bits.allAreClear((int)state, (int)16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupWrites() {
        int val = this.enter(66, 0, 64, 0);
        if (Bits.allAreSet((int)val, (int)64)) {
            return;
        }
        try {
            if (Bits.allAreSet((int)val, (int)32)) {
                this.delegate.wakeupWrites();
            } else {
                this.getWriteThread().execute(ChannelListeners.getChannelListenerTask((Channel)((Object)this), this.writeSetter));
            }
        }
        finally {
            this.exit(2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownWrites() throws IOException {
        int val = this.enter(6, 0, 4, 0);
        if (Bits.allAreSet((int)val, (int)4)) {
            return;
        }
        int setFlags = 0;
        try {
            if (Bits.allAreSet((int)val, (int)32)) {
                setFlags |= 8;
                if (Bits.allAreSet((int)this.config, (int)2)) {
                    this.delegate.shutdownWrites();
                }
            }
        }
        finally {
            this.exit(2, setFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int val = this.enter(30, 0, 16, 0);
        if (Bits.allAreSet((int)val, (int)16)) {
            return;
        }
        try {
            if (Bits.allAreSet((int)val, (int)32)) {
                this.delegate.suspendWrites();
                this.delegate.getWriteSetter().set(null);
                if (Bits.allAreSet((int)this.config, (int)2)) {
                    this.delegate.close();
                }
            }
        }
        finally {
            this.exit(2, 0);
            ChannelListeners.invokeChannelListener((Channel)((Object)this), (ChannelListener)this.closeSetter.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable() throws IOException {
        if (Bits.allAreClear((int)this.state, (int)48)) {
            Thread next = waiterUpdater.getAndSet(this, Thread.currentThread());
            try {
                while (Bits.allAreClear((int)this.state, (int)48)) {
                    LockSupport.park(this);
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new InterruptedIOException();
                }
            }
            finally {
                GatedStreamSinkChannel.safeUnpark(next);
            }
        }
        this.delegate.awaitWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        long t = timeUnit.toNanos(time);
        if (Bits.allAreClear((int)this.state, (int)48)) {
            Thread next = waiterUpdater.getAndSet(this, Thread.currentThread());
            try {
                long now = System.nanoTime();
                while (Bits.allAreClear((int)this.state, (int)48)) {
                    if (t <= 0L) {
                        return;
                    }
                    long start = now;
                    LockSupport.parkNanos(this, t);
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedIOException();
                    }
                    now = System.nanoTime();
                    t -= now - start;
                }
            }
            finally {
                GatedStreamSinkChannel.safeUnpark(next);
            }
        }
        this.delegate.awaitWritable(t, TimeUnit.NANOSECONDS);
    }

    public boolean isOpen() {
        return Bits.allAreClear((int)this.state, (int)16);
    }

    public boolean supportsOption(Option<?> option) {
        return Bits.allAreSet((int)this.config, (int)1) && this.delegate.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)(Bits.allAreSet((int)this.config, (int)1) ? this.delegate.getOption(option) : null);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)(Bits.allAreSet((int)this.config, (int)1) ? this.delegate.setOption(option, value) : null);
    }

    private static void safeUnpark(Thread waiter) {
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    public StreamSinkChannel getChannel() {
        return Bits.allAreSet((int)this.state, (int)32) ? this.delegate : this;
    }
}

