/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.api;

import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.util.ConstructorInstanceFactory;
import java.lang.reflect.Constructor;
import java.util.EventListener;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

public class ListenerInfo {
    private static final Class[] LISTENER_CLASSES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class};
    private final Class<? extends EventListener> listenerClass;
    private final InstanceFactory<? extends EventListener> instanceFactory;

    public ListenerInfo(Class<? extends EventListener> listenerClass, InstanceFactory<? extends EventListener> instanceFactory) {
        this.listenerClass = listenerClass;
        this.instanceFactory = instanceFactory;
        boolean ok = false;
        for (Class c : LISTENER_CLASSES) {
            if (!c.isAssignableFrom(listenerClass)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw UndertowServletMessages.MESSAGES.listenerMustImplementListenerClass(listenerClass);
        }
    }

    public ListenerInfo(Class<? extends EventListener> listenerClass) {
        this.listenerClass = listenerClass;
        try {
            Constructor<? extends EventListener> ctor = listenerClass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            this.instanceFactory = new ConstructorInstanceFactory<EventListener>(ctor);
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.componentMustHaveDefaultConstructor("Listener", listenerClass);
        }
    }

    public InstanceFactory<? extends EventListener> getInstanceFactory() {
        return this.instanceFactory;
    }

    public Class<?> getListenerClass() {
        return this.listenerClass;
    }
}

